/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.profile;

import com.swimap.iview.commstyle.commini.IProfileParserGui;
import com.swimap.iview.profile.RemoteProfileParserRpc;
import com.swimap.iview.profile.localPersistence.GuiProfile;
import com.swimap.iview.profile.localPersistence.JdbcSqlit;
import com.swimap.iview.profile.localPersistence.ZipContent;
import com.swimap.iview.util.log.IviewLogger;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class GUIProfileParser
implements IProfileParserGui {
    private static final IviewLogger log = IviewLogger.getLogger(GUIProfileParser.class, (String)"FRM");
    private static final long MAX_TIME_INTERVAL = 1800000L;
    private static final int MAX_FILE_CHANGE_NUM = 5;
    private long lastWriteTime;
    private ExecutorService pool;
    private JdbcSqlit jdbcSqlit;
    private int changedFileCount;
    private boolean hasLogout = true;

    public String read(String fileName) throws FileNotFoundException {
        if (this.hasLogout) {
            throw new FileNotFoundException("Parser has closed, failed read file:" + fileName);
        }
        log.info((Object)("sys | read | [fileName]=" + fileName));
        try {
            GuiProfile localGui = new GuiProfile();
            localGui.setFileName(fileName);
            this.jdbcSqlit.getContent(localGui);
            if (localGui.getContent() == null) {
                this.readFromRemote(localGui);
            }
            return localGui.getContent();
        }
        catch (Exception e) {
            log.error((Object)"some error occured when read or insert the data into local db", (Throwable)e);
            throw new FileNotFoundException("SqlExcetion occured");
        }
    }

    public void write(String content, String fileName) throws IOException {
        if (this.hasLogout) {
            throw new IOException("Parser has closed, failed write file:" + fileName);
        }
        log.info((Object)("sys | write | [fileName]=" + fileName));
        fileName = fileName.replace('\\', '/');
        GuiProfile localGui = new GuiProfile();
        localGui.setChanged(true);
        localGui.setContent(content);
        localGui.setFileName(fileName);
        try {
            this.jdbcSqlit.update(localGui);
        }
        catch (Exception e) {
            log.error((Object)"fail to write the gui data to local", (Throwable)e);
            throw new IOException("fail to write the gui data to local", e);
        }
        ++this.changedFileCount;
        if (this.shouldWriteToRemote()) {
            this.writeData(true);
        }
    }

    public void destroy() {
        try {
            this.writeData(false);
            this.jdbcSqlit.destroy();
            this.hasLogout = true;
            this.pool.shutdownNow();
            this.pool = null;
        }
        catch (Throwable e) {
            log.error((Object)"fail to write data to remote or destroy the local data", e);
        }
    }

    private boolean shouldWriteToRemote() {
        if (this.changedFileCount > 5) {
            return true;
        }
        return System.currentTimeMillis() - this.lastWriteTime > 1800000L;
    }

    private void writeData(boolean writeToLocal) throws IOException {
        HashMap<String, Object> fileData = new HashMap<String, Object>();
        try {
            List<GuiProfile> list = this.jdbcSqlit.getHasChanged();
            for (GuiProfile localGui : list) {
                log.info((Object)("write the fileName " + localGui.getFileName() + "to remote."));
                byte[] bytes = ZipContent.compress(localGui.getContent());
                fileData.put(localGui.getFileName(), bytes);
                if (!writeToLocal) continue;
                localGui.setChanged(false);
                this.jdbcSqlit.update(localGui);
            }
        }
        catch (Exception e) {
            log.error((Object)"fail to get data from local database", (Throwable)e);
            throw new IOException("fail to get data from local database", e);
        }
        this.changedFileCount = 0;
        this.lastWriteTime = System.currentTimeMillis();
        if (writeToLocal) {
            this.executeWriteThread(fileData);
        } else {
            this.writeDataToRemote(fileData);
        }
    }

    private void readFromRemote(GuiProfile localGui) throws FileNotFoundException, SQLException {
        try {
            byte[] content = RemoteProfileParserRpc.getInstance().getProfile(localGui.getFileName());
            localGui.setContent(ZipContent.decompression(content));
        }
        catch (IOException e) {
            log.error((Object)"fail to decompression the content", (Throwable)e);
            throw new FileNotFoundException("fail to decompression the content");
        }
        catch (Exception e) {
            log.error((Object)"read file from server faild", (Throwable)e);
            throw new FileNotFoundException("RPCError");
        }
        finally {
            try {
                this.jdbcSqlit.insert(localGui);
            }
            catch (Exception e) {
                log.error((Object)"insert faild:", (Throwable)e);
            }
        }
    }

    private void executeWriteThread(final Map<String, Object> fileData) {
        this.pool.execute(new Runnable(){

            @Override
            public void run() {
                GUIProfileParser.this.writeDataToRemote(fileData);
            }
        });
    }

    private void writeDataToRemote(Map<String, Object> fileData) {
        if (fileData.isEmpty()) {
            return;
        }
        try {
            log.info((Object)"start to write the files to remote");
            RemoteProfileParserRpc.getInstance().saveProfile(fileData, 2);
            log.info((Object)"finish writing the files to remote");
        }
        catch (Exception e) {
            log.error((Object)"RPC error occurred, fail to wirte the files to remote", (Throwable)e);
        }
    }

    public void initialize() {
        this.lastWriteTime = System.currentTimeMillis();
        this.changedFileCount = 0;
        this.pool = Executors.newFixedThreadPool(1);
        try {
            this.jdbcSqlit = new JdbcSqlit();
            this.hasLogout = false;
        }
        catch (Throwable e) {
            log.error((Object)"fail to create instance of GUIProfileParser", e);
            this.hasLogout = true;
        }
    }
}

