/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.clientutil;

import com.swimap.external.sm.client.base.SessionService;
import com.swimap.external.sm.client.base.common.model.RightInfo;
import com.swimap.iview.util.SyncCommand;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.sm.client.base.AuthorizationService;

public class ClientUtilProxy {
    private static final IviewLogger log = IviewLogger.getLogger(ClientUtilProxy.class, (String)"FRM");

    public boolean checkRight(String rightID) {
        final RightInfo[] infos = new RightInfo[]{new RightInfo("APPLICATION", "SystemMaintenance", "", rightID)};
        try {
            Exception ex;
            SyncCommand syn = new SyncCommand(){

                public Object call() throws Exception {
                    boolean[] infoResults = AuthorizationService.getInstance().checkRight(infos);
                    return infoResults;
                }
            };
            if (!syn.startCall() && (ex = syn.getException()) != null) {
                throw ex;
            }
            boolean[] infoResults = (boolean[])syn.getResult();
            return infoResults[0];
        }
        catch (Exception e) {
            log.error((Object)e.toString(), (Throwable)e);
            return false;
        }
    }

    public int[] checkRightwithErrorCode(String rightName) {
        int[] infoResults = new int[1];
        try {
            Exception ex;
            final RightInfo[] infos = new RightInfo[]{new RightInfo("APPLICATION", "SystemMaintenance", "", rightName)};
            SyncCommand syn = new SyncCommand(){

                public Object call() throws Exception {
                    int[] infoResults = AuthorizationService.getInstance().checkRightWithErrorCode(infos);
                    return infoResults;
                }
            };
            if (!syn.startCall() && (ex = syn.getException()) != null) {
                throw ex;
            }
            infoResults = (int[])syn.getResult();
        }
        catch (Exception e) {
            log.error((Object)e.toString(), (Throwable)e);
        }
        return infoResults;
    }

    public String getCurUserName() {
        return SessionService.getInstance().getCurUserName();
    }

    public String getCurTerminalID() {
        return SessionService.getInstance().getCurTerminalID();
    }

    public int getCurSessionID() {
        return SessionService.getInstance().getCurSessionID();
    }
}

