/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.clientutil;

import com.swimap.base.rpc.InternalErrorUtil;
import com.swimap.external.cbb.baseutil.CipherCommon;
import com.swimap.external.dsf.base.rpc.NATUtility;
import com.swimap.external.dsf.base.rpc.RpcErrorSecurity;
import com.swimap.external.dsf.base.rpc.RpcMessage;
import com.swimap.external.dsf.base.rpc.RpcNaming;
import com.swimap.external.dsf.base.rpc.RpcRequest;
import com.swimap.external.dsf.base.rpc.RpcResponse;
import com.swimap.external.sf.clientutil.IClientUtilModule;
import com.swimap.external.sf.ssl.IOption;
import com.swimap.external.sf.ssl.SSLManager;
import com.swimap.external.sf.sys.viewframework.tzdstregister.TZDSTRegistry;
import com.swimap.iview.broadcast.BroadCastServerPushClient;
import com.swimap.iview.broadcast.BroadcastMsgDlg;
import com.swimap.iview.broadcast.BroadcastRpc;
import com.swimap.iview.clientutil.ClientStartItem;
import com.swimap.iview.clientutil.ClientUtilProxy;
import com.swimap.iview.clientutil.ServerInfoRPC;
import com.swimap.iview.communicate.CommManager;
import com.swimap.iview.communicate.SSLConnector;
import com.swimap.iview.framework.Main;
import com.swimap.iview.framework.mainframe.MDIFrame;
import com.swimap.iview.framework.modulemanagement.BaseModule;
import com.swimap.iview.framework.modulemanagement.ModuleManagementException;
import com.swimap.iview.framework.modulemanagement.ModuleManager;
import com.swimap.iview.framework.pluginmanagement.PluginManager;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.hedex.HedexRpc;
import com.swimap.iview.profile.RemoteProfileParser;
import com.swimap.iview.systemmgr.SystemMgrServicePushClient;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.SyncCommand;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.iview.viewframework.systemsettings.RegionSettings;
import imap.external.iMAPcommon.HedexConfigUtil;
import imap.iMAPcommon.CommonTool;
import java.awt.Component;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.net.ssl.SSLContext;
import javax.swing.SwingUtilities;
import org.omg.CORBA.ORB;

public class ClientUtilModule
extends BaseModule
implements IClientUtilModule {
    private static final IviewLogger log = IviewLogger.getLogger(ClientUtilModule.class, (String)"FRM");
    private static final String USED_LOCAL_IP_ENV = "USED_LOCAL_IP_ENV";
    public static final String MODULE_NAME = "ClientUtilModule";
    private static ClientUtilModule instance = null;
    private BroadCastServerPushClient broadCastServerPushClient = null;
    private BroadcastMsgDlg broadcastDlg = null;
    private ModuleManager moduleMgr = null;
    private static Map<String, String> ipMap = new HashMap<String, String>(3);
    private ClientUtilProxy clientUtilProxy = null;
    private static boolean indexInc = false;
    private ServerInfoRPC serverInfoRPC = new ServerInfoRPC();
    private SystemMgrServicePushClient systemMgrServicePushClient = new SystemMgrServicePushClient();
    private static String loginIP = "";
    private static boolean enableSSL = false;
    private static ResourceBundle res = null;
    private static final char[] specialCharacterArray = new char[]{'0', '!', '\"', '#', '$', '%', '&', '`', '(', ')', '*', '+', ',', '-', '.', '/', ':', ';', '<', '=', '>', '?', '@', '[', '\\', ']', '^', '_', '\'', '{', '|', '}', '~'};
    private static final String EMIPKEY = "imap.em.ip";
    private static final String EMPORTKEY = "imap.em.port";
    private static final String EMURLKEY = "imap.url.em";
    private static final String CORBAIPKEY = "imap.corba.ip";
    private static final String CORBAPORTKEY = "imap.corba.port";
    private static final String CORBAURLKEY = "imap.url.orb";
    private static final String MRBIPKEY = "imap.mrb.ip";
    private static final String MRBPORTKEY = "imap.mrb.port";
    private static final String MRBURLKEY = "imap.url.mrb";
    private static final String ReturnValue_Windows = "Windows";
    private static final String ReturnValue_Solaris = "Solaris";
    private static final String Value_Linux = "linux";
    private static final String Value_Solaris = "solaris";
    private static final String Property_IMAP_OS_TYPE = "imap.os.type";
    private static final String Property_IMAP_IS_WINDOWS = "imap.os.isWindows";

    public static String getString(String key) {
        if (res == null) {
            try {
                res = PluginManager.getInstance().getPlugin(MODULE_NAME).getResource().getResourceBundleFromPropertyFile("Res");
            }
            catch (Exception e) {
                log.error((Object)e.toString(), (Throwable)e);
            }
        }
        try {
            return res == null ? key : res.getString(key);
        }
        catch (Exception e) {
            return key;
        }
    }

    public static void setInstance(ClientUtilModule clientUtilModule) {
        instance = clientUtilModule;
    }

    public static ClientUtilModule getInstance() {
        return instance;
    }

    public ClientUtilModule(ModuleManager _moduleMgr, ORB orbRef, String terminalIdValue, String instanceIdValue) throws ModuleManagementException {
        super(_moduleMgr, orbRef, terminalIdValue, instanceIdValue);
        this.register(this);
        this.setHedexIpAndPort();
        this.setServerEncoding();
        this.setFileNameEncoding();
        instance = this;
        this.moduleMgr = _moduleMgr;
        this.clientUtilProxy = new ClientUtilProxy();
        TZDSTRegistry.getInstance().registerTimeZoneDST();
        this.systemMgrServicePushClient.open();
    }

    private void setServerEncoding() {
        String encoding = this.serverInfoRPC.getServerEncoding();
        if (null != encoding) {
            System.setProperty("ServerEncoding", encoding);
        }
    }

    private void setFileNameEncoding() {
        String encoding = System.getProperty("ServerEncoding");
        boolean userUTF = Boolean.getBoolean("iscript.filename.use.utf8");
        if (userUTF) {
            encoding = "UTF-8";
        }
        if (null != encoding && !encoding.isEmpty()) {
            System.setProperty("Client_fileName_Encoding", encoding);
        }
    }

    public String[] getHedexIpAndPort() {
        try {
            String[] result = HedexRpc.getInstance().getHedexIpAndPort();
            String hedexIP = result[0];
            hedexIP = ClientUtilModule.getValidIP(hedexIP, 0);
            if (null != hedexIP) {
                result[0] = hedexIP;
            }
            return result;
        }
        catch (Exception e) {
            log.error((Object)e.toString(), (Throwable)e);
            return null;
        }
    }

    private void setHedexIpAndPort() {
        String[] address = this.getHedexIpAndPort();
        if (address != null) {
            HedexConfigUtil.getInstance().setHedexIpAndPort(loginIP, address);
        }
    }

    public void postSequencedInit() {
        try {
            RegionSettings.getInstance().registerSystemSettingsPage(this.moduleMgr);
        }
        catch (Exception e) {
            log.error((Object)e.toString(), (Throwable)e);
        }
    }

    public void stop() {
        RemoteProfileParser.clearFileIndex();
        if (this.broadCastServerPushClient != null) {
            this.broadCastServerPushClient.close();
            this.broadCastServerPushClient = null;
        }
        RegionSettings.getInstance().clear();
        this.systemMgrServicePushClient.close();
        TZDSTRegistry.getInstance().setDefaultTimeZone();
        TZDSTRegistry.getInstance().unregisterTimeZoneDST();
    }

    public void launchBroadCastSendDialog() throws Exception {
        if (!this.checkSevice()) {
            return;
        }
        MDIFrame mainFrame = (MDIFrame)FrameworkUtilities.getMainFrame();
        int[] returnValue = this.checkRightwithErrorCode("Broadcast message");
        if (null == returnValue || returnValue.length <= 0) {
            log.info((Object)"sys | launchBroadCastSendDialog | checkRightwithErrorCode returnValue is null or returnValue.length <= 0.");
            OptionPane.showMessageDialog((Component)mainFrame, (Object)ClientUtilModule.getString("AuthenticationFail"));
            return;
        }
        if (returnValue[0] == 0) {
            OptionPane.showMessageDialog((Component)mainFrame, (Object)ClientUtilModule.getString("AuthenticationFail"));
            return;
        }
        if (returnValue[0] < 0) {
            OptionPane.showMessageDialog((Component)mainFrame, (Object)ClientUtilModule.getString("authentication_failed"));
            return;
        }
        this.broadcastDlg = new BroadcastMsgDlg(FrameworkUtilities.getMainFrame());
        ScreenToolKit.centerLocateToScreen((Component)this.broadcastDlg);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ClientUtilModule.this.broadcastDlg.setVisible(true);
            }
        });
    }

    public boolean checkSevice() {
        try {
            BroadcastRpc.getInstance().getBroadcastMsgList(1);
        }
        catch (Exception e) {
            log.error((Object)e.toString(), (Throwable)e);
            String message = e instanceof RpcErrorSecurity ? ClientUtilModule.getString("authentication_failed") : ClientUtilModule.getString("Net_Noexsit");
            OptionPane.showMessageDialog((Component)FrameworkUtilities.getMainFrame(), (Object)message);
            return false;
        }
        return true;
    }

    public void freshMsgArea() {
        if (null != this.broadcastDlg && this.broadcastDlg.isVisible()) {
            this.broadcastDlg.freshMessageArea();
        }
    }

    public boolean checkRight(String rightID) {
        return this.clientUtilProxy.checkRight(rightID);
    }

    public int[] checkRightwithErrorCode(String rightName) {
        return this.clientUtilProxy.checkRightwithErrorCode(rightName);
    }

    public String getModuleName() {
        return MODULE_NAME;
    }

    public static String initConnectionParam(String dsServerIP, String dsServerPort, boolean enableSSL) throws Exception {
        try {
            log.info((Object)("sys | initConnectionParam | dsServerIP:" + dsServerIP + ", dsServerPort:" + dsServerPort + ", enableSSL:" + enableSSL));
            System.setProperty(USED_LOCAL_IP_ENV, "");
            String namingAddress = ClientUtilModule.initRpcNamingAddress(dsServerIP, dsServerPort, enableSSL);
            log.info((Object)"sys | initConnectionParam | initRpcNamingAddress end.");
            return namingAddress;
        }
        catch (Exception e) {
            log.error((Object)e.toString(), (Throwable)e);
            throw e;
        }
    }

    private static void setEmToken() {
        try {
            RpcRequest request = RpcNaming.createRequest((String)"sys.manage.systemmonitor.ds.getAuthMdid");
            RpcResponse rsp = request.invoke();
            RpcMessage msg = rsp.getMessage();
            if (msg != null && msg.getInt("result") == 0) {
                byte[] tokens = msg.getByteArray("authMdid");
                System.setProperty("imap.token", new String(CipherCommon.encodeEncryptedText((byte[])tokens)));
            } else {
                log.error((Object)"Failed to abtain EM token.");
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed set EM token", (Throwable)e);
        }
    }

    public static void postInitConnectionParam() throws Exception {
        try {
            ipMap.clear();
            NATUtility.clearNatConfiguration();
            RemoteProfileParser.clearFileIndex();
            boolean use_all_ip = CommonTool.isUseAllIP();
            int timeout = CommonTool.getTimeOutTime();
            int times = CommonTool.getTryToConnectTimes();
            RpcRequest request = RpcNaming.createRequest((String)"naming.getAddressInfo");
            RpcResponse rsp = request.invoke();
            RpcMessage msg = rsp.getMessage();
            if (rsp.getInternalErrorCode() != 0) {
                InternalErrorUtil.printInternalError((String)"DSF", (RpcResponse)rsp);
            }
            ClientUtilModule.initParameter(msg, EMIPKEY, EMPORTKEY, EMURLKEY, enableSSL, loginIP, use_all_ip, timeout, times);
            ClientUtilModule.initParameter(msg, CORBAIPKEY, CORBAPORTKEY, CORBAURLKEY, enableSSL, loginIP, use_all_ip, timeout, times);
            ClientUtilModule.initParameter(msg, MRBIPKEY, MRBPORTKEY, MRBURLKEY, enableSSL, loginIP, use_all_ip, timeout, times);
            ClientUtilModule.validateIps();
            ClientUtilModule.setPropertySystemType();
            String mdpServerIP = System.getProperty(MRBIPKEY);
            int mdpServerPort = Integer.parseInt(System.getProperty(MRBPORTKEY));
            CommManager commManager = (CommManager)Main.instance().getModuleManager().getLocalReference("communicateservice");
            log.info((Object)("sys | initConnectionParam | setServerIPAndPort mdpServerIP:mdpServerPort =" + mdpServerIP + ':' + mdpServerPort));
            commManager.setServerIPAndPort(mdpServerIP, mdpServerPort);
            if (enableSSL) {
                SSLConnector mySSLConnector = new SSLConnector();
                SSLManager manager = SSLManager.defaultClientManager();
                mySSLConnector.setSocketFactory(manager.getSSLSocketFactory());
                commManager.setSSLConnector(mySSLConnector);
            } else {
                commManager.setSSLConnector(null);
            }
            ClientUtilModule.setEmToken();
            ClientStartItem clientStartItem = new ClientStartItem();
            FrameworkUtilities.setStartupElements(clientStartItem.getIStartupElements());
        }
        catch (Exception e) {
            log.error((Object)e.toString(), (Throwable)e);
            throw e;
        }
    }

    private static void validateIps() {
        log.info((Object)"Validating ds set mrb, corba and em ips");
        ClientUtilModule.validateIPPort(EMIPKEY, EMPORTKEY);
        ClientUtilModule.validateIPPort(CORBAIPKEY, CORBAPORTKEY);
        ClientUtilModule.validateIPPort(MRBIPKEY, MRBPORTKEY);
    }

    private static void validateIPPort(String ipKey, String portKey) {
        String ip = System.getProperty(ipKey);
        String tempIP = "";
        try {
            if (ipMap.containsKey(ip)) {
                tempIP = ipMap.get(ip);
                if (null != tempIP) {
                    log.info((Object)(ipKey + ":---" + tempIP));
                    System.setProperty(ipKey, tempIP);
                }
            } else {
                tempIP = ClientUtilModule.getValidIP(ip, Integer.parseInt(System.getProperty(portKey)));
                ipMap.put(ip, tempIP);
                if (null != tempIP) {
                    log.info((Object)(ipKey + ":---" + tempIP));
                    System.setProperty(ipKey, tempIP);
                }
            }
        }
        catch (NumberFormatException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private static void setPropertySystemType() {
        String osInfo = BroadcastRpc.getInstance().getOSInfo();
        log.info((Object)("ClientUtilModule | setPropertySystemType | osInfo:" + osInfo));
        String value = ReturnValue_Solaris.equals(osInfo) ? Value_Solaris : Value_Linux;
        System.setProperty(Property_IMAP_OS_TYPE, value);
        boolean isWindows = ReturnValue_Windows.equals(osInfo);
        System.setProperty(Property_IMAP_IS_WINDOWS, String.valueOf(isWindows));
    }

    private static String initRpcNamingAddress(String dsServerIP, String dsServerPort, boolean isEnableSSL) throws Exception {
        Exception ex;
        loginIP = dsServerIP;
        enableSSL = isEnableSSL;
        String namingAddress = "";
        namingAddress = enableSSL ? "tcps://" : "tcp://";
        namingAddress = namingAddress + dsServerIP + ':' + dsServerPort + "/naming";
        final String tempNameingAddress = namingAddress;
        SyncCommand syn = new SyncCommand(){

            public Object call() throws Exception {
                if (enableSSL) {
                    SSLManager manager = SSLManager.defaultClientManager();
                    SSLContext sslContext = manager.getSSLContext();
                    IOption option = manager.getOption();
                    System.setProperty("imap.ssl.encryptLevel", option.getEncryptLevel());
                    System.setProperty("imap.ssl.authPeer", String.valueOf(option.isEnableAuthPeer()));
                    System.setProperty("imap.ssl.loadDH", String.valueOf(option.isLoadDH()));
                    RpcNaming.setNamingService((String)tempNameingAddress, (SSLContext)sslContext);
                } else {
                    RpcNaming.setNamingService((String)tempNameingAddress);
                }
                return "";
            }
        };
        if (!syn.startCall() && (ex = syn.getException()) != null) {
            throw ex;
        }
        System.setProperty("imap.enableSSL", String.valueOf(enableSSL));
        return namingAddress;
    }

    private static void initParameter(RpcMessage msg, String ipKey, String portKey, String urlKey, boolean enableSSL, String dsServerIP, boolean use_all_ip, int timeout, int times) {
        try {
            boolean connectResult;
            String[] urls = msg.getString(urlKey).split(";");
            URI uri = null;
            uri = enableSSL ? new URI(urls[1]) : new URI(urls[0]);
            int port = uri.getPort();
            System.setProperty(portKey, Integer.toString(port));
            log.info((Object)("sys | parseParameter | " + portKey + ':' + port));
            String ip = uri.getHost().trim();
            if (use_all_ip && !CORBAPORTKEY.equals(portKey) && (connectResult = CommonTool.tryToConnect((String)dsServerIP, (int)port, (int)timeout, (int)times))) {
                ip = dsServerIP;
                if (MRBPORTKEY.equals(portKey)) {
                    log.info((Object)("sys | parseParameter | imap.corba.ip:" + ip));
                    System.setProperty(CORBAIPKEY, ip);
                }
            }
            log.info((Object)("sys | parseParameter | " + ipKey + ':' + ip));
            System.setProperty(ipKey, ip);
        }
        catch (Exception e) {
            log.error((Object)e.toString(), (Throwable)e);
        }
    }

    public ClientUtilProxy getClientUtilProxy() {
        return this.clientUtilProxy;
    }

    public static RpcResponse invoker(final RpcRequest req) throws Exception {
        Exception ex;
        SyncCommand syn = new SyncCommand(){

            public Object call() throws Exception {
                RpcResponse rsp = req.invoke();
                return rsp;
            }
        };
        if (!syn.startCall() && (ex = syn.getException()) != null) {
            throw ex;
        }
        return (RpcResponse)syn.getResult();
    }

    protected void lowPriorityInitAfterLoaded() {
        this.broadCastServerPushClient = new BroadCastServerPushClient();
        this.broadCastServerPushClient.open();
    }

    public static String specialName2FileName(String srcStr) {
        log.error((Object)("ClientUtilModule | specialName2FileName | before: " + srcStr));
        srcStr = srcStr.replace("0", "00");
        srcStr = srcStr.replace("!", "01");
        srcStr = srcStr.replace("\"", "02");
        srcStr = srcStr.replace("#", "03");
        srcStr = srcStr.replace("$", "04");
        srcStr = srcStr.replace("%", "05");
        srcStr = srcStr.replace("&", "06");
        srcStr = srcStr.replace("`", "07");
        srcStr = srcStr.replace("(", "08");
        srcStr = srcStr.replace(")", "09");
        srcStr = srcStr.replace("*", "0A");
        srcStr = srcStr.replace("+", "0B");
        srcStr = srcStr.replace(",", "0C");
        srcStr = srcStr.replace("-", "0D");
        srcStr = srcStr.replace(".", "0E");
        srcStr = srcStr.replace("/", "0F");
        srcStr = srcStr.replace(":", "0G");
        srcStr = srcStr.replace(";", "0H");
        srcStr = srcStr.replace("<", "0I");
        srcStr = srcStr.replace("=", "0J");
        srcStr = srcStr.replace(">", "0K");
        srcStr = srcStr.replace("?", "0L");
        srcStr = srcStr.replace("@", "0M");
        srcStr = srcStr.replace("[", "0N");
        srcStr = srcStr.replace("\\", "0O");
        srcStr = srcStr.replace("]", "0P");
        srcStr = srcStr.replace("^", "0Q");
        srcStr = srcStr.replace("_", "0R");
        srcStr = srcStr.replace("'", "0S");
        srcStr = srcStr.replace("{", "0T");
        srcStr = srcStr.replace("|", "0U");
        srcStr = srcStr.replace("}", "0V");
        srcStr = srcStr.replace("~", "0W");
        log.error((Object)("ClientUtilModule | specialName2FileName | after: " + srcStr));
        return srcStr;
    }

    public static String fileName2SpeckalName(String encodedFileName) {
        log.error((Object)("ClientUtilModule | fileName2SpeckalName | before: " + encodedFileName));
        char[] encodedFileNameCharArray = encodedFileName.toCharArray();
        StringBuffer decodedFileName = new StringBuffer();
        for (int i = 0; i < encodedFileNameCharArray.length; ++i) {
            if (i < encodedFileNameCharArray.length - 1) {
                String decodedString = ClientUtilModule.decode(encodedFileNameCharArray[i], encodedFileNameCharArray[i + 1]);
                if (indexInc) {
                    ++i;
                    indexInc = false;
                }
                decodedFileName.append(decodedString);
                continue;
            }
            decodedFileName.append(encodedFileNameCharArray[i]);
        }
        log.error((Object)("ClientUtilModule | fileName2SpeckalName | after: " + decodedFileName));
        return decodedFileName.toString();
    }

    private static String decode(char ch1, char ch2) {
        int index;
        if (ch1 == '0' && (index = ClientUtilModule.getSpecialCharacterArrayIndex(ch2)) != -1) {
            indexInc = true;
            return "" + specialCharacterArray[index];
        }
        return ch1 + "";
    }

    private static int getSpecialCharacterArrayIndex(char ch) {
        int index = -1;
        if (ch >= '0') {
            if (ch <= '9') {
                index = ch - 48;
            } else if (ch > '9' && ch < 'X') {
                index = ch - 65 + 10;
            }
        }
        return index;
    }

    public static String getVaildIPAddress(String ipAddress, int port) {
        String validIP = NATUtility.getValidIp((String)ipAddress);
        if (!"".equals(validIP) && null != validIP) {
            log.info((Object)("getVaildIPAddress is " + validIP));
            return validIP;
        }
        return ipAddress;
    }

    public static String getValidIP(String ip, int port) {
        String equalIP = NATUtility.getValidIpUsageCfg((String)ip, null);
        if (!"".equals(equalIP) && null != equalIP) {
            log.info((Object)("getValidIP is " + equalIP));
            return equalIP;
        }
        return ClientUtilModule.getVaildIPAddress(ip, port);
    }

    public static String getIpByKey(String inip, String key) {
        log.info((Object)("IP passed is: " + inip + " key passed: " + key));
        String ip = NATUtility.getValidIpByKey((String)inip, (String)key);
        log.info((Object)("IP returned : " + ip));
        return ip;
    }
}

