/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.clientutil;

import com.swimap.external.dsf.base.rpc.DataRecord;
import com.swimap.external.dsf.base.rpc.DataTable;
import com.swimap.external.dsf.base.rpc.RpcMessage;
import com.swimap.external.dsf.base.rpc.RpcNaming;
import com.swimap.external.dsf.base.rpc.RpcRequest;
import com.swimap.external.dsf.base.rpc.RpcResponse;
import com.swimap.iview.clientutil.ServiceDependency;
import com.swimap.iview.clientutil.ServiceGroup;
import com.swimap.iview.clientutil.ServiceInfo;
import com.swimap.iview.clientutil.StartupElementInfo;
import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.xmlbind.PARA;
import com.swimap.iview.framework.subsystemmanagement.SubsystemManager;
import com.swimap.iview.framework.util.IStartupElement;
import com.swimap.iview.framework.util.StartupFactory;
import com.swimap.iview.util.log.IviewLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClientStartItem {
    private static final IviewLogger log = IviewLogger.getLogger(ClientStartItem.class, (String)"FRM");
    private static final String SUBSYSTEMGROUP_DESC = "subSystemGroup";
    private static final String USER_DIR = System.getProperty("user.dir");
    private static final String SERVICEPLUGIN_SUFF = "_serviceplugins.xml";
    private static final String SERVICEPLUGIN_DIR = "serviceload";
    private static Set<String> displaySubsystemMenuSet = new HashSet<String>();
    private static Set<String> displayPluginMenuSet = new HashSet<String>();
    private Map<String, ServiceDependency> serviceMap = new HashMap<String, ServiceDependency>();
    private Map<String, ServiceGroup> serviceGroups = new HashMap<String, ServiceGroup>();
    private static final String SERVICE_DESC = "service";
    private static final String SUBSYSTEMS_DESC = "subsystems";
    private static final String PLUGINS_DESC = "plugins";
    private static final String FEATURES_DESC = "features";

    List<IStartupElement> getIStartupElements() {
        StartupElementInfo iStartupElement;
        ArrayList<IStartupElement> list = new ArrayList<IStartupElement>();
        Set<String> pluginSet = this.getAllPlugin();
        Set<String> linkSet = this.getAllLink();
        HashSet<String> basicLinkSet = new HashSet<String>();
        List<ServiceInfo> serviceInfos = this.getServiceInfos();
        if (serviceInfos.size() != 0) {
            this.readServicepluginsXml();
            for (ServiceDependency serviceDep : this.serviceMap.values()) {
                pluginSet.removeAll(serviceDep.getPluginSet());
                linkSet.removeAll(serviceDep.getLinkSet());
            }
            for (ServiceInfo serviceInfo : serviceInfos) {
                ServiceDependency serviceDep = this.serviceMap.get(serviceInfo.getServiceType());
                if (serviceDep == null) continue;
                pluginSet.addAll(serviceDep.getPluginSet());
                linkSet.addAll(serviceDep.getLinkSet());
            }
            block2: for (ServiceGroup serviceGroup : this.serviceGroups.values()) {
                for (String str : linkSet) {
                    if (!serviceGroup.getLinkSet().contains(str)) continue;
                    basicLinkSet.addAll(serviceGroup.getLinkSet());
                    pluginSet.addAll(serviceGroup.getPluginSet());
                    continue block2;
                }
            }
            basicLinkSet.removeAll(linkSet);
        }
        displaySubsystemMenuSet.clear();
        displaySubsystemMenuSet.addAll(linkSet);
        displayPluginMenuSet.clear();
        displayPluginMenuSet.addAll(pluginSet);
        StringBuilder sb = new StringBuilder();
        sb.append("load plugin:\n");
        for (String str : pluginSet) {
            iStartupElement = new StartupElementInfo(str, 1);
            list.add(iStartupElement);
            sb.append(str).append("\n");
        }
        sb.append("load link:\n");
        for (String str : linkSet) {
            iStartupElement = new StartupElementInfo(str, 3);
            list.add(iStartupElement);
            sb.append(str).append("\n");
        }
        sb.append("load basic link:\n");
        for (String str : basicLinkSet) {
            iStartupElement = new StartupElementInfo(str, 4);
            list.add(iStartupElement);
            sb.append(str).append("\n");
        }
        log.info((Object)sb.toString());
        return list;
    }

    private List<String> getServicePluginsFile() {
        String[] fileList;
        File file = new File(SERVICEPLUGIN_DIR);
        ArrayList<String> list = new ArrayList<String>();
        if (!file.isDirectory()) {
            return list;
        }
        for (String str : fileList = file.list()) {
            if (!str.endsWith(SERVICEPLUGIN_SUFF)) continue;
            list.add(str);
        }
        return list;
    }

    private void readServicepluginsXml() {
        List<String> fileList = this.getServicePluginsFile();
        for (String str : fileList) {
            StringBuilder sb = new StringBuilder();
            sb.append(USER_DIR).append(File.separator).append(SERVICEPLUGIN_DIR).append(File.separator).append(str);
            String file = sb.toString();
            CommStyleInfo comstryleInfo = CommStyleManager.getInstance().getAbsCommStyleFile(file);
            AreaDescContainer areaDe = comstryleInfo.getAreaDescContainer(0);
            this.getServiceDependency(areaDe);
            this.getServiceGroup(areaDe);
        }
    }

    private void getServiceDependency(AreaDescContainer areaDe) {
        DescContainer desc = areaDe.getDescContainer(SERVICE_DESC);
        if (desc == null) {
            return;
        }
        DescContainer[] descContainers = desc.getDescContainer();
        if (descContainers == null) {
            return;
        }
        for (DescContainer descContainer : descContainers) {
            ServiceDependency serviceDep;
            String serviceType = descContainer.getDescName();
            if (this.serviceMap.get(serviceType) == null) {
                serviceDep = new ServiceDependency();
                serviceDep.setPluginSet(this.getAllPluginFromXml(descContainer));
                serviceDep.setLinkSet(this.getPARANames(descContainer.getDescContainer(SUBSYSTEMS_DESC)));
                this.serviceMap.put(serviceType, serviceDep);
                continue;
            }
            serviceDep = this.serviceMap.get(serviceType);
            serviceDep.getPluginSet().addAll(this.getAllPluginFromXml(descContainer));
            serviceDep.getLinkSet().addAll(this.getPARANames(descContainer.getDescContainer(SUBSYSTEMS_DESC)));
        }
    }

    private void getServiceGroup(AreaDescContainer areaDe) {
        DescContainer desc = areaDe.getDescContainer(SUBSYSTEMGROUP_DESC);
        if (desc == null) {
            return;
        }
        DescContainer[] descContainers = desc.getDescContainer();
        if (descContainers == null) {
            return;
        }
        for (DescContainer descContainer : descContainers) {
            ServiceGroup serviceGroup;
            String serviceGroupName = descContainer.getDescName();
            if (this.serviceGroups.get(serviceGroupName) == null) {
                serviceGroup = new ServiceGroup();
                serviceGroup.setPluginSet(this.getAllPluginFromXml(descContainer));
                serviceGroup.setLinkSet(this.getPARANames(descContainer.getDescContainer(SUBSYSTEMS_DESC)));
                this.serviceGroups.put(serviceGroupName, serviceGroup);
                continue;
            }
            serviceGroup = this.serviceGroups.get(serviceGroupName);
            serviceGroup.getPluginSet().addAll(this.getAllPluginFromXml(descContainer));
            serviceGroup.getLinkSet().addAll(this.getPARANames(descContainer.getDescContainer(SUBSYSTEMS_DESC)));
        }
    }

    private Set<String> getAllPluginFromXml(DescContainer descContainer) {
        PARA[] paras;
        HashSet<String> set = new HashSet<String>();
        set.addAll(this.getPARANames(descContainer.getDescContainer(PLUGINS_DESC)));
        DescContainer features = descContainer.getDescContainer(FEATURES_DESC);
        if (features == null) {
            return set;
        }
        for (PARA para : paras = features.getPARAS().getPARA()) {
            set.addAll(SubsystemManager.getInstance().getSubsystemAllPluginList(para.getName()));
        }
        return set;
    }

    private Set<String> getPARANames(DescContainer descContainer) {
        PARA[] paras;
        HashSet<String> set = new HashSet<String>();
        if (descContainer == null) {
            return set;
        }
        for (PARA para : paras = descContainer.getPARAS().getPARA()) {
            set.add(para.getName());
        }
        return set;
    }

    private Set<String> getAllLink() {
        List list = StartupFactory.getAllStartupElements((int)3);
        HashSet<String> set = new HashSet<String>();
        for (IStartupElement iStartupElement : list) {
            set.add(iStartupElement.getName());
        }
        return set;
    }

    private Set<String> getAllPlugin() {
        List list = StartupFactory.getAllStartupElements((int)1);
        HashSet<String> set = new HashSet<String>();
        for (IStartupElement iStartupElement : list) {
            set.add(iStartupElement.getName());
        }
        return set;
    }

    private List<ServiceInfo> getServiceInfos() {
        ArrayList<ServiceInfo> elements = new ArrayList<ServiceInfo>();
        try {
            RpcRequest request = RpcNaming.createRequest((String)"sys.manage.systemmgr.ds.getServiceInfoArray");
            RpcResponse rsp = request.invoke();
            RpcMessage msg = rsp.getMessage();
            DataTable elementsTable = msg.getTable("serviceInfos");
            log.info((Object)("elementsTable:==\n" + elementsTable));
            for (int i = 0; i < elementsTable.size(); ++i) {
                DataRecord record = elementsTable.get(i);
                String serviceName = record.get("ServiceName").trim();
                String serviceType = record.get("ServiceType").trim();
                int startMode = Integer.parseInt(record.get("StartMode").trim());
                if (startMode == 2) continue;
                ServiceInfo serviceInfo = new ServiceInfo();
                serviceInfo.setServiceName(serviceName);
                serviceInfo.setServiceType(serviceType);
                serviceInfo.setStartMode(startMode);
                elements.add(serviceInfo);
            }
        }
        catch (Exception e) {
            log.error((Object)"getServiceInfos failed!", (Throwable)e);
        }
        return elements;
    }

    public static boolean isComponentEnable(String componentName, int componentType) {
        String lowName = componentName.toLowerCase();
        if (componentType == 0) {
            return displayPluginMenuSet.contains(lowName);
        }
        if (componentType == 1) {
            return displaySubsystemMenuSet.contains(lowName);
        }
        return false;
    }
}

