/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.broadcast;

import com.swimap.external.dsf.base.rpc.RpcErrorSecurity;
import com.swimap.iview.broadcast.BroadcastConstant;
import com.swimap.iview.broadcast.BroadcastMsgDlg;
import com.swimap.iview.broadcast.BroadcastParasSetToXml;
import com.swimap.iview.broadcast.BroadcastRpc;
import com.swimap.iview.clientutil.ClientUtilModule;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.templates.textfield.IntegerDocument;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.helpmanagement.HelpManager;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.text.Document;

public class BroadcastSettingDlg
extends JDialog {
    private boolean isInitialized = true;
    private static final Dimension BroadcastSettingDlgDimension = new Dimension(305, 165);
    private static final IviewLogger log = IviewLogger.getLogger(BroadcastSettingDlg.class, (String)"FRM");
    private final int MAX_SHOW = 1000;
    private final int MIN_SHOW = 1;
    private final int MAX_SAVED = 1000;
    private final int MIN_SAVED = 1;
    private String helpId = "help.2_Common_Service.broadcast_set";
    private JTextField latestTxt = new JTextField();
    private JTextField savedTxt = new JTextField();
    private BroadcastMsgDlg msgDlg = null;
    private BroadcastParasSetToXml xmlPara = BroadcastParasSetToXml.getInstance();

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public void setInitialized(boolean isInitialized) {
        this.isInitialized = isInitialized;
    }

    public BroadcastSettingDlg(BroadcastMsgDlg dlg) {
        super(dlg, "", true);
        this.setName("BroadCast_BroadcastSettingDlg");
        this.msgDlg = dlg;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            log.error((Object)e.toString(), (Throwable)e);
        }
    }

    private void jbInit() throws Exception {
        this.setTitle(ClientUtilModule.getString("dlgTitle"));
        this.setDefaultCloseOperation(2);
        Container contentPane = this.getContentPane();
        contentPane.add((Component)this.getInfoPanel(), "Center");
        contentPane.add((Component)this.getBtnPanel(), "South");
        this.initSetData();
        this.pack();
        this.setSize(BroadcastSettingDlgDimension);
        this.setResizable(false);
        HelpManager.getInstance().enableHelpKey((Component)this.getRootPane(), this.helpId);
    }

    private JPanel getBtnPanel() {
        JPanel btnPanel = new JPanel(new FlowLayout(2, 6, 12));
        btnPanel.setBounds(new Rectangle(13, 152, 330, 40));
        JButton saveBtn = new JButton(ClientUtilModule.getString("okBtnLabel"));
        saveBtn.setName("BroadCast_BroadcastSettingDlg_OkButton");
        saveBtn.setMnemonic('S');
        saveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BroadcastSettingDlg.this.okBtnActionPerformed();
            }
        });
        if (!ClientUtilModule.getInstance().checkRight("Set saved message count")) {
            saveBtn.setEnabled(false);
        }
        JButton cancelBtn = new JButton(ClientUtilModule.getString("cancelBtnLabel"));
        cancelBtn.setName("BroadCast_BroadcastSettingDlg_cancelButton");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BroadcastSettingDlg.this.dispose();
            }
        });
        btnPanel.add((Component)this.formatButton(saveBtn), null);
        btnPanel.add((Component)this.formatButton(cancelBtn), null);
        ScreenToolKit.setDefaultButtons((AbstractButton)saveBtn, (AbstractButton)cancelBtn);
        return btnPanel;
    }

    private JButton formatButton(JButton btn) {
        btn.setBounds(new Rectangle(242, 5, 85, 24));
        btn.setMinimumSize(BroadcastConstant.ButtonSize);
        btn.setPreferredSize(BroadcastConstant.ButtonSize);
        btn.setMaximumSize(BroadcastConstant.ButtonSize);
        return btn;
    }

    private JPanel getInfoPanel() {
        JLabel latestLabel = new JLabel();
        latestLabel.setText(ClientUtilModule.getString("latestMsgCount"));
        this.latestTxt.setName("BroadCast_BroadcastSettingDlg_updateCountTextField");
        JLabel savedLabel = new JLabel();
        savedLabel.setText(ClientUtilModule.getString("totalMsgCount"));
        savedLabel.setBounds(new Rectangle(24, 60, 150, 19));
        this.savedTxt.setName("BroadCast_BroadcastSettingDlg_saveCountTextField");
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)latestLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 16, 0, new Insets(12, 12, 0, 6), 0, 0));
        this.getClass();
        this.getClass();
        panel.add((Component)this.formatJTextField(this.latestTxt, 1, 1000), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(12, 0, 0, 12), 0, 0));
        panel.add((Component)savedLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 16, 0, new Insets(6, 12, 0, 6), 0, 0));
        this.getClass();
        this.getClass();
        panel.add((Component)this.formatJTextField(this.savedTxt, 1, 1000), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(6, 0, 0, 12), 0, 0));
        JPanel separate = new JPanel();
        separate.setBorder(new AdvancedEtchedBorder());
        panel.add((Component)separate, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 16, 2, new Insets(0, 12, 0, 12), 0, 0));
        return panel;
    }

    private JTextField formatJTextField(JTextField textField, int minValue, int maxValue) {
        textField.setBounds(new Rectangle(200, 25, 100, 21));
        textField.setDocument((Document)new IntegerDocument(minValue, maxValue));
        StringBuffer toolTip = new StringBuffer("[");
        toolTip.append(minValue).append(", ").append(maxValue).append("]");
        textField.setToolTipText(toolTip.toString());
        return textField;
    }

    private void initSetData() {
        int showMsgCount = this.xmlPara.getShowMsgCount();
        int savedCount = 0;
        try {
            savedCount = BroadcastRpc.getInstance().getSaveMsgCount();
        }
        catch (Exception e) {
            log.error((Object)e.toString(), (Throwable)e);
            String message = e instanceof RpcErrorSecurity ? ClientUtilModule.getString("authentication_failed") : ClientUtilModule.getString("Net_Noexsit");
            OptionPane.showMessageDialog((Component)FrameworkUtilities.getMainFrame(), (Object)message);
            this.setInitialized(false);
        }
        this.latestTxt.setText(String.valueOf(showMsgCount));
        this.savedTxt.setText(String.valueOf(savedCount));
        this.latestTxt.setCaretPosition(0);
        this.savedTxt.setCaretPosition(0);
    }

    private void okBtnActionPerformed() {
        if (!ClientUtilModule.getInstance().checkSevice()) {
            return;
        }
        if (!ClientUtilModule.getInstance().checkRight("Set saved message count")) {
            OptionPane.showMessageDialog((Component)this, (Object)ClientUtilModule.getString("AuthenticationFail"));
            return;
        }
        int showNumber = this.getTextFieldValue(this.latestTxt, ClientUtilModule.getString("nullShowNumber"), ClientUtilModule.getString("invalidShowNumber"));
        if (showNumber == -1) {
            return;
        }
        int savedNumber = this.getTextFieldValue(this.savedTxt, ClientUtilModule.getString("nullSavedNumber"), ClientUtilModule.getString("invalidSavedNumber"));
        if (savedNumber == -1) {
            return;
        }
        try {
            BroadcastRpc.getInstance().setSaveMsgCount(savedNumber);
            this.xmlPara.writeBack(String.valueOf(showNumber));
            FrameworkUtilities.getOutputManager().addMessage(ClientUtilModule.getString("broadcastSetSucceeded"));
            OptionPane.showMessageDialog((Component)this, (Object)ClientUtilModule.getString("broadcastSetSucceeded"));
            if (this.msgDlg != null) {
                this.msgDlg.frushBroadcastMsg(showNumber);
            }
            this.dispose();
        }
        catch (Exception ex) {
            log.error((Object)ex.toString(), (Throwable)ex);
            FrameworkUtilities.getOutputManager().addMessage(ClientUtilModule.getString("broadcastSetError"));
            OptionPane.showMessageDialog((Component)this, (Object)ClientUtilModule.getString("broadcastSetError"));
            return;
        }
    }

    private int getTextFieldValue(JTextField field, String nullValue, String invalidtablesize) {
        String rt = field.getText();
        if (rt == null || "".equals(rt)) {
            OptionPane.showMessageDialog((Component)this, (Object)nullValue);
            field.requestFocus();
            return -1;
        }
        if (!((IntegerDocument)field.getDocument()).isInRange(rt)) {
            OptionPane.showMessageDialog((Component)FrameworkUtilities.getMainFrame(), (Object)invalidtablesize);
            field.requestFocus();
            return -1;
        }
        return Integer.parseInt(rt);
    }

    static class AdvancedEtchedBorder
    extends EtchedBorder {
        private boolean isDrawUp = false;
        private boolean isDrawDown = false;

        public AdvancedEtchedBorder() {
            this(false, true);
        }

        public AdvancedEtchedBorder(boolean drawUp, boolean drawDown) {
            this.isDrawUp = drawUp;
            this.isDrawDown = drawDown;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            int w = width;
            int h = height;
            g.translate(x, y);
            g.setColor(this.etchType == 1 ? this.getShadowColor(c) : this.getHighlightColor(c));
            if (this.isDrawUp) {
                g.drawLine(0, 0, w - 1, 0);
            }
            if (this.isDrawDown) {
                g.drawLine(0, h - 2, w - 1, h - 2);
            }
            g.setColor(this.etchType == 1 ? this.getHighlightColor(c) : this.getShadowColor(c));
            if (this.isDrawUp) {
                g.drawLine(1, 1, w - 1, 1);
            }
            if (this.isDrawDown) {
                g.drawLine(0, h - 1, w - 1, h - 1);
            }
            g.translate(-x, -y);
        }
    }
}

