/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.broadcast;

import com.swimap.base.rpc.InternalErrorUtil;
import com.swimap.external.dsf.base.rpc.DataRecord;
import com.swimap.external.dsf.base.rpc.DataTable;
import com.swimap.external.dsf.base.rpc.RpcError;
import com.swimap.external.dsf.base.rpc.RpcMessage;
import com.swimap.external.dsf.base.rpc.RpcNaming;
import com.swimap.external.dsf.base.rpc.RpcRequest;
import com.swimap.external.dsf.base.rpc.RpcResponse;
import com.swimap.iview.broadcast.BroadcastInfo;
import com.swimap.iview.clientutil.ClientUtilModule;
import com.swimap.iview.util.log.IviewLogger;

public class BroadcastRpc {
    private static final IviewLogger log = IviewLogger.getLogger(BroadcastRpc.class, (String)"FRM");
    private static BroadcastRpc instance = null;

    public static BroadcastRpc getInstance() {
        if (instance == null) {
            instance = new BroadcastRpc();
        }
        return instance;
    }

    public String getOSInfo() {
        try {
            RpcRequest req = RpcNaming.createRequest((String)"sys.manage.broadcast.ds.getOSInfo");
            log.info((Object)"sys | getOSInfo | req.invoke() start.");
            RpcResponse rsp = ClientUtilModule.invoker(req);
            log.info((Object)"sys | getOSInfo | req.invoke() end.");
            RpcMessage msg = rsp.getMessage();
            return msg.getString("osInfo");
        }
        catch (RpcError e) {
            InternalErrorUtil.printInternalError((String)"DSF", (RpcError)e);
            return "";
        }
        catch (Exception e) {
            log.error((Object)e.toString(), (Throwable)e);
            return "";
        }
    }

    public void setSaveMsgCount(int count) throws Exception {
        RpcRequest req = RpcNaming.createRequest((String)"sys.manage.broadcast.ds.setMsgSaveCount");
        req.addArgument("msgSaveCount", (Object)count);
        log.info((Object)"sys | setSaveMsgCount | req.invoke() start.");
        ClientUtilModule.invoker(req);
        log.info((Object)"sys| setSaveMsgCount | req.invoke() end.");
    }

    public int getSaveMsgCount() throws Exception {
        RpcRequest req = RpcNaming.createRequest((String)"sys.manage.broadcast.ds.getSaveMsgCount");
        log.info((Object)"sys | getSaveMsgCount | req.invoke() start.");
        RpcResponse rsp = ClientUtilModule.invoker(req);
        log.info((Object)"sys | getSaveMsgCount | req.invoke() end.");
        RpcMessage msg = rsp.getMessage();
        return msg.getInt("saveMsgCount");
    }

    public int sendBroadcastMsg(String message) throws Exception {
        RpcRequest req = RpcNaming.createRequest((String)"sys.manage.broadcast.ds.sendBroadcastMsg");
        req.addArgument("message", (Object)message);
        log.info((Object)"sys | sendBroadcastMsg | req.invoke() start.");
        RpcResponse rsp = ClientUtilModule.invoker(req);
        log.info((Object)"sys | sendBroadcastMsg | req.invoke() end.");
        RpcMessage msg = rsp.getMessage();
        return msg.getInt("sendResult");
    }

    public BroadcastInfo[] getBroadcastMsgList(int msgCount) throws Exception {
        RpcRequest req = RpcNaming.createRequest((String)"sys.manage.broadcast.ds.getBroadcastMsgs");
        req.addArgument("count", (Object)msgCount);
        log.info((Object)"sys | getBroadcastMsgList | req.invoke() start.");
        RpcResponse rsp = ClientUtilModule.invoker(req);
        log.info((Object)"sys | getBroadcastMsgList | req.invoke() end.");
        RpcMessage msg = rsp.getMessage();
        DataTable broadcastInfoTable = msg.getTable("BroadcastInfo");
        if (null == broadcastInfoTable) {
            return null;
        }
        BroadcastInfo[] broadcastInfoArray = new BroadcastInfo[broadcastInfoTable.size()];
        for (int i = 0; i < broadcastInfoTable.size(); ++i) {
            DataRecord record = broadcastInfoTable.get(i);
            if (null == record) continue;
            broadcastInfoArray[i] = new BroadcastInfo(record.get("userName"), record.get("hostIp"), record.get("sessionId"), record.get("message"), record.get("sendTime"), record.get("msgNo"));
        }
        return broadcastInfoArray;
    }

    public int getBroadcastStatus(int msgCount) throws Exception {
        RpcRequest req = RpcNaming.createRequest((String)"sys.manage.broadcast.ds.getBroadcastMsgs");
        req.addArgument("count", (Object)msgCount);
        log.info((Object)"sys | getBroadcastStatus | req.invoke() start.");
        RpcResponse rsp = ClientUtilModule.invoker(req);
        log.info((Object)"sys | getBroadcastStatus | req.invoke() end.");
        RpcMessage msg = rsp.getMessage();
        return msg.getInt("countNumb");
    }
}

