/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.broadcast;

import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.xmlbind.PARA;
import com.swimap.iview.commstyle.commini.xmlbind.PARAS;
import com.swimap.iview.framework.pluginmanagement.PluginManager;
import com.swimap.iview.util.log.IviewLogger;

public class BroadcastParasSetToXml {
    private static final IviewLogger log = IviewLogger.getLogger(BroadcastParasSetToXml.class, (String)"FRM");
    private CommStyleInfo info;
    private AreaDescContainer[] areas = new AreaDescContainer[1];
    private final String SETINFO = "BroadcastInfo";
    private final String SETINFONAME = "Broadcast Setting Information";
    private final String SHOWMSGCOUNT = "showMsgCount";
    private String filePath = "BroadcastSetting";
    private static BroadcastParasSetToXml instance = new BroadcastParasSetToXml();

    public static BroadcastParasSetToXml getInstance() {
        if (instance == null) {
            instance = new BroadcastParasSetToXml();
        }
        return instance;
    }

    private BroadcastParasSetToXml() {
        try {
            this.info = PluginManager.getInstance().getPlugin("ClientUtilModule").getCommStyleParser().getCommStyleInfo(this.filePath);
        }
        catch (Exception e) {
            log.error((Object)e.toString(), (Throwable)e);
        }
        if (this.info == null) {
            this.info = new CommStyleInfo();
            this.info.setFileName(this.filePath);
        }
        this.areas[0] = new AreaDescContainer();
        this.areas[0].setAreaName("BroadcastInfo");
    }

    protected int getShowMsgCount() {
        int count = 100;
        try {
            AreaDescContainer areaDescContainer = this.info.getAreaDescContainer("BroadcastInfo");
            String descName = areaDescContainer.getDescContainer(0).getDescName();
            count = Integer.parseInt(this.info.getParasItemValue(descName, "showMsgCount"));
        }
        catch (Exception e) {
            log.error((Object)e.toString(), (Throwable)e);
        }
        return count;
    }

    protected void writeBack(String showMsgCount) {
        PARA name = new PARA();
        name.setName("showMsgCount");
        name.setValue(showMsgCount);
        PARAS paras = new PARAS();
        paras.addPARA(name);
        DescContainer[] userDc = new DescContainer[]{new DescContainer()};
        userDc[0].setDescName("Broadcast Setting Information");
        userDc[0].setPARAS(paras);
        this.areas[0].setDescContainer(userDc);
        this.info.setAreaDescContainer(this.areas);
        this.info.writeBack();
    }
}

