/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.broadcast;

import com.swimap.iview.broadcast.BroadcastInfo;
import com.swimap.iview.broadcast.BroadcastParasSetToXml;
import com.swimap.iview.broadcast.BroadcastRpc;
import com.swimap.iview.broadcast.MisTool;
import com.swimap.iview.clientutil.ClientUtilModule;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;

public class BroadcastMsgDlgHelper {
    private static final IviewLogger log = IviewLogger.getLogger(BroadcastMsgDlgHelper.class, (String)"FRM");
    private BroadcastRpc broadcastRpc = BroadcastRpc.getInstance();

    public boolean sendBroadcastMsg(String message, StringBuffer msgBuffer) {
        if (!ClientUtilModule.getInstance().checkSevice()) {
            return false;
        }
        if (!ClientUtilModule.getInstance().checkRight("Broadcast message")) {
            msgBuffer.append(ClientUtilModule.getString("AuthenticationFail"));
            return false;
        }
        if ("".equals(message)) {
            msgBuffer.append(ClientUtilModule.getString("Message_should_not_null"));
            return false;
        }
        try {
            log.debug((Object)("Broadcast message info sent to server: " + message));
            int s = this.broadcastRpc.sendBroadcastMsg(message);
            if (s == 0) {
                return true;
            }
        }
        catch (Exception e) {
            log.error((Object)e.toString(), (Throwable)e);
        }
        msgBuffer.append(ClientUtilModule.getString("Send_message_Error"));
        return false;
    }

    public int getShowNumber() {
        return BroadcastParasSetToXml.getInstance().getShowMsgCount();
    }

    public String getBroadcastMsg(int count) {
        try {
            BroadcastInfo[] msg = this.broadcastRpc.getBroadcastMsgList(count);
            if (msg != null) {
                StringBuffer s = new StringBuffer("");
                for (int i = 0; i < msg.length; ++i) {
                    s.append(this.getFormatMsg(msg[i]));
                    if (this.getFormatMsg(msg[i]).equals("")) continue;
                    s.append(System.getProperty("line.separator"));
                }
                return s.toString();
            }
        }
        catch (Exception e) {
            log.error((Object)e.toString(), (Throwable)e);
            FrameworkUtilities.getOutputManager().addMessage(ClientUtilModule.getString("refreshMessageError"));
            OptionPane.showMessageDialog((Component)FrameworkUtilities.getMainFrame(), (Object)ClientUtilModule.getString("refreshMessageError"));
        }
        return "";
    }

    private String getFormatMsg(BroadcastInfo tempMsg) {
        StringBuffer s = new StringBuffer("");
        if (tempMsg != null && !tempMsg.sendTime.isEmpty()) {
            s.append("From:  ").append(tempMsg.hostIp).append("  ").append(tempMsg.userName).append("  ").append(MisTool.timeFormat(tempMsg.sendTime)).append("  ").append(System.getProperty("line.separator")).append(tempMsg.message).append(System.getProperty("line.separator"));
        }
        return s.toString();
    }
}

