/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.broadcast;

import com.swimap.iview.broadcast.BroadcastConstant;
import com.swimap.iview.broadcast.BroadcastMsgDlgHelper;
import com.swimap.iview.broadcast.BroadcastSettingDlg;
import com.swimap.iview.clientutil.ClientUtilModule;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.DialogCommStyleInfo;
import com.swimap.iview.commstyle.commini.GUICompCommStyleInfo;
import com.swimap.iview.templates.textfield.ValidCharDocument;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.PaneConstraints;
import com.swimap.iview.util.PaneLayout;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.helpmanagement.HelpManager;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;

public class BroadcastMsgDlg
extends JDialog {
    private static final IviewLogger log = IviewLogger.getLogger(BroadcastMsgDlg.class, (String)"FRM");
    private final String helpId = "help.2_Common_Service.broadcast_message";
    private JPopupMenu popupMenu = null;
    private JTextArea msgArea = new JTextArea();
    private JTextArea msgTxt = new JTextArea();
    private final String DIALOG_STYLENAME = "frm/clientutil/broadcastDialogStyle";
    private int width;
    private int height;
    private BroadcastMsgDlgHelper helper = new BroadcastMsgDlgHelper();
    private KeyAdapter adpter = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 27) {
                BroadcastMsgDlg.this.dispose();
            }
        }
    };

    public BroadcastMsgDlg(Frame frame) {
        super(frame, ClientUtilModule.getString("title"), true);
        this.setName("BroadCast_BroadcastMsgDlg");
        try {
            this.jbInit();
        }
        catch (Exception e) {
            log.error((Object)e.toString(), (Throwable)e);
        }
        this.setSize(512, 400);
        this.setUserDlgSize();
    }

    private void jbInit() throws Exception {
        this.setTitle(ClientUtilModule.getString("mainDlgTitle"));
        this.setResizable(true);
        this.setDefaultCloseOperation(2);
        this.setFocusable(true);
        this.requestFocusInWindow();
        this.requestFocus(true);
        this.addKeyListener(this.adpter);
        Dimension dimension = new Dimension();
        dimension.setSize(500, 400);
        this.setMinimumSize(dimension);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout((LayoutManager)new PaneLayout());
        contentPane.add((Component)this.getMsgAreaPanel(), new PaneConstraints("jScrollPane1", "jScrollPane1", "Root", 0.5f));
        contentPane.add((Component)this.getMsgPanel(), new PaneConstraints("jPanel1", "jScrollPane1", "Bottom", 0.2935065f));
        this.frushBroadcastMsg(this.helper.getShowNumber());
        HelpManager.getInstance().enableHelpKey((Component)this.getRootPane(), "help.2_Common_Service.broadcast_message");
        this.msgTxt.requestFocus(true);
    }

    private void setUserDlgSize() {
        GUICompCommStyleInfo dialogInfo = CommStyleManager.getInstance().readGUIInfoFromUser("frm/clientutil/broadcastDialogStyle", "Dialog");
        if (dialogInfo != null) {
            DescContainer desc = dialogInfo.getAreaDescContainer("DialogCommStyleInfo").getDescContainer("DialogInfo");
            String strWidth = desc.getParasItemValue("width");
            String strHeight = desc.getParasItemValue("height");
            this.width = Integer.valueOf(strWidth);
            this.height = Integer.valueOf(strHeight);
            this.setSize(this.width, this.height);
        }
    }

    public void saveUserDlgSize() {
        this.width = this.getSize().width;
        this.height = this.getSize().height;
        DialogCommStyleInfo dialogInfo = new DialogCommStyleInfo(this.width, this.height);
        CommStyleManager.getInstance().writeGUIInfoToUser("frm/clientutil/broadcastDialogStyle", (GUICompCommStyleInfo)dialogInfo);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.saveUserDlgSize();
    }

    private JPanel getMsgAreaPanel() {
        JPanel labelPanel = new JPanel(new FlowLayout(0));
        JLabel msgLabel = new JLabel(ClientUtilModule.getString("historyMsgLabel"));
        labelPanel.add((Component)msgLabel, null);
        this.msgArea.addKeyListener(this.adpter);
        this.msgArea.setName("BroadCast_BroadcastMsgDlg_historyMsgTextArea");
        this.msgArea.setLineWrap(true);
        this.msgArea.setWrapStyleWord(true);
        this.msgArea.setMargin(new Insets(4, 4, 4, 4));
        this.msgArea.setText("");
        this.msgArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                BroadcastMsgDlg.this.mouseRightPressed(e);
            }
        });
        this.msgArea.setEnabled(false);
        this.msgArea.setRequestFocusEnabled(false);
        JScrollPane pane2 = new JScrollPane();
        pane2.setHorizontalScrollBarPolicy(31);
        pane2.getViewport().add((Component)this.msgArea, null);
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.add((Component)labelPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 6, 0, 12), 0, 0));
        panel.add((Component)pane2, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 12, 0, 12), 0, 0));
        return panel;
    }

    private JPanel getMsgPanel() {
        JLabel l = new JLabel("TEST");
        JTextArea msgLabel = new JTextArea(ClientUtilModule.getString("sendMsgLabel"));
        msgLabel.setEditable(false);
        msgLabel.setEnabled(false);
        msgLabel.setLineWrap(true);
        msgLabel.setWrapStyleWord(true);
        msgLabel.setFont(l.getFont());
        msgLabel.setDisabledTextColor(Color.BLACK);
        boolean hasRightFlag = ClientUtilModule.getInstance().checkRight("Broadcast message");
        this.msgTxt.setName("BroadCast_BroadcastMsgDlg_newMsgTextField");
        this.msgTxt.setMargin(new Insets(2, 2, 2, 2));
        this.msgTxt.setEnabled(hasRightFlag);
        this.msgTxt.addKeyListener(this.adpter);
        this.msgTxt.setLineWrap(true);
        this.msgTxt.setWrapStyleWord(true);
        this.msgTxt.setDocument((Document)new ValidCharDocument(128, null));
        JScrollPane msgScroll = new JScrollPane();
        msgScroll.setMinimumSize(new Dimension(15, 21));
        msgScroll.setPreferredSize(new Dimension(15, 21));
        msgScroll.getViewport().add(this.msgTxt);
        JButton sendBtn = new JButton();
        sendBtn.setName("BroadCast_BroadcastMsgDlg_sendButton");
        sendBtn.setEnabled(hasRightFlag);
        sendBtn.addKeyListener(this.adpter);
        sendBtn.setText(ClientUtilModule.getString("sendBtnLabel"));
        sendBtn.setMnemonic('S');
        sendBtn.setMinimumSize(BroadcastConstant.ButtonSize);
        sendBtn.setPreferredSize(BroadcastConstant.ButtonSize);
        sendBtn.setMaximumSize(BroadcastConstant.ButtonSize);
        sendBtn.setMargin(new Insets(12, 12, 12, 12));
        sendBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BroadcastMsgDlg.this.sendBtnActionPerformed();
            }
        });
        JButton setBtn = new JButton();
        setBtn.setName("BroadCast_BroadcastMsgDlg_setButton");
        setBtn.setEnabled(hasRightFlag);
        setBtn.addKeyListener(this.adpter);
        setBtn.setText(ClientUtilModule.getString("setBtnLabel"));
        setBtn.setMnemonic('O');
        setBtn.setMinimumSize(BroadcastConstant.ButtonSize);
        setBtn.setPreferredSize(BroadcastConstant.ButtonSize);
        setBtn.setMaximumSize(BroadcastConstant.ButtonSize);
        setBtn.setMargin(new Insets(12, 12, 12, 12));
        setBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BroadcastMsgDlg.this.showSetDlg();
            }
        });
        JPanel btnPanel = new JPanel(new GridBagLayout());
        btnPanel.add((Component)sendBtn, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 2, 12, 2), 0, 0));
        btnPanel.add((Component)setBtn, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 2, 0, 2), 0, 0));
        JPanel msgPanel = new JPanel();
        msgPanel.setLayout(new GridBagLayout());
        msgPanel.add((Component)msgScroll, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 365, 30));
        msgPanel.add((Component)btnPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 3, 30));
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.add((Component)msgLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 12, 0, 12), 0, 0));
        panel.add((Component)msgPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 12, 12, 12), 0, 0));
        return panel;
    }

    private void sendBtnActionPerformed() {
        StringBuffer message = new StringBuffer("");
        boolean result = this.helper.sendBroadcastMsg(this.msgTxt.getText().trim(), message);
        if (result) {
            this.frushBroadcastMsg(this.helper.getShowNumber());
            this.msgTxt.setText("");
            OptionPane.showMessageDialog((Component)this, (Object)ClientUtilModule.getString("Send_message_success"));
        } else if (message != null && !"".equals(message.toString())) {
            OptionPane.showMessageDialog((Component)this, (Object)message.toString());
        }
        this.msgTxt.requestFocus();
    }

    private void showSetDlg() {
        BroadcastSettingDlg dlg = new BroadcastSettingDlg(this);
        if (dlg.isInitialized()) {
            ScreenToolKit.centerLocateToScreen((Component)dlg);
            dlg.setVisible(true);
        } else {
            dlg.setInitialized(true);
        }
    }

    private void mouseRightPressed(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e)) {
            if (this.popupMenu == null) {
                JMenuItem popFrushItem = new JMenuItem();
                popFrushItem.setText(ClientUtilModule.getString("refreshItem"));
                popFrushItem.setMnemonic('R');
                popFrushItem.setName("BroadCast_BroadcastMsgDlg_refreshItem");
                popFrushItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        BroadcastMsgDlg.this.frushBroadcastMsg(BroadcastMsgDlg.this.helper.getShowNumber());
                    }
                });
                this.popupMenu = new JPopupMenu();
                this.popupMenu.add(popFrushItem);
            }
            this.popupMenu.show(this.msgArea, e.getPoint().x, e.getPoint().y);
        }
    }

    public void frushBroadcastMsg(int count) {
        this.msgArea.setText(this.helper.getBroadcastMsg(count));
    }

    public void freshMessageArea() {
        this.frushBroadcastMsg(this.helper.getShowNumber());
        this.msgArea.select(this.msgArea.getText().length(), this.msgArea.getText().length());
    }
}

