/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.broadcast;

import com.swimap.external.dsf.base.rpc.RpcEvent;
import com.swimap.external.dsf.base.rpc.RpcServerPush;
import com.swimap.external.dsf.base.rpc.RpcServerPushHandler;
import com.swimap.iview.broadcast.MisTool;
import com.swimap.iview.clientutil.ClientUtilModule;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.templates.dialog.DetailMessageDlg;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Frame;
import java.text.MessageFormat;
import javax.swing.SwingUtilities;

public class BroadCastServerPushClient
implements RpcServerPushHandler {
    private static final IviewLogger log = IviewLogger.getLogger(BroadCastServerPushClient.class, (String)"FRM");
    public static final String BROADCASTMSG_EVENT_TYPE_VALUE = "BroadcastMsg";
    public static final String BROADCASTMSG_EVENT = "SystemManager.BroadcastMsg";
    public final String TYPENAME = "TypeName";
    public final String BROADCASTMSGHOSTIP = "BroadCastMsgHostIP";
    public final String BROADCASTMMESSAGE = "BroadCastMmessage";
    public final String BROADCASTMMSGNO = "BroadCastMmsgno";
    public final String BROADCASTMSENDTIME = "BroadCastMsendTime";
    public final String BROADCASTMSESSIONID = "BroadCastMsessionID";
    public final String BROADCASTMUSERNAME = "BroadCastMuserName";
    public DetailMessageDlg messageDlg = null;

    public void open() {
        log.info((Object)"sys | open | before RpcServerPush.addHandler(emEventType, this).");
        RpcServerPush.addHandler((String)BROADCASTMSG_EVENT, (RpcServerPushHandler)this);
        log.info((Object)"sys | open | after RpcServerPush.addHandler(emEventType, this).");
    }

    public void close() {
        log.info((Object)"sys | close | before RpcServerPush.removeHandler(this).");
        RpcServerPush.removeHandler((RpcServerPushHandler)this);
        log.info((Object)"sys | close | after RpcServerPush.removeHandler(this).");
    }

    public void handleServerPush(RpcEvent event) {
        if (null == event) {
            log.info((Object)"sys | handleServerPush | event is null.");
            return;
        }
        String eventType = event.getMessage().getString("TypeName");
        log.info((Object)("sys | handleServerPush | Receive EM Event: " + eventType));
        if (BROADCASTMSG_EVENT_TYPE_VALUE.equals(eventType)) {
            this.process(event);
        }
    }

    private void process(RpcEvent event) {
        String message = event.getMessage().getString("BroadCastMmessage");
        String currentSessionID = String.valueOf(ClientUtilModule.getInstance().getClientUtilProxy().getCurSessionID());
        String sessionId = event.getMessage().getString("BroadCastMsessionID");
        String userName = event.getMessage().getString("BroadCastMuserName");
        String hostIp = event.getMessage().getString("BroadCastMsgHostIP");
        log.info((Object)("sys | process | currentSessionID: " + currentSessionID + ". sessionId: " + sessionId));
        log.debug((Object)"Broadcast message received from the server: ");
        log.debug((Object)("User name: " + userName));
        log.debug((Object)("host IP: " + hostIp));
        log.debug((Object)("session Id: " + sessionId));
        log.debug((Object)("message: " + message));
        if (currentSessionID.equals(sessionId)) {
            Object[] string_format = new String[]{userName, hostIp, message};
            String send_message = MessageFormat.format(ClientUtilModule.getString("sendMsg"), string_format);
            FrameworkUtilities.getOutputManager().addMessage(send_message);
        } else {
            ClientUtilModule.getInstance().freshMsgArea();
            String sendTime = event.getMessage().getString("BroadCastMsendTime");
            Object[] string_format = new String[]{MisTool.timeFormat(sendTime), userName, hostIp, System.getProperty("line.separator")};
            final StringBuffer messageBuffer1 = new StringBuffer(MessageFormat.format(ClientUtilModule.getString("receiveMsg"), string_format));
            messageBuffer1.append(message);
            messageBuffer1.append(System.getProperty("line.separator")).append(System.getProperty("line.separator"));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (BroadCastServerPushClient.this.messageDlg != null && BroadCastServerPushClient.this.messageDlg.isShowing()) {
                        BroadCastServerPushClient.this.messageDlg.addDetailMessage((Object)messageBuffer1.toString());
                    } else {
                        BroadCastServerPushClient.this.messageDlg = new DetailMessageDlg((Frame)FrameworkUtilities.getMainFrame(), ClientUtilModule.getString("Information"), (Object)ClientUtilModule.getString("ReceiveNewMessage"), 1, 0, (Object)messageBuffer1.toString(), false);
                        BroadCastServerPushClient.this.messageDlg.setSize(461, 380);
                        BroadCastServerPushClient.this.messageDlg.show();
                    }
                }
            });
        }
    }
}

