/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.external.sf.sys.viewframework.tzdstregister;

import com.swimap.external.sf.sys.viewframework.tzdstregister.TZDataRPC;
import com.swimap.iview.clientutil.ClientUtilModule;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.framework.IViewTimeZone;
import com.swimap.iview.framework.pluginmanagement.CommStyleParser;
import com.swimap.iview.framework.pluginmanagement.PluginManager;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.DebugTracer;
import com.swimap.iview.util.format.TimeDateFormatUtil;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.iview.viewframework.systemsettings.datasource.XMLConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;
import java.util.TimeZone;

public final class TZDSTRegistry {
    private static final String TYPE_WEEK = "WEEK";
    private static final String TYPE_DATE = "DATE";
    private static final String TYPE_MONTH_WEEK = "MONTH_WEEK";
    private static final IviewLogger log = IviewLogger.getLogger(TZDSTRegistry.class, (String)"FRM");
    private TZDataRPC tzDataRPC = new TZDataRPC();
    public static final String TZ_NAME = "TimeZoneName";
    public static final String TIME_ZONE = "TimeZone";
    public static final String DST_SAVINGS = "dstSavings";
    public static final String START_TYPE = "StartType";
    public static final String END_TYPE = "EndType";
    public static final String START_DATE = "StartDate";
    public static final String END_DATE = "EndDate";
    public static final String START_TIME = "StartTime";
    public static final String END_TIME = "EndTime";
    private String value_TZ;
    private String value_DSTOffset;
    private String value_StartType;
    private String value_EndType;
    private String value_StartWeek;
    private String value_EndWeek;
    private String value_StartDate;
    private String value_EndDate;
    private String value_StartTime;
    private String value_EndTime;
    private int rawOffset;
    final String ID = "iMAP";
    private int startMonth;
    private int startDay;
    private int startDayOfWeek;
    private int startTime;
    private int endMonth;
    private int endDay;
    private int endDayOfWeek;
    private int endTime;
    private int dstSavings;
    private static final int WEEK_DAYS = 7;
    private static final String DST_TYPE_DATE = "0";
    private static final String DST_TYPE_DATE_WEEK = "1";
    private static final String DST_TYPE_MONTH_WEEK = "2";
    private static TZDSTRegistry instance = null;
    public static final String SUPPORTXMLFILENAME = "regionconfig/support";
    private Map<String, String> serverRuleTZMap = new HashMap<String, String>();
    private TimeZone serviceTimezone = null;
    private static final int HOUR_SEC = 3600;
    private static final int MIN_SEC = 60;
    private static final int SEC_MILLIS = 1000;

    private TZDSTRegistry() {
    }

    public static TZDSTRegistry getInstance() {
        if (instance == null) {
            instance = new TZDSTRegistry();
        }
        return instance;
    }

    public void registerTimeZoneDST() {
        try {
            XMLConfig curXMLConfig = new XMLConfig("regionconfig/locregcfg", false);
            boolean usServiceTimezone = false;
            if (curXMLConfig != null && XMLConfig.isValid(curXMLConfig.getCurTimeMode())) {
                usServiceTimezone = 0 == curXMLConfig.getCurTimeMode().getValue();
            }
            this.getServiceTimeZone();
            if (usServiceTimezone && null == this.serviceTimezone) {
                String msg = ClientUtilModule.getString("get.timezone.info.faild.msg");
                FrameworkUtilities.getOutputManager().addMessage(msg);
                log.debug((Object)("get timezone from server faild\uff0cset serviceTimezone as client timezone:" + TimeZone.getDefault()));
            }
            if (usServiceTimezone && this.needModifyTimezone() && null != this.serviceTimezone) {
                TimeZone.setDefault(this.serviceTimezone);
                TimeDateFormatUtil.setTimeZone((TimeZone)this.serviceTimezone);
                DebugTracer.resetCalendar();
            } else {
                IViewTimeZone iViewTimeZone = new IViewTimeZone();
                TimeDateFormatUtil.setTimeZone((TimeZone)iViewTimeZone.getTimeZone());
            }
        }
        catch (Exception e) {
            log.error((Object)e.toString(), (Throwable)e);
        }
    }

    public void unregisterTimeZoneDST() {
        this.serviceTimezone = null;
    }

    public void setDefaultTimeZone() {
        IViewTimeZone iveiwTimeZone = new IViewTimeZone();
        iveiwTimeZone.setTimeZone();
        TimeDateFormatUtil.setTimeZone((TimeZone)iveiwTimeZone.getTimeZone());
    }

    private boolean needModifyTimezone() {
        CommStyleParser parser = PluginManager.getInstance().getPlugin("ClientUtilModule").getCommStyleParser();
        CommStyleInfo info = parser.getCommStyleInfo(SUPPORTXMLFILENAME);
        if (info == null || !info.isValid()) {
            return false;
        }
        String paramValue = info.getParasItemValue("ModifyTimezone", "ModifyTimezone");
        return "true".equalsIgnoreCase(paramValue);
    }

    public TimeZone getServiceTimeZone() {
        if (this.serviceTimezone == null) {
            try {
                this.serviceTimezone = this.getTimeZone();
            }
            catch (Exception e) {
                log.error((Object)e.toString(), (Throwable)e);
            }
        }
        return this.serviceTimezone;
    }

    public TimeZone getTimeZone(String tzInfo) {
        this.parserTZString(tzInfo);
        this.parserTZMap(this.serverRuleTZMap);
        this.initTZDaylightInfo();
        this.initDSTInfo();
        StringBuffer info = new StringBuffer();
        info.append("getTimeZone").append("timezone param:rawOffset=").append(this.rawOffset).append(",ID=").append("iMAP").append(",startMonth=").append(this.startMonth).append(",startDay=").append(this.startDay).append(",startDayOfWeek=").append(this.startDayOfWeek).append(",startTime=").append(this.startTime).append(",endMonth=").append(this.endMonth).append(",endDay=").append(this.endDay).append(",endDayOfWeek=").append(this.endDayOfWeek).append(",endTime=").append(this.endTime).append(",dstSavings=").append(this.dstSavings);
        log.info((Object)("sys | getTimeZone(String tzInfo) | original string is: " + tzInfo + "convert to TZ string is:" + info.toString()));
        SimpleTimeZone timeZone = new SimpleTimeZone(this.rawOffset, "iMAP");
        if (this.dstSavings != 0) {
            if (TYPE_MONTH_WEEK.equalsIgnoreCase(this.value_StartType)) {
                timeZone.setStartRule(this.startMonth, this.startDay, this.startDayOfWeek, this.startTime);
                timeZone.setEndRule(this.endMonth, this.endDay, this.endDayOfWeek, this.endTime);
                timeZone.setDSTSavings(this.dstSavings);
            } else {
                timeZone = new SimpleTimeZone(this.rawOffset, "iMAP", this.startMonth, this.startDay, this.startDayOfWeek, this.startTime, this.endMonth, this.endDay, this.endDayOfWeek, this.endTime, this.dstSavings);
            }
        }
        return timeZone;
    }

    public Map<String, String> parserTZString(String tzInfo) {
        HashMap<String, String> tzInfoMap = new HashMap<String, String>();
        String[] temp = tzInfo.split(";");
        tzInfoMap.put(TZ_NAME, temp[0].trim());
        this.serverRuleTZMap.put("TZ", temp[1].trim());
        tzInfoMap.put(TIME_ZONE, temp[1].trim());
        if (DST_TYPE_DATE.equalsIgnoreCase(temp[2].trim())) {
            this.serverRuleTZMap.put(START_TYPE, TYPE_DATE);
            this.serverRuleTZMap.put(START_DATE, temp[3].trim());
            this.serverRuleTZMap.put("StartWeek", "");
            tzInfoMap.put(START_TYPE, TYPE_DATE);
        } else if (DST_TYPE_DATE_WEEK.equalsIgnoreCase(temp[2].trim())) {
            this.serverRuleTZMap.put(START_TYPE, TYPE_WEEK);
            this.serverRuleTZMap.put("StartWeek", temp[3].trim());
            this.serverRuleTZMap.put(START_DATE, "");
            tzInfoMap.put(START_TYPE, TYPE_WEEK);
        } else if (DST_TYPE_MONTH_WEEK.equalsIgnoreCase(temp[2].trim())) {
            this.serverRuleTZMap.put(START_TYPE, TYPE_MONTH_WEEK);
            this.serverRuleTZMap.put(START_DATE, "");
            this.serverRuleTZMap.put("StartWeek", temp[3].trim());
            tzInfoMap.put(START_TYPE, TYPE_MONTH_WEEK);
        } else {
            log.debug((Object)("dst format wrong :" + tzInfo));
            this.serverRuleTZMap.put(START_TYPE, TYPE_DATE);
            this.serverRuleTZMap.put(START_DATE, temp[3].trim());
            this.serverRuleTZMap.put("StartWeek", "");
            tzInfoMap.put(START_TYPE, TYPE_DATE);
        }
        tzInfoMap.put(START_DATE, temp[3].trim());
        this.serverRuleTZMap.put(START_TIME, temp[4].trim());
        tzInfoMap.put(START_TIME, temp[4].trim());
        if (DST_TYPE_DATE.equalsIgnoreCase(temp[5].trim())) {
            this.serverRuleTZMap.put(END_TYPE, TYPE_DATE);
            this.serverRuleTZMap.put(END_DATE, temp[6].trim());
            this.serverRuleTZMap.put("EndWeek", "");
            tzInfoMap.put(END_TYPE, TYPE_DATE);
        } else if (DST_TYPE_DATE_WEEK.equalsIgnoreCase(temp[5].trim())) {
            this.serverRuleTZMap.put(END_TYPE, TYPE_WEEK);
            this.serverRuleTZMap.put("EndWeek", temp[6].trim());
            this.serverRuleTZMap.put(END_DATE, "");
            tzInfoMap.put(END_TYPE, TYPE_WEEK);
        } else if (DST_TYPE_MONTH_WEEK.equalsIgnoreCase(temp[5].trim())) {
            this.serverRuleTZMap.put(END_TYPE, TYPE_MONTH_WEEK);
            this.serverRuleTZMap.put(END_DATE, "");
            this.serverRuleTZMap.put("EndWeek", temp[6].trim());
            tzInfoMap.put(END_TYPE, TYPE_MONTH_WEEK);
        } else {
            log.debug((Object)("dst format wrong :" + tzInfo));
            this.serverRuleTZMap.put(END_TYPE, TYPE_DATE);
            this.serverRuleTZMap.put(END_DATE, temp[6].trim());
            this.serverRuleTZMap.put("EndWeek", "");
            tzInfoMap.put(END_TYPE, TYPE_DATE);
        }
        this.serverRuleTZMap.put(END_TIME, temp[7].trim());
        this.serverRuleTZMap.put("DSTOffset", temp[8].trim());
        tzInfoMap.put(END_DATE, temp[6].trim());
        tzInfoMap.put(END_TIME, temp[7].trim());
        tzInfoMap.put(DST_SAVINGS, temp[8].trim());
        return tzInfoMap;
    }

    private TimeZone getTimeZone() {
        this.init();
        this.initTZDaylightInfo();
        this.initDSTInfo();
        StringBuffer info = new StringBuffer();
        info.append("getTimeZone").append("timezone param: value_StartType=").append(this.value_StartType).append("rawOffset=").append(this.rawOffset).append(",ID=").append("iMAP").append(",startMonth=").append(this.startMonth).append(",startDay=").append(this.startDay).append(",startDayOfWeek=").append(this.startDayOfWeek).append(",startTime=").append(this.startTime).append(",endMonth=").append(this.endMonth).append(",endDay=").append(this.endDay).append(",endDayOfWeek=").append(this.endDayOfWeek).append(",endTime=").append(this.endTime).append(",dstSavings=").append(this.dstSavings);
        log.info((Object)("sys | getTimeZone | " + info.toString()));
        SimpleTimeZone timeZone = new SimpleTimeZone(this.rawOffset, "iMAP");
        if (this.dstSavings != 0) {
            if (TYPE_MONTH_WEEK.equals(this.value_StartType)) {
                timeZone.setStartRule(this.startMonth, this.startDay, this.startDayOfWeek, this.startTime);
                timeZone.setEndRule(this.endMonth, this.endDay, this.endDayOfWeek, this.endTime);
                timeZone.setDSTSavings(this.dstSavings);
            } else {
                timeZone = new SimpleTimeZone(this.rawOffset, "iMAP", this.startMonth, this.startDay, this.startDayOfWeek, this.startTime, this.endMonth, this.endDay, this.endDayOfWeek, this.endTime, this.dstSavings);
            }
        }
        return timeZone;
    }

    private void init() {
        Map<String, String> data = this.tzDataRPC.getTimeZoneDSTInfo();
        log.info((Object)("get from dst server:" + data));
        this.parserTZMap(data);
    }

    private void parserTZMap(Map<String, String> data) {
        this.value_TZ = data.get("TZ");
        this.value_DSTOffset = data.get("DSTOffset");
        this.value_StartType = data.get(START_TYPE);
        this.value_EndType = data.get(END_TYPE);
        this.value_StartWeek = data.get("StartWeek");
        this.value_EndWeek = data.get("EndWeek");
        this.value_StartDate = data.get(START_DATE);
        this.value_EndDate = data.get(END_DATE);
        this.value_StartTime = data.get(START_TIME);
        this.value_EndTime = data.get(END_TIME);
    }

    /*
     * Enabled aggressive block sorting
     */
    private int[] initDSTInfo(String type, String date, String week, String time) {
        int tmpTime;
        int tmpDayOfWeek;
        int tmpDay;
        int tmpMonth;
        block5: {
            StringTokenizer st;
            block7: {
                int week_index;
                block8: {
                    block6: {
                        log.info((Object)("sys | initDSTInfo | type | " + type));
                        tmpMonth = 0;
                        tmpDay = 0;
                        tmpDayOfWeek = 0;
                        tmpTime = 0;
                        if (!TYPE_DATE.equals(type)) break block6;
                        st = new StringTokenizer(date, "/");
                        tmpMonth = this.getIntValue(st.nextToken()) - 1;
                        tmpDay = this.getIntValue(st.nextToken());
                        tmpDayOfWeek = 0;
                        break block5;
                    }
                    if (!TYPE_WEEK.equals(type)) break block7;
                    st = new StringTokenizer(week, "/");
                    tmpMonth = this.getIntValue(st.nextToken()) - 1;
                    tmpDay = this.getIntValue(st.nextToken());
                    week_index = this.getIntValue(st.nextToken());
                    tmpDayOfWeek = this.getIntValue(st.nextToken());
                    if (tmpDay == 0 || week_index <= 0) break block8;
                    tmpDay += (week_index - 1) * 7;
                    tmpDayOfWeek = -tmpDayOfWeek;
                    break block5;
                }
                if (tmpDay != 0 && week_index < 0) {
                    tmpDay += (week_index + 1) * 7;
                    tmpDay = -tmpDay;
                    tmpDayOfWeek = -tmpDayOfWeek;
                    break block5;
                } else if (tmpDay == 0 && week_index == -1) {
                    tmpDay = -1;
                    break block5;
                } else {
                    log.info((Object)"sys | initDSTInfo | no such timezone dst rule");
                    return new int[0];
                }
            }
            if (!TYPE_MONTH_WEEK.equals(type)) {
                log.info((Object)("sys | initDSTInfo | type | " + type));
                return new int[0];
            }
            st = new StringTokenizer(week, "/");
            tmpMonth = this.getIntValue(st.nextToken()) - 1;
            st.nextToken();
            tmpDay = this.getIntValue(st.nextToken());
            tmpDayOfWeek = this.getIntValue(st.nextToken());
        }
        tmpTime = this.getTime(time);
        int[] values = new int[]{tmpMonth, tmpDay, this.getWeekDay(tmpDayOfWeek), tmpTime};
        return values;
    }

    private int getWeekDay(int weekvalue) {
        return weekvalue == 0 ? 0 : (weekvalue > 0 ? (weekvalue + 1) % 7 : -(-weekvalue + 1) % 7);
    }

    private void initTZDaylightInfo() {
        this.rawOffset = TimeZone.getTimeZone(this.value_TZ).getRawOffset();
        this.dstSavings = this.getTime(this.value_DSTOffset);
    }

    private void initDSTInfo() {
        int[] startInfo = this.initDSTInfo(this.value_StartType, this.value_StartDate, this.value_StartWeek, this.value_StartTime);
        this.startMonth = startInfo[0];
        this.startDay = startInfo[1];
        this.startDayOfWeek = startInfo[2];
        this.startTime = startInfo[3];
        int[] endInfo = this.initDSTInfo(this.value_EndType, this.value_EndDate, this.value_EndWeek, this.value_EndTime);
        this.endMonth = endInfo[0];
        this.endDay = endInfo[1];
        this.endDayOfWeek = endInfo[2];
        this.endTime = endInfo[3];
    }

    private int getIntValue(String str) {
        try {
            return Integer.valueOf(str);
        }
        catch (Exception e) {
            log.error((Object)e.toString(), (Throwable)e);
            return -1;
        }
    }

    private int getTime(String str) {
        StringTokenizer st = new StringTokenizer(str, ":");
        String value = st.nextToken();
        value = value.indexOf(43) != -1 || value.indexOf(45) != -1 ? value.substring(1) : value;
        int hour = this.getIntValue(value);
        int min = this.getIntValue(st.nextToken());
        int sec = st.hasMoreTokens() ? this.getIntValue(st.nextToken()) : 0;
        int millis = (hour * 3600 + min * 60 + sec) * 1000;
        return millis;
    }

    public void setTZDataRPC(TZDataRPC tzDataRPC) {
        this.tzDataRPC = tzDataRPC;
    }
}

