/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.external.sf.sys.templates.pagingtree.client;

import com.swimap.external.dsf.base.rpc.DataTable;
import com.swimap.external.dsf.base.rpc.RpcEvent;
import com.swimap.external.dsf.base.rpc.RpcMessage;
import com.swimap.external.dsf.base.rpc.RpcNaming;
import com.swimap.external.dsf.base.rpc.RpcRequest;
import com.swimap.external.dsf.base.rpc.RpcResponse;
import com.swimap.external.dsf.base.rpc.RpcServerPush;
import com.swimap.external.dsf.base.rpc.RpcServerPushHandler;
import com.swimap.iview.templates.pagingtree.client.ITreeChangeListener;
import com.swimap.iview.templates.pagingtree.client.ITreeServiceFactory;
import com.swimap.iview.templates.pagingtree.client.PageMapIndex;
import com.swimap.iview.templates.pagingtree.client.RpcTreeServiceProxy;
import com.swimap.iview.templates.pagingtree.csi.ITreeService;
import com.swimap.iview.templates.pagingtree.csi.TreeViewNode;
import com.swimap.iview.util.log.IviewLogger;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class RpcTreeServiceFactory
implements ITreeServiceFactory,
RpcServerPushHandler,
Runnable {
    private static final IviewLogger log = IviewLogger.getLogger(RpcTreeServiceFactory.class, (String)"FRM");
    private static final String TREE_EVENT = "imap.tree.event";
    private static final String CREATE = "imap.tree.service.create";
    private final Map<Long, ITreeChangeListener> listeners = Collections.synchronizedMap(new HashMap());
    private final Map<ITreeChangeListener, Integer> serialNumbers = Collections.synchronizedMap(new HashMap());
    private final Queue<RpcEvent> events = new LinkedList<RpcEvent>();
    private final Object eventsLock = new Object();
    private ExecutorService eventHandler = null;
    private volatile boolean isClosed = false;

    public static RpcTreeServiceFactory getInstance() {
        return new RpcTreeServiceFactory();
    }

    public synchronized ITreeService createTreeService(String provider, int expandLevel, ITreeChangeListener listener, Properties props) throws Exception {
        DataTable propsTable = new DataTable("props");
        if (props != null) {
            Set<Map.Entry<Object, Object>> set = props.entrySet();
            for (Map.Entry<Object, Object> entry : set) {
                propsTable.addParameter(entry.getKey().toString(), entry.getValue());
            }
        }
        RpcRequest req = RpcNaming.createRequest((String)CREATE);
        req.addArgument("provider", (Object)provider);
        req.addArgument("expandLevel", (Object)expandLevel);
        req.addTable(propsTable);
        RpcResponse rsp = req.invoke();
        long id = rsp.getMessage().getLong("id");
        if (this.listeners.isEmpty()) {
            this.listeners.put(id, listener);
            RpcServerPush.addHandler((String)TREE_EVENT, (RpcServerPushHandler)this);
            this.isClosed = false;
            this.eventHandler = Executors.newFixedThreadPool(1);
            this.eventHandler.execute(this);
            this.eventHandler.shutdown();
            log.info((Object)"Added event handler for RpcTreeService");
        } else {
            this.listeners.put(id, listener);
        }
        log.info((Object)("Added listener for id:" + id));
        return new RpcTreeServiceProxy(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void handleServerPush(RpcEvent event) {
        if (event == null) {
            log.warn((Object)"event is null");
            return;
        }
        Object object = this.eventsLock;
        synchronized (object) {
            this.events.add(event);
            log.info((Object)("Current event count:" + this.events.size()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.isClosed) {
            RpcEvent event = null;
            Object object = this.eventsLock;
            synchronized (object) {
                event = this.events.poll();
                if (event == null) {
                    this.events.clear();
                }
            }
            if (event == null) {
                try {
                    TimeUnit.MILLISECONDS.sleep(1000L);
                }
                catch (Exception e) {
                    log.warn((Object)"Unexpected error during sleep");
                }
                continue;
            }
            try {
                this.handleEvents(event);
            }
            catch (Exception e) {
                log.warn((Object)"Handle events caught error.", (Throwable)e);
            }
        }
    }

    private void handleEvents(RpcEvent event) {
        RpcMessage msg = event.getMessage();
        long id = msg.getLong("id");
        String action = msg.getString("action");
        int[] rows = msg.getIntArray("rows");
        ITreeChangeListener listener = this.listeners.get(id);
        if (listener == null) {
            log.warn((Object)("Ignore evnet. No listener for id: " + id));
            return;
        }
        int newSerialNumber = msg.getInt("serialNumber");
        if (!this.serialNumbers.containsKey(listener)) {
            this.serialNumbers.put(listener, newSerialNumber - 1);
        }
        int serialNumber = this.serialNumbers.get(listener);
        int rowCount = msg.getInt("rowCount");
        PageMapIndex pmi = new PageMapIndex(rowCount, newSerialNumber);
        if (newSerialNumber - serialNumber < 1) {
            log.info((Object)("SerialNumber is wrong: id = " + id + ", old number is:" + serialNumber + ", new number is:" + newSerialNumber));
            this.serialNumbers.put(listener, newSerialNumber);
            listener.treeNodeReloaded(rows[0], pmi);
            return;
        }
        this.serialNumbers.put(listener, newSerialNumber);
        try {
            log.info((Object)("sys | handleServerPush | id = " + id + ", action:" + action + ", rows length:" + rows.length + ", serialNumber:" + newSerialNumber));
            if ("add".equals(action)) {
                List<TreeViewNode> changeNodes = RpcTreeServiceProxy.getNodesFromDataTable(msg.getTable("changeNodes"));
                listener.treeNodesAdded(changeNodes.toArray(new TreeViewNode[changeNodes.size()]), rows, pmi);
            } else if ("remove".equals(action)) {
                listener.treeNodesRemoved(rows, pmi);
            } else if ("update".equals(action)) {
                List<TreeViewNode> changeNodes = RpcTreeServiceProxy.getNodesFromDataTable(msg.getTable("changeNodes"));
                listener.treeNodesUpdated(changeNodes.toArray(new TreeViewNode[changeNodes.size()]), rows, pmi);
            } else if ("reload".equals(action)) {
                listener.treeNodeReloaded(rows[0], pmi);
            } else if ("status".equals(action)) {
                String type = msg.getString("status");
                List<int[]> statusList = RpcTreeServiceProxy.getNodesStatusFromDataTable(msg.getTable("changeNodes"));
                listener.treeNodesStatusUpdated(type, statusList, rows, pmi);
            }
        }
        catch (Throwable e) {
            log.error((Object)"Event Call PageTree Exception:", e);
            listener.treeNodeReloaded(rows[0], pmi);
        }
    }

    public synchronized void removeTreeService(ITreeService service) {
        if (service == null) {
            log.info((Object)"sys | removeTreeService | parameter service is null.");
            return;
        }
        log.info((Object)("sys | removeTreeService | id = " + service.getId()));
        this.listeners.remove(service.getId());
        ITreeChangeListener removeTreeChangeListener = this.listeners.remove(service.getId());
        this.serialNumbers.remove(removeTreeChangeListener);
        if (this.listeners.isEmpty()) {
            RpcServerPush.removeHandler((RpcServerPushHandler)this);
            this.isClosed = true;
            this.eventHandler.shutdownNow();
            this.eventHandler = null;
            log.info((Object)"Removed event handler for RpcTreeService");
        }
    }

    public ITreeService createTreeService(String provider, int expandLevel, ITreeChangeListener listener) throws Exception {
        return this.createTreeService(provider, expandLevel, listener, null);
    }
}

