/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.external.sf.filemanager;

import com.swimap.external.sf.clientutil.ClientUtil;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.sf.filemanager.FTPSetting;
import com.swimap.sf.filemanager.FileManagerRpcInvokerProxy;
import java.util.ArrayList;
import java.util.List;

public class FileManagerMetaInfo {
    private static final IviewLogger log = IviewLogger.getLogger(FileManagerMetaInfo.class, (String)"FRM");
    private FileManagerRpcInvokerProxy proxy;
    private static final String TYPE_FTP = "FTP";
    private static final String TYPE_SFTP = "SFTP";
    private static final String TYPE_FTPS = "FTPS";
    private static final String INVALID_PORT = "0";
    private List<MetaInfo> servers;
    private MetaInfo defaultServer;
    private boolean inited = false;

    public List<MetaInfo> getServers() {
        if (this.inited) {
            return this.servers;
        }
        try {
            this.init();
        }
        catch (Exception e) {
            log.error((Object)"Failed to read ftpinfo from server.", (Throwable)e);
            return null;
        }
        return this.servers;
    }

    public MetaInfo getDefaultServer() {
        if (this.inited) {
            return this.defaultServer;
        }
        try {
            this.init();
        }
        catch (Exception e) {
            log.error((Object)"Failed to read ftpinfo from server.", (Throwable)e);
            return null;
        }
        return this.defaultServer;
    }

    void init() throws Exception {
        if (this.proxy == null) {
            this.proxy = new FileManagerRpcInvokerProxy();
        }
        String ftpinfo = this.proxy.getFtpServerInfo();
        this.parseftpinfo(ftpinfo);
        this.setDefaultServer();
        this.inited = true;
    }

    void parseftpinfo(String ftpinfo) throws Exception {
        if (ftpinfo == null) {
            throw new Exception("Invalid ftp info response from server.");
        }
        String[] infos = ftpinfo.split(";");
        if (infos.length < 7) {
            throw new Exception("Invalid ftp info response from server.");
        }
        String ip = ClientUtil.getValidIP(infos[0], 0);
        this.servers = new ArrayList<MetaInfo>(3);
        MetaInfo m1 = new MetaInfo();
        m1.ip = ip;
        m1.user = infos[1];
        m1.userps = infos[2];
        m1.root = infos[6];
        m1.port = infos[3];
        m1.type = TYPE_FTP;
        MetaInfo m2 = new MetaInfo();
        m2.ip = ip;
        m2.user = infos[1];
        m2.userps = infos[2];
        m2.root = infos[6];
        m2.port = infos[4];
        m2.type = TYPE_SFTP;
        MetaInfo m3 = new MetaInfo();
        m3.ip = ip;
        m3.user = infos[1];
        m3.userps = infos[2];
        m3.root = infos[6];
        m3.port = infos[5];
        m3.type = TYPE_FTPS;
        this.servers.add(m1);
        this.servers.add(m2);
        this.servers.add(m3);
    }

    void setDefaultServer() {
        if (this.servers == null) {
            this.defaultServer = null;
            return;
        }
        String info = new FTPSetting().getFtpType();
        if (info != null) {
            this.defaultServer = info.equals(TYPE_SFTP) ? this.servers.get(1) : this.servers.get(0);
            return;
        }
        this.defaultServer = !INVALID_PORT.equals(this.servers.get((int)0).port) ? this.servers.get(0) : (!INVALID_PORT.equals(this.servers.get((int)1).port) ? this.servers.get(1) : null);
    }

    void setProxy(FileManagerRpcInvokerProxy p) {
        this.proxy = p;
    }

    public class MetaInfo {
        public String type;
        public String ip;
        public String port;
        public String user;
        private String userps;
        public String root;

        public String getPassword() {
            char[] dr;
            if (this.userps != null && (dr = ClientUtil.decryptByDynamicKey(this.userps.toCharArray())) != null) {
                return new String(dr);
            }
            return null;
        }
    }
}

