/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.external.sf.filemanager;

import com.swimap.external.sf.filemanager.AbstractFileManager;
import com.swimap.external.sf.filemanager.FileManager;
import com.swimap.external.sf.filemanager.FileManagerMetaInfo;
import com.swimap.sf.filemanager.FTPFileManager;
import com.swimap.sf.filemanager.SFTPFileManager;

public class FileManagerFactory {
    private static final String ftp = "FTP";
    private static final String sftp = "SFTP";

    public static FileManager createFileManager(String protocol) {
        if (ftp.equalsIgnoreCase(protocol)) {
            return new FTPFileManager();
        }
        if (sftp.equalsIgnoreCase(protocol)) {
            return new SFTPFileManager();
        }
        return null;
    }

    public static FileManager defaultFileManager() {
        FileManagerMetaInfo.MetaInfo info = new FileManagerMetaInfo().getDefaultServer();
        if (info == null) {
            return null;
        }
        String serverEncodding = System.getProperty("Client_fileName_Encoding");
        FileManager fm = FileManagerFactory.getFileManager(info);
        if (fm != null && serverEncodding != null && !serverEncodding.isEmpty()) {
            fm.setRemoteFileEncoding(serverEncodding);
        }
        return fm;
    }

    static FileManager getFileManager(FileManagerMetaInfo.MetaInfo info) {
        String protocol = info.type;
        AbstractFileManager fm = ftp.equalsIgnoreCase(protocol) ? new FTPFileManager(info.ip, info.port, info.user, info.getPassword()) : (sftp.equalsIgnoreCase(protocol) ? new SFTPFileManager(info.ip, info.port, info.user, info.getPassword()) : null);
        return fm;
    }
}

