/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.external.sf.filemanager;

import java.util.ArrayList;
import java.util.List;

public class FileAttribute {
    private String name = "";
    private boolean directory = false;
    private long size = 0L;
    private List<FileAttribute> children = new ArrayList<FileAttribute>();

    public void addChild(FileAttribute child) {
        this.children.add(child);
    }

    public long getTotalFileSize(boolean recursive) {
        if (recursive) {
            return this.getTotalFileSizeRecursive();
        }
        return this.getTotalFileSizeNonRecursive();
    }

    private long getTotalFileSizeRecursive() {
        long allSize = 0L;
        if (this.directory && this.children != null) {
            for (FileAttribute child : this.children) {
                allSize += child.getTotalFileSizeRecursive();
            }
        } else {
            allSize += this.size;
        }
        return allSize;
    }

    private long getTotalFileSizeNonRecursive() {
        long allSize = 0L;
        if (this.directory && this.children != null) {
            for (FileAttribute child : this.children) {
                if (child.directory) continue;
                allSize += child.size;
            }
        } else {
            allSize += this.size;
        }
        return allSize;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public void setDirectory(boolean isDirectory) {
        this.directory = isDirectory;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public List<FileAttribute> getChildren() {
        return this.children;
    }

    public void setChildren(List<FileAttribute> children) {
        this.children = children;
    }
}

