/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.external.sf.filemanager;

import com.swimap.external.sf.filemanager.Progress;
import com.swimap.iview.clientutil.ClientUtilModule;
import com.swimap.iview.templates.progressdialog.IStop;
import com.swimap.iview.templates.progressdialog.ProgressDialogTemplate;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class DefaultProgress
extends ProgressDialogTemplate
implements Progress,
IStop {
    private static final IviewLogger log = IviewLogger.getLogger(DefaultProgress.class, (String)"FRM");
    private static final long serialVersionUID = 1L;
    private boolean canceled = false;
    private int progress = 0;
    private boolean display = false;
    private boolean showstopprompt = false;
    private String stopprompt = "";

    public DefaultProgress(JFrame owner, String title, String tipText, Icon icon) {
        super(owner, title, tipText, icon);
        this.setStop(this);
        this.setStyle();
    }

    public DefaultProgress(JDialog owner, String title, String tipText, Icon icon) {
        super(owner, title, tipText, icon);
        this.setStop(this);
        this.setStyle();
    }

    private void setStyle() {
        this.setPreferredSize(new Dimension(360, 150));
        this.getProgressBar().setMaximum(100);
        this.getProgressBar().setStringPainted(true);
    }

    @Override
    public void cancel() {
        this.canceled = true;
    }

    @Override
    public boolean canceled() {
        return this.canceled;
    }

    @Override
    public int getProgress() {
        return this.progress;
    }

    @Override
    public void setProgress(int currentprogress) {
        if (currentprogress < 0 || currentprogress > 100 || currentprogress < this.progress) {
            return;
        }
        if (currentprogress == 100) {
            while (this.display && !this.isVisible()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    log.debug((Object)"Ignore this error.", (Throwable)e);
                }
            }
            if (this.isVisible()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DefaultProgress.this.setVisible(false);
                        DefaultProgress.this.dispose();
                    }
                });
                this.display = false;
            }
        }
        if (this.isVisible()) {
            this.setCurrentValue(currentprogress);
        }
        this.progress = currentprogress;
    }

    public void stop() {
        if (this.showstopprompt) {
            int result = OptionPane.showConfirmDialog((Component)((Object)this), (Object)this.stopprompt, (String)ClientUtilModule.getString("delSureTitle"), (int)0, (int)3);
            if (result == 0) {
                this.cancel();
            }
        } else {
            this.cancel();
        }
    }

    public void setDisply(boolean show) {
        this.display = show;
    }

    public void setShowStopPrompt(boolean show) {
        this.showstopprompt = show;
    }

    public void setStopPromptMessage(String message) {
        this.stopprompt = message;
    }
}

