/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.external.sf.filemanager;

import com.swimap.external.sf.filemanager.FileManager;
import com.swimap.external.sf.filemanager.Progress;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public abstract class AbstractFileManager
implements FileManager {
    @Override
    public int download(String remotefile, String localfile) {
        return this.download(remotefile, localfile, (Progress)null);
    }

    @Override
    public int download(String remotedir, String localdir, boolean recursive) {
        return this.download(remotedir, localdir, recursive, (Progress)null);
    }

    @Override
    public int download(String localPath, String root, String[] remoteFiles) {
        return this.download(localPath, root, remoteFiles, (Progress)null);
    }

    @Override
    public int upload(String root, String[] localFiles, String remotePath) {
        return this.upload(root, localFiles, remotePath, (Progress)null);
    }

    @Override
    public int upload(String localfile, String remotefile) {
        return this.upload(localfile, remotefile, (Progress)null);
    }

    @Override
    public int upload(String localdir, String remotedir, boolean recursive) {
        return this.upload(localdir, remotedir, recursive, (Progress)null);
    }

    @Override
    public Future<Integer> downloadAsync(final String remotefile, final String localfile) {
        ExecutorService e = Executors.newFixedThreadPool(1);
        Future<Integer> result = e.submit(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return AbstractFileManager.this.download(remotefile, localfile);
            }
        });
        e.shutdown();
        return result;
    }

    @Override
    public Future<Integer> downloadAsync(final String remotedir, final String localdir, final boolean recursive) {
        ExecutorService e = Executors.newFixedThreadPool(1);
        Future<Integer> result = e.submit(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return AbstractFileManager.this.download(remotedir, localdir, recursive);
            }
        });
        e.shutdown();
        return result;
    }

    @Override
    public Future<Integer> downloadAsync(final String remotefile, final String localfile, final Progress progress) {
        ExecutorService e = Executors.newFixedThreadPool(1);
        Future<Integer> result = e.submit(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return AbstractFileManager.this.download(remotefile, localfile, progress);
            }
        });
        e.shutdown();
        return result;
    }

    @Override
    public Future<Integer> downloadAsync(final String remotedir, final String localdir, final boolean recursive, final Progress progress) {
        ExecutorService e = Executors.newFixedThreadPool(1);
        Future<Integer> result = e.submit(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return AbstractFileManager.this.download(remotedir, localdir, recursive, progress);
            }
        });
        e.shutdown();
        return result;
    }

    @Override
    public Future<Integer> downloadAsync(final String localPath, final String root, final String[] remoteFiles) {
        ExecutorService e = Executors.newFixedThreadPool(1);
        Future<Integer> result = e.submit(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return AbstractFileManager.this.download(localPath, root, remoteFiles);
            }
        });
        e.shutdown();
        return result;
    }

    @Override
    public Future<Integer> downloadAsync(final String localPath, final String root, final String[] remoteFiles, final Progress progress) {
        ExecutorService e = Executors.newFixedThreadPool(1);
        Future<Integer> result = e.submit(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return AbstractFileManager.this.download(localPath, root, remoteFiles, progress);
            }
        });
        e.shutdown();
        return result;
    }

    @Override
    public Future<Integer> uploadAsync(final String localfile, final String remotefile) {
        ExecutorService e = Executors.newFixedThreadPool(1);
        Future<Integer> result = e.submit(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return AbstractFileManager.this.upload(localfile, remotefile);
            }
        });
        e.shutdown();
        return result;
    }

    @Override
    public Future<Integer> uploadAsync(final String localdir, final String remotedir, final boolean recursive) {
        ExecutorService e = Executors.newFixedThreadPool(1);
        Future<Integer> result = e.submit(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return AbstractFileManager.this.upload(localdir, remotedir, recursive);
            }
        });
        e.shutdown();
        return result;
    }

    @Override
    public Future<Integer> uploadAsync(final String localfile, final String remotefile, final Progress progress) {
        ExecutorService e = Executors.newFixedThreadPool(1);
        Future<Integer> result = e.submit(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return AbstractFileManager.this.upload(localfile, remotefile, progress);
            }
        });
        e.shutdown();
        return result;
    }

    @Override
    public Future<Integer> uploadAsync(final String localdir, final String remotedir, final boolean recursive, final Progress progress) {
        ExecutorService e = Executors.newFixedThreadPool(1);
        Future<Integer> result = e.submit(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return AbstractFileManager.this.upload(localdir, remotedir, recursive, progress);
            }
        });
        e.shutdown();
        return result;
    }

    @Override
    public Future<Integer> uploadAsync(final String root, final String[] localFiles, final String remotePath) {
        ExecutorService e = Executors.newFixedThreadPool(1);
        Future<Integer> result = e.submit(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return AbstractFileManager.this.upload(root, localFiles, remotePath);
            }
        });
        e.shutdown();
        return result;
    }

    @Override
    public Future<Integer> uploadAsync(final String root, final String[] localFiles, final String remotePath, final Progress progress) {
        ExecutorService e = Executors.newFixedThreadPool(1);
        Future<Integer> result = e.submit(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return AbstractFileManager.this.upload(root, localFiles, remotePath, progress);
            }
        });
        e.shutdown();
        return result;
    }
}

