/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.external.sf.clientutil;

import com.swimap.external.cbb.baseutil.AESCipher;
import com.swimap.external.cbb.baseutil.CipherException;
import com.swimap.external.cbb.baseutil.RSACipher;
import com.swimap.external.dsf.base.rpc.RpcRequest;
import com.swimap.external.dsf.base.rpc.RpcResponse;
import com.swimap.iview.clientutil.ClientStartItem;
import com.swimap.iview.clientutil.ClientUtilModule;
import com.swimap.iview.util.log.IviewLogger;
import java.security.Key;

public class ClientUtil {
    private static final IviewLogger logger = IviewLogger.getLogger(ClientUtil.class, (String)"FRM");
    private static Key publicKey;
    private static byte[] encryptedDynamicKey;
    private static Key dynamicKey;

    @Deprecated
    public static RpcResponse invoker(RpcRequest req) throws Exception {
        return ClientUtilModule.invoker(req);
    }

    @Deprecated
    public static String getVaildIPAddress(String ip, int port) {
        return ClientUtilModule.getVaildIPAddress(ip, port);
    }

    public static String getValidIP(String ip, int port) {
        return ClientUtilModule.getValidIP(ip, port);
    }

    public static String[] getHTTPServerAddressInfo() {
        return ClientUtilModule.getInstance().getHedexIpAndPort();
    }

    @Deprecated
    public static String getIpByKey(String ip, String key) {
        return ClientUtilModule.getIpByKey(ip, key);
    }

    public static void setPublicKey(byte[] key) {
        if (key == null) {
            logger.info((Object)"Setting public key null.");
            return;
        }
        try {
            logger.info((Object)"Setting public key begin.");
            publicKey = RSACipher.decodePublicKey((byte[])key);
            dynamicKey = AESCipher.generateDynamicKey();
            byte[] dkey = AESCipher.encodeKey((Key)dynamicKey);
            encryptedDynamicKey = RSACipher.encrypt((byte[])dkey, (Key)publicKey);
            logger.info((Object)"Setting public key end.");
        }
        catch (CipherException e) {
            logger.error((Object)"failed to set public key. ", (Throwable)e);
        }
    }

    public static byte[] encryptByPublicKey(byte[] plain) {
        try {
            return RSACipher.encrypt((byte[])plain, (Key)publicKey);
        }
        catch (CipherException e) {
            logger.error((Object)"failed to encryptByPublicKey. ", (Throwable)e);
            return null;
        }
    }

    public static byte[] getEncryptedDynamicKey() {
        return encryptedDynamicKey;
    }

    public static char[] decryptByDynamicKey(char[] encrypted) {
        try {
            return AESCipher.decrypt((char[])encrypted, (Key)dynamicKey);
        }
        catch (CipherException e) {
            logger.error((Object)"failed to decryptByDynamicKey. ", (Throwable)e);
            return null;
        }
    }

    public static char[] encryptByDynamicKey(char[] plain) {
        try {
            return AESCipher.encrypt((char[])plain, (Key)dynamicKey);
        }
        catch (CipherException e) {
            logger.error((Object)"failed to decryptByDynamicKey. ", (Throwable)e);
            return null;
        }
    }

    public static boolean isComponentEnable(String componentName, int componentType) {
        return ClientStartItem.isComponentEnable(componentName, componentType);
    }
}

