/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.external.cbb.baseutil;

import com.swimap.baseutil.CipherCommonImpl;
import java.util.Arrays;

public class CipherCommon {
    public static char[] encodePlainText(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        if (byArray.length == 0) {
            return new char[0];
        }
        byArray = CipherCommon.dePaddingBytes(byArray);
        char[] cArray = CipherCommonImpl.encodePlainTextNoPadding(byArray);
        Arrays.fill(byArray, (byte)0);
        return cArray;
    }

    public static byte[] decodePlainText(char[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        if (objectArray.length == 0) {
            return new byte[0];
        }
        byte[] byArray = CipherCommonImpl.decodePlainTextNoPadding(objectArray);
        objectArray = byArray;
        byte[] byArray2 = CipherCommon.paddingBytes(byArray);
        Arrays.fill((byte[])objectArray, (byte)0);
        return byArray2;
    }

    static byte[] paddingBytes(byte[] byArray) {
        int n = byArray.length;
        int n2 = n % 16 == 0 ? 0 : 16 - n % 16;
        byte[] byArray2 = new byte[n2 + n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    static byte[] dePaddingBytes(byte[] byArray) {
        int n = byArray.length;
        int n2 = n--;
        while (n >= 0 && byArray[n] == 0) {
            --n2;
            --n;
        }
        if (n2 == 0) {
            return new byte[0];
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    public static char[] encodeEncryptedText(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        char[] cArray = new char[byArray.length << 1];
        for (int i = 0; i < byArray.length; ++i) {
            int n = (byArray[i] & 0xF0) >> 4;
            int n2 = byArray[i] & 0xF;
            cArray[i << 1] = CipherCommon.a(n);
            cArray[(i << 1) + 1] = CipherCommon.a(n2);
        }
        if (cArray.length > 0) {
            cArray[0] = (char)(cArray[0] + 32);
        }
        return cArray;
    }

    private static char a(int n) {
        if (n < 10) {
            return (char)(n + 48);
        }
        return (char)(n - 10 + 65);
    }

    public static byte[] decodeEncryptedText(char[] cArray) {
        if (cArray == null || cArray.length % 2 != 0) {
            return null;
        }
        byte[] byArray = new byte[cArray.length / 2];
        for (int i = 0; i < cArray.length; i += 2) {
            try {
                if (i == 0) {
                    char c2 = cArray[0];
                    c2 = (char)(c2 - 32);
                    byArray[i / 2] = (byte)Short.parseShort("" + c2 + cArray[1], 16);
                    continue;
                }
                byArray[i / 2] = (byte)Short.parseShort("" + cArray[i] + cArray[i + 1], 16);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return byArray;
    }
}

