/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base.upgradecheck;

import com.swimap.iview.framework.modulemanagement.ModuleManagementException;
import com.swimap.iview.framework.modulemanagement.ModuleManager;
import com.swimap.iview.framework.pluginmanagement.CommStyleParser;
import com.swimap.iview.framework.pluginmanagement.Plugin;
import com.swimap.iview.framework.pluginmanagement.PluginManager;
import com.swimap.iview.framework.systemsettingsmanagement.BaseClientSettings;
import com.swimap.iview.framework.systemsettingsmanagement.treetype.PreferenceManager;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.helpmanagement.HelpManager;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.sm.client.base.auth.ResCenter;
import com.swimap.sm.client.base.common.RpcInvoker;
import com.swimap.sm.client.base.config.UpgradeIntevalParser;
import com.swimap.sm.client.base.upgradecheck.UpgradeCheckTool;
import com.swimap.sm.client.loginui.common.SMTraceProxy;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.omg.CORBA.ORB;

public class UpgradeSettingModule
extends BaseClientSettings {
    private IviewLogger log = SMTraceProxy.getLogger(UpgradeSettingModule.class);
    private static String NEXT_LOGIN;
    private static String ONE_HOUR;
    private static String FOUR_HOURS;
    private static String TWENTYFOUR_HOURS;
    private final Dimension MIDDLE_GAP = new Dimension(10, 1);
    private JPanel panel;
    private JComboBox box;
    private boolean isChanged;
    private static int lastSelectedIndex;
    private UpgradeIntevalParser upgradeIntevalParser;
    private ResCenter resCenter;
    private Plugin plugin;
    private PreferenceManager preferenceManager;

    public UpgradeSettingModule(ModuleManager moduleMgr, ORB orbRef, String terminalIdValue, String instanceIdValue) throws ModuleManagementException {
        super(moduleMgr);
    }

    public UpgradeSettingModule(ModuleManager moduleManager) throws ModuleManagementException {
        super(moduleManager);
    }

    public void setResCenter(ResCenter res) {
        this.resCenter = res;
    }

    public void setPlugin(Plugin plg) {
        this.plugin = plg;
    }

    private ResCenter getResCenter() {
        if (this.resCenter == null) {
            this.resCenter = ResCenter.getInstance();
        }
        return this.resCenter;
    }

    private Plugin getPlugin() {
        if (this.plugin == null) {
            this.plugin = PluginManager.getInstance().getPlugin("authentication");
        }
        return this.plugin;
    }

    private void initRes() {
        NEXT_LOGIN = this.getResCenter().getString("upgrade_nextLogin");
        ONE_HOUR = this.getResCenter().getString("upgrade_oneHour");
        FOUR_HOURS = this.getResCenter().getString("upgrade_fourHours");
        TWENTYFOUR_HOURS = this.getResCenter().getString("upgrade_twentyfourHours");
    }

    public Icon getTabIcon() {
        return null;
    }

    public String getTabLabel() {
        return this.getResCenter().getString("upgradeTabTitle");
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public JPanel getSettingsPanel() {
        this.initRes();
        this.init();
        return this.panel;
    }

    public boolean exit() {
        if (this.isChanged) {
            this.box.setSelectedIndex(lastSelectedIndex);
            this.isChanged = false;
        }
        return true;
    }

    public boolean apply() {
        if (this.isChanged) {
            int interval = this.box.getSelectedIndex();
            UpgradeCheckTool upgradeTimer = new UpgradeCheckTool(RpcInvoker.getInstance(), ResCenter.getInstance());
            upgradeTimer.setUpgradeTimerInterval(interval);
            this.log.info((Object)"UpgradeSettingModule | apply | begin to invoke timer to check version.");
            this.upgradeIntevalParser.saveUpgradeInterval(interval);
            lastSelectedIndex = interval;
            this.isChanged = false;
        }
        return true;
    }

    public static int getUpgradeInterval() {
        int tmpInterval = -1;
        if (lastSelectedIndex == 0) {
            tmpInterval = 0;
        } else if (lastSelectedIndex == 1) {
            tmpInterval = 1;
        } else if (lastSelectedIndex == 2) {
            tmpInterval = 4;
        } else if (lastSelectedIndex == 3) {
            tmpInterval = 24;
        }
        return tmpInterval;
    }

    public String getModuleName() {
        return "UpgradeSettingModule";
    }

    private void init() {
        this.panel = new JPanel();
        this.panel.setName("SM_UPGRADEPANEL");
        Vector<String> items = new Vector<String>();
        items.add(NEXT_LOGIN);
        items.add(ONE_HOUR);
        items.add(FOUR_HOURS);
        items.add(TWENTYFOUR_HOURS);
        this.box = new JComboBox(items);
        this.box.setName("SM_UpgradeSettingPanel_JComboBox_box");
        this.box.setPreferredSize(new Dimension(120, 21));
        Border border = BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140));
        TitledBorder titledBorder = new TitledBorder(border, this.getResCenter().getString("autoUpgradeDetect"));
        this.panel.setLayout(new GridBagLayout());
        this.panel.setBorder(new EmptyBorder(new Insets(12, 12, 12, 12)));
        JPanel upgradePanel = new JPanel();
        upgradePanel.setLayout(new GridBagLayout());
        this.panel.add((Component)new JLabel(this.getResCenter().getString("Auto_Check_Upgrade_Msg")), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 5, 10, 0), 0, 0));
        this.panel.add((Component)upgradePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        JLabel label = new JLabel(this.getResCenter().getString("upgradeIntervalLabel"));
        label.setName("SM_UpgradeSettingPanel_JLabel_label");
        JPanel settingPanel = new JPanel();
        settingPanel.setLayout(new BoxLayout(settingPanel, 0));
        settingPanel.add(label);
        settingPanel.add(Box.createRigidArea(this.MIDDLE_GAP));
        settingPanel.add(this.box);
        upgradePanel.add((Component)settingPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 10, 10, 10), 0, 0));
        upgradePanel.setBorder(titledBorder);
        HelpManager.getInstance().enableHelpKey((Component)this.panel, "iVIEW.Security.Upgrade_Setting");
    }

    private PreferenceManager getPreferenceManager() {
        if (this.preferenceManager == null) {
            this.preferenceManager = FrameworkUtilities.getPreferenceManager();
        }
        return this.preferenceManager;
    }

    public void setPreferenceManager(PreferenceManager mgr) {
        this.preferenceManager = mgr;
    }

    private void notifyChange() {
        this.getPreferenceManager().notifyChanged();
    }

    public int getTitleDescription() {
        return 1;
    }

    protected void postSystemLoadingFinished() {
        Plugin plugin = this.getPlugin();
        CommStyleParser commStyleParser = plugin.getCommStyleParser();
        this.upgradeIntevalParser = new UpgradeIntevalParser(commStyleParser);
        int interval = this.upgradeIntevalParser.getUpgradeInterval();
        this.box.setSelectedIndex(interval == 1000 ? 0 : interval);
        lastSelectedIndex = interval;
        this.box.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                UpgradeSettingModule.this.isChanged = true;
                UpgradeSettingModule.this.notifyChange();
            }
        });
    }

    static {
        lastSelectedIndex = -1;
    }
}

