/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base.upgradecheck;

import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.jni.Os;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.sm.client.base.SecurityBaseModule;
import com.swimap.sm.client.base.auth.ResCenter;
import com.swimap.sm.client.base.auth.VersionCheckErrorInfo;
import com.swimap.sm.client.base.common.BaseConstants;
import com.swimap.sm.client.base.common.GuiUtilForBase;
import com.swimap.sm.client.base.common.OptionPaneProxy4SmBase;
import com.swimap.sm.client.base.common.RpcInvoker;
import com.swimap.sm.client.base.common.ScriptExecutor;
import com.swimap.sm.client.base.common.SecurityTimer;
import com.swimap.sm.client.base.common.model.CAUServerInfo;
import com.swimap.sm.client.loginui.common.SMTraceProxy;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;

public class UpgradeCheckTool {
    private IviewLogger log = SMTraceProxy.getLogger(UpgradeCheckTool.class);
    private final int SYS_INIT_ERROR_CODE = 30006;
    private Object lock = new Object();
    private boolean isDoingUpgradeCheck = false;
    private ArrayList<String> parameters = new ArrayList(0);
    private RpcInvoker rpcInvoker = null;
    private Os os = Os.getOs();
    private final int TIMEOUT = 10000;
    private ResCenter resCenter;
    private UpgradeCheckTimer upgradeTimer;

    public UpgradeCheckTool(RpcInvoker rpcInvoker, ResCenter resCenter) {
        this.rpcInvoker = rpcInvoker;
        this.resCenter = resCenter;
    }

    public void setUpgradeTimerInterval(int interval) {
        if (this.upgradeTimer != null) {
            this.upgradeTimer.stopTimer();
            this.upgradeTimer = null;
        }
        if (interval > 0 && interval <= 3 || interval == 1000) {
            this.upgradeTimer = new UpgradeCheckTimer();
            long period = 1000L;
            if (interval != 1000) {
                period = (long)BaseConstants.UpgradeInterval.HOURS[interval] * 3600000L;
            }
            this.upgradeTimer.setInterval(period);
            this.upgradeTimer.start();
            this.log.info((Object)("DataSource | Set upgrade check interval : " + interval));
        }
    }

    public void upgradeCheck(boolean byUpgradeTimer) {
        if (this.isDoingUpgradeCheck()) {
            return;
        }
        this.setIsDoingUpgradeCheck(true);
        final StringBuilder buf = new StringBuilder();
        int result = this.checkVersion(buf, byUpgradeTimer);
        this.log.info((Object)("GuiUtil | upgradeCheck | result = " + result));
        if (BaseConstants.CheckVersionResult.VERSION_NEED_UPDATE == result) {
            short type;
            short s = type = byUpgradeTimer ? (short)2 : 3;
            if (this.isReadytoUpdate(type)) {
                this.updateClient(type);
            }
        } else if (!byUpgradeTimer && result == BaseConstants.CheckVersionResult.VESION_MATCHED) {
            if (SwingUtilities.isEventDispatchThread()) {
                OptionPaneProxy4SmBase.showInformationDlg(FrameworkUtilities.getMainFrame(), ResCenter.RES.getString("manual_upgrade_ver_match"));
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        OptionPaneProxy4SmBase.showInformationDlg(FrameworkUtilities.getMainFrame(), ResCenter.RES.getString("manual_upgrade_ver_match"));
                    }
                });
            }
        } else if (!byUpgradeTimer && !"".equals(buf.toString())) {
            if (SwingUtilities.isEventDispatchThread()) {
                OptionPaneProxy4SmBase.showInformationDlg(FrameworkUtilities.getMainFrame(), buf.toString());
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        OptionPaneProxy4SmBase.showInformationDlg(FrameworkUtilities.getMainFrame(), buf.toString());
                    }
                });
            }
        }
        this.setIsDoingUpgradeCheck(false);
    }

    public int getClientCount() {
        String mainClassName = SecurityBaseModule.getSecuityModuleRef().getSecurityConfig().getClientMainClassName();
        ResourceBundle bundle = SecurityBaseModule.getSecuityModuleRef().getResourceBundleFromPropertyFile("mainfrm/Res");
        String frameTitle = bundle.getString("Main_MDIFrame_Title");
        this.log.info((Object)("The ClientMainClassName = " + mainClassName + " , " + "Main_MDIFrame_Title = " + frameTitle));
        return this.os.getOnlineWindowNumber(mainClassName, frameTitle);
    }

    public int getUpgradeCount() {
        String upgradeClassName = SecurityBaseModule.getSecuityModuleRef().getSecurityConfig().getClientUpgradeClassName();
        String upgradeTitle = SecurityBaseModule.getSecuityModuleRef().getSecurityConfig().getClientUpgradeTitle();
        this.log.info((Object)("The ClientUpgradeClassName = " + upgradeClassName + " , " + "Upgrade Tool Title = " + upgradeTitle));
        return this.os.getOnlineWindowNumber(upgradeClassName, upgradeTitle);
    }

    public boolean isReadytoUpdate(short type) {
        int clientCount = this.getClientCount();
        int updateCount = this.getUpgradeCount();
        this.log.info((Object)("Number of client(s) on this machine = " + clientCount + " , Number of upgrade tool(s) = " + updateCount));
        if (clientCount > 1) {
            this.showMessage(type, ResCenter.RES.getString("Upgrade_MoreThanOneClient"));
            return false;
        }
        if (updateCount > 0) {
            this.showMessage(type, ResCenter.RES.getString("Upgrade_IsUpgrading"));
            return false;
        }
        return true;
    }

    public void showMessage(final short type, final String msg) {
        if (0 != type) {
            this.prepareToLogout();
        }
        if (SwingUtilities.isEventDispatchThread()) {
            OptionPaneProxy4SmBase.showInformationDlg(FrameworkUtilities.getMainFrame(), msg);
            if (2 == type || 3 == type) {
                SecurityBaseModule.getSecuityModuleRef().logout();
            }
            this.preExit();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OptionPaneProxy4SmBase.showInformationDlg(FrameworkUtilities.getMainFrame(), msg);
                    if (2 == type || 3 == type) {
                        SecurityBaseModule.getSecuityModuleRef().logout();
                    }
                    UpgradeCheckTool.this.preExit();
                }
            });
        }
    }

    public void prepareToLogout() {
        GuiUtilForBase.isbExit();
        if (this.upgradeTimer != null) {
            this.upgradeTimer.stopTimer();
            this.upgradeTimer = null;
        }
        this.log.info((Object)"GuiUtil | prepareToLogout | pauseLockWindow() ...");
        FrameworkUtilities.getTerminalManager().pauseLockWindow();
    }

    public void stopTimer() {
        if (this.upgradeTimer != null) {
            this.upgradeTimer.stopTimer();
            try {
                this.upgradeTimer.interrupt();
            }
            catch (Exception ex) {
                this.log.error((Object)"", (Throwable)ex);
            }
            this.upgradeTimer = null;
        }
    }

    public void updateClient(final short type) {
        GuiUtilForBase.setToBeingExit();
        ScriptExecutor.executeBatFile();
        if (null == this.parameters) {
            this.parameters = this.getUpdateInfo();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String methodName = "startClientAutoUpgrade";
                Class[] args = new Class[]{ArrayList.class};
                StringBuilder sb = new StringBuilder();
                int size = UpgradeCheckTool.this.parameters.size();
                for (int i = 0; i < size; ++i) {
                    sb.append(UpgradeCheckTool.this.parameters.get(i));
                    sb.append(" ");
                }
                UpgradeCheckTool.this.log.info((Object)("Update script is : " + sb));
                try {
                    Class<?> responds = Class.forName("com.swimap.cmf.cau.ClientAutoUpgrade");
                    Method method = responds.getMethod(methodName, args);
                    Object resutl = method.invoke(responds.newInstance(), UpgradeCheckTool.this.parameters);
                    UpgradeCheckTool.this.log.info((Object)("PolicyMgr | updateClient | reflect method return result is " + resutl));
                }
                catch (Exception ex) {
                    UpgradeCheckTool.this.log.error((Object)"", (Throwable)ex);
                    OptionPaneProxy4SmBase.showInformationDlg(FrameworkUtilities.getMainFrame(), ResCenter.RES.getString("SM_WRONG_PARAM"));
                    return;
                }
                if (2 == type || 3 == type) {
                    SecurityBaseModule.getSecuityModuleRef().logout();
                }
                UpgradeCheckTool.this.preExit();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preExit() {
        try {
            String className = SecurityBaseModule.getSecuityModuleRef().getSecurityConfig().getProductExitClassPath();
            if (className == null) {
                this.log.info((Object)"GuiUtil | PreExit | getProductExitClassPath is null");
            } else if ("".equals(className.trim())) {
                this.log.info((Object)"GuiUtil | PreExit | getProductExitClassPath is empty");
            } else {
                try {
                    Class<?> ProductExitClass = Class.forName(className);
                    Class[] params = new Class[]{};
                    Method methods = ProductExitClass.getMethod("doPreExitAction", params);
                    Timer timer = new Timer();
                    timer.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            UpgradeCheckTool.this.log.info((Object)"GuiUtil | PreExit | System.exit(-1).");
                            GuiUtilForBase.exit();
                        }
                    }, 10000L);
                    this.log.info((Object)"GuiUtil | PreExit | begin to doPreExitAction.");
                    Object[] objs = new Object[]{};
                    boolean bSeccuse = (Boolean)methods.invoke(ProductExitClass.newInstance(), objs);
                    this.log.info((Object)("GuiUtil | PreExit | doPreExitAction return:" + bSeccuse));
                }
                catch (Exception e) {
                    this.log.error((Object)e);
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)"", (Throwable)e);
        }
        finally {
            System.exit(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setIsDoingUpgradeCheck(boolean flag) {
        Object object = this.lock;
        synchronized (object) {
            this.isDoingUpgradeCheck = flag;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDoingUpgradeCheck() {
        Object object = this.lock;
        synchronized (object) {
            return this.isDoingUpgradeCheck;
        }
    }

    public int checkVersion(StringBuilder buff, boolean byUpgradeTimer) {
        String errMessage;
        int updateResult;
        block8: {
            updateResult = BaseConstants.CheckVersionResult.CHECK_VERSION_FAILED;
            String verid = "";
            errMessage = "";
            try {
                this.log.info((Object)"GuiUtil | checkVersion | Begin to call getVersion[RPC]...");
                long t1 = System.currentTimeMillis();
                HashMap<String, Object> returnValue = this.rpcInvoker.getClientMatchVersion();
                long t2 = System.currentTimeMillis();
                int result = (Integer)returnValue.get("result");
                this.log.info((Object)("UpgradeCheckTimer | checkVersion | getVersion[RPC] = " + result + "; cost time = " + (t2 - t1)));
                verid = SecurityBaseModule.getSecuityModuleRef().getVersionID();
                if (result == 30006) {
                    errMessage = this.resCenter.getString("System_Init_State_Error");
                    buff.append(errMessage);
                    this.log.info((Object)"UpgradeCheckTimer | checkVersion | System is in init State.");
                    return BaseConstants.CheckVersionResult.CHECK_VERSION_FAILED;
                }
                if (result == 0) {
                    String[] serverVersionArray = (String[])returnValue.get("clientVersion");
                    int checkResult = this.getCheckResult(verid, serverVersionArray);
                    if (1 == checkResult) {
                        this.parameters = this.getUpdateInfo();
                        if (this.parameters.size() == 0) {
                            this.log.info((Object)"UpgradeCheckTimer | checkVersion | with error.");
                            checkResult = 2;
                        }
                    }
                    Object[] errorInfo = VersionCheckErrorInfo.getInstance().getVersionCheckErrorInfo(checkResult, verid, serverVersionArray);
                    errMessage = (String)errorInfo[0];
                    updateResult = (Integer)errorInfo[1];
                } else {
                    this.log.info((Object)("UpgradeCheckTimer | checkVersion | getVersion Error , Error code =  " + result));
                    errMessage = this.resCenter.getString("GetServerVersionListErr");
                }
            }
            catch (Exception e) {
                this.log.info((Object)"UpgradeCheckTimer | checkVersion | checkVersion with unknown error. ", (Throwable)e);
                if (byUpgradeTimer) break block8;
                errMessage = this.resCenter.getString("corbaerror");
            }
        }
        if (!"".equals(errMessage)) {
            buff.append(errMessage);
        }
        return updateResult;
    }

    public int getCheckResult(String clientVerID, String[] matchIDs) {
        ArrayList<String> serverVersionList = null;
        if (null != matchIDs) {
            int strsLength = matchIDs.length;
            serverVersionList = new ArrayList<String>(strsLength);
            for (int i = 0; i < strsLength; ++i) {
                serverVersionList.add(i, matchIDs[i]);
                this.log.info((Object)("UpgradeCheckTimer | checkVersion | Server Version : " + matchIDs[i]));
            }
        }
        int checkResult = 0;
        String className = SecurityBaseModule.getSecuityModuleRef().getSecurityConfig().getVersionCompareClassName();
        if (className == null) {
            this.log.info((Object)"version check calss name null");
            checkResult = UpgradeCheckTool.platformVersionCompare(clientVerID, matchIDs);
            return checkResult;
        }
        String classname = className.trim();
        if ("".equals(classname)) {
            this.log.info((Object)("Get Product Version Compare Class Name Error , Class Name =  " + className));
            checkResult = UpgradeCheckTool.platformVersionCompare(clientVerID, matchIDs);
        } else {
            try {
                Class<?> iVersionManager = Class.forName(classname);
                Class[] params = new Class[]{String.class, ArrayList.class};
                Method methods = iVersionManager.getMethod("compareVersion", params);
                Object[] objs = new Object[]{clientVerID, serverVersionList};
                checkResult = (Integer)methods.invoke(iVersionManager.newInstance(), objs);
            }
            catch (ClassNotFoundException e) {
                checkResult = UpgradeCheckTool.platformVersionCompare(clientVerID, matchIDs);
            }
            catch (NoSuchMethodException e) {
                checkResult = UpgradeCheckTool.platformVersionCompare(clientVerID, matchIDs);
            }
            catch (Exception e) {
                this.log.info((Object)"UpgradeCheckTimer | checkVersion | ", (Throwable)e);
                checkResult = BaseConstants.CheckVersionResult.CHECK_VERSION_FAILED;
            }
        }
        this.log.info((Object)("GuiUtil | getCheckResult | check version result = " + checkResult));
        return checkResult;
    }

    private static int platformVersionCompare(String clientVer, String[] matchedClientVer) {
        int checkResult = 1;
        if (null == matchedClientVer) {
            return 2;
        }
        for (int i = matchedClientVer.length - 1; i >= 0; --i) {
            if (!matchedClientVer[i].equalsIgnoreCase(clientVer)) continue;
            checkResult = 0;
        }
        return checkResult;
    }

    public ArrayList<String> getUpdateInfo() {
        ArrayList<String> list = new ArrayList<String>(0);
        CAUServerInfo clientUpgradeInfo = new CAUServerInfo();
        try {
            clientUpgradeInfo = this.rpcInvoker.getCAUServerInfo();
        }
        catch (Exception e) {
            this.log.error((Object)"", (Throwable)e);
            return new ArrayList<String>();
        }
        String serverIP = clientUpgradeInfo.getServerIP();
        String commonPort = clientUpgradeInfo.getCommonPort();
        String sslPort = clientUpgradeInfo.getSslPort();
        if (serverIP == null || commonPort == null || sslPort == null) {
            return new ArrayList<String>();
        }
        list.add(serverIP);
        if (GuiUtilForBase.isSSL) {
            list.add(sslPort);
        } else {
            list.add(commonPort);
        }
        return list;
    }

    class UpgradeCheckTimer
    extends SecurityTimer {
        UpgradeCheckTimer() {
        }

        @Override
        protected void process() {
            UpgradeCheckTool.this.upgradeCheck(true);
        }
    }
}

