/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base.upgrade;

import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.xmlbind.PARA;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.sm.client.loginui.common.SMTraceProxy;
import java.io.File;

public class Merger {
    private static IviewLogger log = SMTraceProxy.getLogger(Merger.class);

    public static void merge(String[][] files) {
        if (files != null && files.length > 0) {
            for (String[] file : files) {
                Merger.merge(file[0], file[1]);
            }
        }
    }

    public static void move(String srcDir, String destDir, String fileName) {
        File srcFile = new File(srcDir + fileName);
        File dir = new File(destDir);
        dir.mkdirs();
        srcFile.renameTo(new File(dir, srcFile.getName()));
        new File(srcDir).delete();
    }

    private static void merge(String oldFile, String newFile) {
        CommStyleInfo from = CommStyleManager.getInstance().getAbsCommStyleFile(oldFile);
        CommStyleInfo to = CommStyleManager.getInstance().getAbsCommStyleFile(newFile);
        if (null != from && null != to) {
            Merger.merge(from, to);
        } else {
            log.error((Object)"fail to merge. from or to is null.");
        }
    }

    private static void merge(CommStyleInfo from, CommStyleInfo to) {
        int count = to.getAreaDescContainerCount();
        for (int i = 0; i < count; ++i) {
            AreaDescContainer fromArea;
            AreaDescContainer toArea = to.getAreaDescContainer(i);
            String toAreaName = toArea.getAreaName();
            if (Merger.isValid(toAreaName)) {
                fromArea = from.getAreaDescContainer(toAreaName);
                if (fromArea == null) continue;
                Merger.merge(fromArea, toArea);
                continue;
            }
            fromArea = from.getAreaDescContainer(i);
            String fromAreaName = fromArea.getAreaName();
            if (Merger.isValid(fromAreaName)) continue;
            Merger.merge(fromArea, toArea);
        }
        to.writeBack();
    }

    private static void merge(AreaDescContainer fromArea, AreaDescContainer toArea) {
        int count = toArea.getDescContainerCount();
        for (int i = 0; i < count; ++i) {
            DescContainer toDesc = toArea.getDescContainer(i);
            String toDescName = toDesc.getDescName();
            DescContainer fromDesc = fromArea.getDescContainer(toDescName);
            if (fromDesc == null) continue;
            Merger.merge(fromDesc, toDesc);
        }
    }

    private static void merge(DescContainer fromDesc, DescContainer toDesc) {
        int count = toDesc.getDescContainerCount();
        for (int i = 0; i < count; ++i) {
            DescContainer toDescContainer = toDesc.getDescContainer(i);
            String toDescName = toDescContainer.getDescName();
            DescContainer fromDescContainer = fromDesc.getDescContainer(toDescName);
            if (fromDescContainer == null) continue;
            Merger.merge(fromDescContainer, toDescContainer);
        }
        Merger.mergeValue(fromDesc, toDesc);
    }

    private static void mergeValue(DescContainer fromDesc, DescContainer toDesc) {
        int count = toDesc.getParasItemCount();
        for (int i = 0; i < count; ++i) {
            String toParaName;
            PARA fromPara;
            PARA toPara = toDesc.getParasItem(i);
            if (null == toPara || (fromPara = fromDesc.getParasItem(toParaName = toPara.getName())) == null) continue;
            toPara.setValue(fromPara.getValue());
        }
    }

    private static boolean isValid(String str) {
        return str != null && !"".equals(str);
    }
}

