/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base.systemmode;

import com.swimap.iview.framework.modulemanagement.ModuleManagementException;
import com.swimap.iview.framework.modulemanagement.ModuleManager;
import com.swimap.iview.framework.systemsettingsmanagement.BaseClientSettings;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.helpmanagement.HelpManager;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.sm.client.base.SecurityBaseModule;
import com.swimap.sm.client.base.auth.ResCenter;
import com.swimap.sm.client.base.common.GuiUtilForBase;
import com.swimap.sm.client.base.common.RpcInvoker;
import com.swimap.sm.client.base.systemmode.SysModeManager;
import com.swimap.sm.client.loginui.common.SMTraceProxy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.omg.CORBA.ORB;

public class SysModeSetting
extends BaseClientSettings
implements ItemListener {
    private boolean isChanged;
    private JPanel panel;
    private SysModeManager sysModelMgr;
    private JRadioButton singleModelButton;
    private JRadioButton multiModelButton;
    private static int UNKNOW_MODE = -1;
    private JTextArea singleModelText = new JTextArea(ResCenter.RES.getString("Sys_login_mode_single"));
    private JTextArea multiModelText = new JTextArea(ResCenter.RES.getString("Sys_login_mode_multi"));
    private int lastSysMode = UNKNOW_MODE;
    private JTextArea desc;
    private IviewLogger log = SMTraceProxy.getLogger(SysModeSetting.class);

    public SysModeSetting(ModuleManager moduleMgr, ORB orbRef, String terminalIdValue, String instanceIdValue) throws ModuleManagementException {
        super(moduleMgr, orbRef, terminalIdValue, instanceIdValue);
        this.sysModelMgr = new SysModeManager(SecurityBaseModule.getSecuityModuleRef().getStatusBarSettingProxy(), RpcInvoker.getInstance(), ResCenter.getInstance());
        this.init();
    }

    public boolean actived() {
        this.singleModelButton.setEnabled(this.sysModelMgr.checkRight());
        this.multiModelButton.setEnabled(this.sysModelMgr.checkRight());
        this.desc.setText(GuiUtilForBase.bundleString(ResCenter.RES.getString("Sys_login_mode_tip"), this.sysModelMgr.getServerIP()));
        int width = this.panel.getParent().getWidth() - 15;
        this.desc.setSize(new Dimension(width, 60));
        this.singleModelText.setSize(new Dimension(width - 20, 60));
        this.multiModelText.setSize(new Dimension(width - 20, 60));
        this.panel.repaint();
        return true;
    }

    public String getModuleName() {
        return "SysModeSetting";
    }

    private void init() {
        this.panel = new JPanel();
        this.panel.setName("JPanel_panel");
        this.panel.setLayout(new BorderLayout());
        JPanel descPanel = new JPanel(new GridBagLayout());
        this.desc = new JTextArea(GuiUtilForBase.bundleString(ResCenter.RES.getString("Sys_login_mode_tip"), this.sysModelMgr.getServerIP()));
        this.desc.setName("JLabel_desc");
        this.desc.setLineWrap(true);
        this.desc.setEditable(false);
        this.desc.setWrapStyleWord(true);
        this.desc.setFocusable(false);
        this.desc.setFont(UIManager.getFont("Label.font"));
        this.desc.setOpaque(false);
        this.desc.setMinimumSize(new Dimension(100, 20));
        descPanel.add((Component)this.desc, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.panel.add((Component)descPanel, "North");
        JPanel settingPanel = new JPanel();
        settingPanel.setLayout(new GridBagLayout());
        settingPanel.setName("JPanel_settingPanel");
        ButtonGroup group = new ButtonGroup();
        this.singleModelText.setLineWrap(true);
        this.singleModelText.setEditable(false);
        this.singleModelText.setFocusable(false);
        this.singleModelText.setWrapStyleWord(true);
        this.singleModelText.setFont(UIManager.getFont("Label.font"));
        this.singleModelText.setOpaque(false);
        this.singleModelText.setMinimumSize(new Dimension(80, 20));
        this.multiModelText.setLineWrap(true);
        this.multiModelText.setEditable(false);
        this.multiModelText.setFocusable(false);
        this.multiModelText.setWrapStyleWord(true);
        this.multiModelText.setFont(UIManager.getFont("Label.font"));
        this.multiModelText.setOpaque(false);
        this.multiModelText.setMinimumSize(new Dimension(80, 20));
        this.singleModelButton = new JRadioButton();
        this.multiModelButton = new JRadioButton();
        this.singleModelButton.setName("JRadioButton_singleModelButton");
        this.multiModelButton.setName("JRadioButton_multiModelButton");
        group.add(this.singleModelButton);
        group.add(this.multiModelButton);
        this.lastSysMode = this.sysModelMgr.getSystemMode();
        if (this.lastSysMode == 1) {
            this.multiModelButton.setSelected(true);
        } else {
            this.singleModelButton.setSelected(true);
        }
        this.singleModelButton.addItemListener(this);
        this.multiModelText.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SysModeSetting.this.sysModelMgr.checkRight()) {
                    SysModeSetting.this.multiModelButton.setSelected(true);
                }
            }
        });
        this.singleModelText.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SysModeSetting.this.sysModelMgr.checkRight()) {
                    SysModeSetting.this.singleModelButton.setSelected(true);
                }
            }
        });
        settingPanel.add((Component)this.singleModelButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 8, 0, 0), 0, 0));
        settingPanel.add((Component)this.singleModelText, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        settingPanel.add((Component)this.multiModelButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(30, 8, 0, 0), 0, 0));
        settingPanel.add((Component)this.multiModelText, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 18, 0, new Insets(30, 0, 0, 0), 0, 0));
        JPanel settingParentPanel = new JPanel(new BorderLayout());
        settingParentPanel.add((Component)settingPanel, "North");
        this.panel.add((Component)settingParentPanel, "Center");
        this.panel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int width = (int)(((JPanel)e.getSource()).getSize().getWidth() - 15.0);
                SysModeSetting.this.desc.setPreferredSize(new Dimension(width, 60));
                SysModeSetting.this.desc.updateUI();
                SysModeSetting.this.singleModelText.setSize(new Dimension(width - 20, 60));
                SysModeSetting.this.singleModelText.updateUI();
                SysModeSetting.this.multiModelText.setPreferredSize(new Dimension(width - 20, 60));
                SysModeSetting.this.multiModelText.updateUI();
                SysModeSetting.this.panel.revalidate();
                SysModeSetting.this.panel.repaint();
            }
        });
        HelpManager.getInstance().enableHelpKey((Component)this.panel, "iVIEW.Security.SysModeSetting");
        this.log.info((Object)"SysModeSetting init successfully.");
    }

    public void reinitialize() {
        this.log.info((Object)"SM SysModeSetting reinitialize start.");
        if (null != this.desc) {
            this.desc.setText(GuiUtilForBase.bundleString(ResCenter.RES.getString("Sys_login_mode_tip"), this.sysModelMgr.getServerIP()));
        }
        super.reinitialize();
        this.log.info((Object)"SM SysModeSetting reinitialize finished.");
    }

    private void resetSysModel() {
        if (this.lastSysMode == 1) {
            this.multiModelButton.setSelected(true);
        } else {
            this.singleModelButton.setSelected(true);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.isChanged = true;
        this.notifyChange();
    }

    public Icon getTabIcon() {
        this.log.info((Object)"SM SysModeSetting getTabIcon successfully.");
        return null;
    }

    public String getTabLabel() {
        return ResCenter.RES.getString("Sys_login_mode_node");
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public JPanel getSettingsPanel() {
        this.log.info((Object)"call the SysModeSetting getSettingsPanel successfully.");
        return this.panel;
    }

    public boolean exit() {
        this.log.info((Object)"start exit SM SysModeSetting.");
        if (this.isChanged) {
            this.resetSysModel();
            this.isChanged = false;
        }
        this.log.info((Object)"exit SM SysModeSetting Successfully.");
        return true;
    }

    public boolean apply() {
        if (this.isChanged) {
            int systemMode = this.multiModelButton.isSelected() ? 1 : 0;
            int settingModeResult = this.sysModelMgr.setSystemMode(systemMode);
            if (settingModeResult == SysModeManager.MODE_SETTING_SUCCESS) {
                this.lastSysMode = systemMode;
                this.isChanged = false;
            } else if (settingModeResult == SysModeManager.MODE_SETTING_CANCLE) {
                this.multiModelButton.setSelected(true);
                this.isChanged = true;
            }
        }
        this.log.info((Object)"SysModeSetting apply Successfully.");
        return !this.isChanged;
    }

    private void notifyChange() {
        FrameworkUtilities.getPreferenceManager().notifyChanged();
    }

    public void refreshState(int mode) {
        this.lastSysMode = mode;
        this.resetSysModel();
        this.log.info((Object)"SM SysModeSetting refreshState Successfully.");
    }

    public int getTitleDescription() {
        this.log.info((Object)"SM SysModeSetting getTitleDescription Successfully.");
        return 3;
    }
}

