/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base.systemmode;

import com.swimap.external.dsf.base.framework.AppError;
import com.swimap.iview.util.SyncCommand;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.sm.client.base.SecurityBaseModule;
import com.swimap.sm.client.base.SessionService;
import com.swimap.sm.client.base.StatusBarSettingProxy;
import com.swimap.sm.client.base.auth.ResCenter;
import com.swimap.sm.client.base.common.GuiUtilForBase;
import com.swimap.sm.client.base.common.RpcInvoker;
import com.swimap.sm.client.base.systemmode.CountDownDlg;
import com.swimap.sm.client.base.systemmode.InputWaitTimeDlg;
import com.swimap.sm.client.loginui.common.SMTraceProxy;

public class SysModeManager {
    private IviewLogger log = SMTraceProxy.getLogger(SysModeManager.class);
    public static int MODE_SETTING_SUCCESS = 0;
    public static int MODE_SETTING_FAILED = 1;
    public static int MODE_SETTING_CANCLE = 2;
    private int settingModeStatus = MODE_SETTING_SUCCESS;
    private RpcInvoker rpcInvoke = null;
    private StatusBarSettingProxy statusBarSetting;
    private ResCenter res;

    public SysModeManager(StatusBarSettingProxy statusBarSetting, RpcInvoker rpcInvoker, ResCenter res) {
        this.statusBarSetting = statusBarSetting;
        this.rpcInvoke = rpcInvoker;
        this.res = res;
    }

    public int setSystemMode(int sysModel) {
        this.settingModeStatus = MODE_SETTING_SUCCESS;
        try {
            int waitSeconds = -1;
            int curSysModel = SecurityBaseModule.getSecuityModuleRef().getSessionManager().getSystemMode();
            if (curSysModel == 1 && sysModel == 0) {
                InputWaitTimeDlg dlg = new InputWaitTimeDlg(this.res);
                GuiUtilForBase.displayCentered(dlg);
                if (dlg.isBSetting()) {
                    waitSeconds = dlg.getWaitTime();
                    this.callRpcSetSystemMode(sysModel, waitSeconds);
                    if (waitSeconds > 0) {
                        this.startWaitingThread(waitSeconds);
                    } else if (waitSeconds == 0) {
                        this.statusBarSetting.setSystemModelMessageItemTooltip(this.res.getString("maintenencemode"));
                    }
                } else {
                    this.settingModeStatus = MODE_SETTING_CANCLE;
                }
                dlg = null;
            } else if (curSysModel == 0 && sysModel == 1) {
                this.callRpcSetSystemMode(sysModel, waitSeconds);
                this.statusBarSetting.setSystemModelMessageItemTooltip(this.res.getString("runtimemode"));
            }
            this.resetSystemMode();
            return this.settingModeStatus;
        }
        catch (AppError e) {
            if (e.is("SM_CHANGE_MODE_FORBIDDEN")) {
                GuiUtilForBase.showErrorMessageWithInvokeLater(this.res.getString("SM_CHANGE_MODE_FORBIDDEN"));
            } else if (e.is("SM_EXCEED_RIGHT")) {
                GuiUtilForBase.showErrorMessageWithInvokeLater(this.res.getString("errexcrigtxt0"));
            } else if (e.is("SM_INVALID_TIME")) {
                GuiUtilForBase.showErrorMessageWithInvokeLater(this.res.getString("errinvtimtxt0"));
            } else if (e.is("SYSTEM_CONFIG_ERROR")) {
                GuiUtilForBase.showErrorMessageWithInvokeLater(this.res.getString("errsysconferrtxt0"));
            } else if (e.is("SM_USER_LOCKED")) {
                GuiUtilForBase.showErrorMessageWithInvokeLater(this.res.getString("errusrlocktxt0"));
            } else {
                GuiUtilForBase.showErrorMessageWithInvokeLater(this.res.getString("serviceError"));
            }
            this.log.error((Object)"SysModeManager | setSystemMode | set system mode error.", (Throwable)e);
            return MODE_SETTING_FAILED;
        }
        catch (Exception e) {
            if (!GuiUtilForBase.handleException(e)) {
                this.log.error((Object)"SysModeManager | setSystemMode | deal sysMode with error.", (Throwable)e);
            }
            return MODE_SETTING_FAILED;
        }
    }

    private void callRpcSetSystemMode(final int sysMode, final int waitSeconds) throws Exception {
        SyncCommand command = new SyncCommand(){

            public Object call() throws Exception {
                SysModeManager.this.rpcInvoke.setSystemMode(sysMode, waitSeconds);
                return true;
            }
        };
        if (!command.startCall()) {
            Exception e = command.getException();
            throw e;
        }
    }

    private void startWaitingThread(int waitSeconds) {
        CountDownDlg systemModeSettingWaitingDlg = new CountDownDlg(waitSeconds, this);
        GuiUtilForBase.displayCentered(systemModeSettingWaitingDlg);
        if (!systemModeSettingWaitingDlg.isBSettingMode()) {
            this.settingModeStatus = MODE_SETTING_CANCLE;
        }
    }

    public int getSystemMode() {
        return SecurityBaseModule.getSecuityModuleRef().getSessionManager().getSystemMode();
    }

    public void resetSystemMode() {
        SecurityBaseModule.getSecuityModuleRef().getSessionManager().resetCurrentSysModel();
    }

    public String getServerIP() {
        return SessionService.getInstance().getCurServerIP();
    }

    public boolean checkRight() {
        return SessionService.getInstance().isAdminUser();
    }
}

