/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base.systemmode;

import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.sm.client.base.SecurityBaseModule;
import com.swimap.sm.client.base.auth.ResCenter;
import com.swimap.sm.client.base.common.BaseConstants;
import com.swimap.sm.client.base.common.GuiUtilForBase;
import com.swimap.sm.client.base.common.RpcInvoker;
import com.swimap.sm.client.base.systemmode.SysModeManager;
import com.swimap.sm.client.loginui.common.SMTraceProxy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class CountDownDlg
extends JDialog {
    private static final long serialVersionUID = 1L;
    private IviewLogger log = SMTraceProxy.getLogger(CountDownDlg.class);
    private JPanel btnPanel = new JPanel();
    private JButton cancelBtn = new JButton();
    private JPanel hintPanel = new JPanel();
    private JTextArea hintText1 = new JTextArea();
    private int waitSeconds;
    private boolean run = true;
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private FlowLayout flowLayout1 = new FlowLayout();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private JTextArea hintText2 = new JTextArea();
    private boolean bSettingMode = true;
    private static final int ONE_SECOND = 1000;
    private SysModeManager sysModeManager;

    public CountDownDlg(int waitSeconds, SysModeManager sysModeManager) {
        super(FrameworkUtilities.getMainFrame(), ResCenter.RES.getString("Warning"), true);
        this.waitSeconds = waitSeconds;
        this.sysModeManager = sysModeManager;
        try {
            this.jbInit();
            this.startRefreshWaitSecondsThread();
            GuiUtilForBase.isSetSingleUserModeDelayed = true;
        }
        catch (Exception e) {
            this.log.error((Object)"CountDownDlg | init dialog with error.", (Throwable)e);
        }
    }

    private void jbInit() throws Exception {
        JPanel upPanel = new JPanel();
        upPanel.setName("JPanel_upPanel");
        this.btnPanel.setName("JPanel_btnPanel");
        this.cancelBtn.setName("JButton_cancelBtn");
        this.hintPanel.setName("JPanel_hintPanel");
        this.hintText1.setName("JTextArea_hintText1");
        this.hintText2.setName("JTextArea_hintText2");
        this.hintText1.setLineWrap(true);
        this.hintText1.setWrapStyleWord(true);
        this.hintText1.setEditable(false);
        this.hintText2.setLineWrap(true);
        this.hintText2.setWrapStyleWord(true);
        this.hintText2.setEditable(false);
        this.hintText1.setFocusable(false);
        this.hintText2.setFocusable(false);
        this.btnPanel.setLayout(this.flowLayout1);
        this.getContentPane().setLayout(this.gridBagLayout1);
        this.cancelBtn.setSelected(true);
        this.cancelBtn.setText(ResCenter.RES.getString("CancelButton"));
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CountDownDlg.this.cancelBtn_actionPerformed();
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                CountDownDlg.this.cancelBtn_actionPerformed();
            }
        });
        this.hintPanel.setLayout(this.gridBagLayout2);
        this.getContentPane().add((Component)this.btnPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.1, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.btnPanel.add((Component)this.cancelBtn, null);
        this.getContentPane().add((Component)upPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        Icon icon = null;
        try {
            icon = (Icon)UIManager.get("OptionPane.warningIcon");
        }
        catch (Exception e) {
            this.log.error((Object)"CountDownDlg | get warning Icon with error.", (Throwable)e);
        }
        JPanel iconPanel = new JPanel();
        iconPanel.setLayout(new BorderLayout());
        JLabel iconLabel = new JLabel(icon);
        Font font = iconLabel.getFont();
        this.hintText1.setFont(font);
        this.hintText2.setFont(font);
        this.hintText1.setBackground(iconPanel.getBackground());
        this.hintText2.setBackground(iconPanel.getBackground());
        iconPanel.add((Component)iconLabel, "North");
        upPanel.setLayout(new GridBagLayout());
        upPanel.add((Component)iconPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 15, 20, 15), 0, 0));
        upPanel.add((Component)this.hintPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(5, 0, 10, 10), 0, 0));
        this.hintPanel.add((Component)this.hintText1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.hintPanel.add((Component)this.hintText2, new GridBagConstraints(0, 1, 1, 1, 0.5, 0.5, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.hintText1.setText(this.getShowWaitSecondsInfo(this.waitSeconds));
        this.hintText2.setText(ResCenter.RES.getString("System_Mode_Change4"));
        this.cancelBtn.setPreferredSize(BaseConstants.Component.ComponentSize.BUTTON_SIZE);
        ScreenToolKit.setDefaultButtons((AbstractButton)this.cancelBtn, (AbstractButton)this.cancelBtn);
        this.setResizable(false);
        this.setSize(new Dimension(410, 150));
    }

    private String getShowWaitSecondsInfo(int seconds) {
        String waitMessage = GuiUtilForBase.bundleString(ResCenter.RES.getString("System_Mode_Change2"), Integer.toString(seconds));
        return waitMessage;
    }

    private void startRefreshWaitSecondsThread() {
        RefreshWaitSecondsThread thread = new RefreshWaitSecondsThread(this.waitSeconds);
        thread.start();
    }

    private void cancelBtn_actionPerformed() {
        block2: {
            this.bSettingMode = false;
            this.run = false;
            try {
                RpcInvoker.getInstance().cancelSystemMode();
            }
            catch (Exception ex) {
                if (GuiUtilForBase.handleException(ex)) break block2;
                this.log.error((Object)"CountDownDlg | cancelBtn_actionPerformed | cancelSystemMode with error.", (Throwable)ex);
            }
        }
        this.dispose();
    }

    public boolean isBSettingMode() {
        return this.bSettingMode;
    }

    private class RefreshWaitSecondsThread
    extends Thread {
        int temp;

        RefreshWaitSecondsThread(int temp) {
            this.temp = temp;
        }

        @Override
        public void run() {
            try {
                while (CountDownDlg.this.run) {
                    if (GuiUtilForBase.bUserKickouted) {
                        CountDownDlg.this.run = false;
                        break;
                    }
                    if (this.temp <= 0) {
                        CountDownDlg.this.sysModeManager.resetSystemMode();
                        Thread.sleep(1000L);
                        if (CountDownDlg.this.sysModeManager.getSystemMode() == 0) {
                            this.setSystemModeStatusBar();
                            GuiUtilForBase.isSetSingleUserModeDelayed = false;
                        }
                        CountDownDlg.this.dispose();
                        break;
                    }
                    Thread.sleep(1000L);
                    --this.temp;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CountDownDlg.this.hintText1.setText(CountDownDlg.this.getShowWaitSecondsInfo(RefreshWaitSecondsThread.this.temp));
                        }
                    });
                }
            }
            catch (InterruptedException ex) {
                CountDownDlg.this.log.error((Object)"CountDownDlg | refresh thread run with error.", (Throwable)ex);
            }
        }

        private void setSystemModeStatusBar() {
            try {
                SecurityBaseModule.getSecuityModuleRef().getStatusBarSettingProxy().setSystemModelMessageItemTooltip(ResCenter.RES.getString("maintenencemode"));
            }
            catch (Exception e) {
                CountDownDlg.this.log.debug((Object)"CountDownDlg | setSystemModeStatusBar | setStatusBar with error.", (Throwable)e);
            }
        }
    }
}

