/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base.switchlogin;

import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.sm.client.base.SessionService;
import com.swimap.sm.client.base.auth.ResCenter;
import com.swimap.sm.client.base.common.OptionPaneProxy4SmBase;
import com.swimap.sm.client.loginui.bglogin.LoginInfo;
import com.swimap.sm.client.loginui.common.GuiUtilForLoginui;
import com.swimap.sm.client.loginui.common.LogoutProxy;
import com.swimap.sm.client.loginui.common.SMTraceProxy;
import com.swimap.sm.client.loginui.common.model.SMPasswordFieldEx;
import com.swimap.sm.client.loginui.config.LoginUIConfig;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SwitchUserLoginDlg
extends JDialog {
    private static final long serialVersionUID = 1511420623485630001L;
    private IviewLogger log = SMTraceProxy.getLogger(SwitchUserLoginDlg.class);
    private JTextField userNameField = new JTextField();
    private SMPasswordFieldEx imtInfoField = new SMPasswordFieldEx();
    private JLabel userNameLabel = new JLabel(ResCenter.RES.getString("usernamelabel"));
    private JLabel passwordLabel = new JLabel(ResCenter.RES.getString("passwordlabel"));
    private JButton cancelButton = new JButton();
    private JButton okButton = new JButton();
    private LoginInfo loginInfo;
    private boolean isOkClick = false;

    public SwitchUserLoginDlg(LoginInfo _LoginInfo, JDialog parent) {
        super(parent, ResCenter.RES.getString("SWITCH_LOGIN_SERVER_TITLE"), true);
        try {
            this.loginInfo = _LoginInfo;
            this.setSize(350, 150);
            this.setResizable(false);
            this.setDefaultCloseOperation(2);
            this.jbInit();
            this.initButtonListener();
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
        }
        this.setLoginUserNameToNameField();
        this.addFrameListener();
    }

    private void addFrameListener() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowevent) {
                SwitchUserLoginDlg.this.imtInfoField.requestFocus();
            }
        });
    }

    private void setLoginUserNameToNameField() {
        this.userNameField.setText(SessionService.getInstance().getCurUserName());
        this.imtInfoField.setCaretPosition(0);
    }

    private void jbInit() throws Exception {
        Container contentPane = this.getContentPane();
        contentPane.setBounds(0, 0, 0, 0);
        contentPane.setLayout(new GridBagLayout());
        contentPane.add(this.getInputPanel(), new GridBagConstraints(0, 0, 1, 1, 2.0, 2.0, 11, 1, new Insets(10, 20, 0, 20), 0, 0));
        contentPane.add((Component)this.getButtonPanel(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 15, 1, new Insets(10, 20, 10, 20), 0, 0));
    }

    private Component getInputPanel() {
        JPanel inputPanel = new JPanel(new GridBagLayout());
        this.userNameField.setPreferredSize(new Dimension(130, 20));
        this.userNameField.setMaximumSize(new Dimension(130, 20));
        this.imtInfoField.setPreferredSize(new Dimension(130, 20));
        this.imtInfoField.setMaximumSize(new Dimension(130, 20));
        GuiUtilForLoginui.initValidNameTextField((JTextField)this.userNameField, (int)32, (boolean)this.bLoginUserCharVerified());
        GuiUtilForLoginui.initValidTextField((JTextField)this.imtInfoField, (int)100, (String)"");
        inputPanel.add((Component)this.userNameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 1, new Insets(0, 0, 5, 0), 0, 0));
        inputPanel.add((Component)this.userNameField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 11, 1, new Insets(0, 20, 5, 0), 0, 0));
        inputPanel.add((Component)this.passwordLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        inputPanel.add((Component)this.imtInfoField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 11, 1, new Insets(0, 20, 0, 0), 0, 0));
        return inputPanel;
    }

    private JPanel getButtonPanel() {
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        Dimension size = new Dimension(80, 21);
        this.okButton.setPreferredSize(size);
        this.cancelButton.setPreferredSize(size);
        this.okButton.setText(ResCenter.RES.getString("OK"));
        this.cancelButton.setText(ResCenter.RES.getString("Cancel"));
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        ScreenToolKit.setDefaultButtons((AbstractButton)this.okButton, (AbstractButton)this.cancelButton);
        return buttonPanel;
    }

    public void initButtonListener() {
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwitchUserLoginDlg.this.btn_ConfirmBtnPerformed();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwitchUserLoginDlg.this.clearPwdText();
                SwitchUserLoginDlg.this.dispose();
            }
        });
    }

    protected void btn_ConfirmBtnPerformed() {
        this.isOkClick = true;
        String userName = this.userNameField.getText();
        if (userName == null || "".equals(userName.trim())) {
            OptionPaneProxy4SmBase.showInformationDlg(this, ResCenter.getInstance().getString("PLEASEINPUTUSERNAME"));
            return;
        }
        char[] imtInfo = this.imtInfoField.getPassword();
        if (imtInfo == null) {
            imtInfo = new char[]{};
        }
        this.loginInfo.userName = userName.trim();
        this.loginInfo.imtInfo = imtInfo;
        GuiUtilForLoginui.bSwitchLogin = true;
        GuiUtilForLoginui.setLoginInfo((LoginInfo)this.loginInfo);
        this.clearPwdText();
        LogoutProxy.getInstance().logoutImmediately();
    }

    private void clearPwdText() {
        this.imtInfoField.setText("");
    }

    public boolean isConfirm() {
        return this.isOkClick;
    }

    private boolean bLoginUserCharVerified() {
        return LoginUIConfig.getInstance().bLoginUserCharVerified();
    }
}

