/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base.switchlogin;

import com.swimap.external.sm.client.base.SessionService;
import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.framework.pluginmanagement.Plugin;
import com.swimap.iview.framework.pluginmanagement.PluginManager;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.templates.extendedtable.ExtendedTable;
import com.swimap.iview.templates.extendedtable.SortableTableModel;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.helpmanagement.HelpManager;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.sm.client.base.auth.ResCenter;
import com.swimap.sm.client.base.common.GuiUtilForBase;
import com.swimap.sm.client.base.switchlogin.SwitchUserLoginDlg;
import com.swimap.sm.client.loginui.bglogin.LoginInfo;
import com.swimap.sm.client.loginui.common.SMTraceProxy;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class SwitchLoginServerDlg
extends JDialog {
    private static final long serialVersionUID = -3228445119849215949L;
    private IviewLogger log = SMTraceProxy.getLogger(SwitchLoginServerDlg.class);
    private ExtendedTable serverTable;
    private SortableTableModel model;
    private Vector<Vector<String>> tableDataVct = new Vector();
    private JButton cancelButton = new JButton();
    private JButton okButton = new JButton();

    public SwitchLoginServerDlg() {
        super(FrameworkUtilities.getMainFrame(), ResCenter.RES.getString("SWITCH_LOGIN_SERVER_TITLE"), true);
        try {
            this.initData();
            this.jbInit();
            this.setSize(500, 280);
            this.setResizable(false);
            this.setDefaultCloseOperation(2);
            this.initButtonListener();
            HelpManager.getInstance().enableHelpKey((Component)this.getRootPane(), "iVIEW.Security.SwitchServer");
        }
        catch (Exception e) {
            this.log.error((Object)e);
        }
    }

    private void initData() {
        Plugin plugin = PluginManager.getInstance().getPlugin("loginui");
        CommStyleInfo info = plugin.getCommStyleParser().getCommStyleInfo("loginui/loginserverinfo");
        try {
            AreaDescContainer areaDescContainer = info.getAreaDescContainer("ServerInfo");
            if (!this.tableDataVct.isEmpty()) {
                this.tableDataVct.clear();
            }
            String curTerminalIP = SessionService.getInstance().getCurServerIP();
            int descCount = 0;
            if (null != areaDescContainer) {
                descCount = areaDescContainer.getDescCount();
            }
            DescContainer descContainer = null;
            String descName = null;
            Vector<String> rowData = null;
            for (int i = 0; i < descCount; ++i) {
                String[] serverIPs;
                descContainer = areaDescContainer.getDescContainer(i);
                descName = descContainer.getDescName();
                rowData = new Vector<String>();
                String serverName = info.getParasItemValue("ServerInfo", descName, "serverName");
                if (null == serverName || curTerminalIP.equals((serverIPs = serverName.split("/"))[0]) || serverIPs.length == 2 && curTerminalIP.equals(serverIPs[1])) continue;
                rowData.add(info.getParasItemValue("ServerInfo", descName, "customServerName"));
                rowData.add(serverName);
                rowData.add(info.getParasItemValue("ServerInfo", descName, "portData"));
                rowData.add(ResCenter.getInstance().getString(info.getParasItemValue("ServerInfo", descName, "securityMode")));
                this.tableDataVct.add(rowData);
            }
        }
        catch (Exception ex) {
            this.log.error((Object)"LoginPaneXMLParser | loadServerInfoVect | read loginserverinfo.xml with error.", (Throwable)ex);
        }
    }

    private void jbInit() throws Exception {
        Container contentPane = this.getContentPane();
        contentPane.setBounds(0, 0, 0, 0);
        contentPane.setLayout(new GridBagLayout());
        contentPane.add((Component)this.getServerInfoPanel(), new GridBagConstraints(0, 0, 1, 1, 2.0, 2.0, 11, 1, new Insets(12, 12, 6, 12), 0, 0));
        contentPane.add((Component)this.getButtonPanel(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 15, 1, new Insets(0, 12, 0, 12), 0, 0));
    }

    private JScrollPane getServerInfoPanel() {
        JScrollPane tableScrollPane = new JScrollPane();
        tableScrollPane.getViewport().add(this.getServerInfoTable());
        return tableScrollPane;
    }

    private JPanel getButtonPanel() {
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        Dimension size = new Dimension(80, 21);
        this.okButton.setPreferredSize(size);
        this.cancelButton.setPreferredSize(size);
        this.okButton.setText(ResCenter.RES.getString("OK"));
        this.cancelButton.setText(ResCenter.RES.getString("Cancel"));
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        ScreenToolKit.setDefaultButtons((AbstractButton)this.okButton, (AbstractButton)this.cancelButton);
        return buttonPanel;
    }

    public void initButtonListener() {
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwitchLoginServerDlg.this.okButton_actionPerformed();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SwitchLoginServerDlg.this.dispose();
            }
        });
    }

    public JTable getServerInfoTable() {
        Vector<String> columnName = new Vector<String>(4);
        columnName.add(ResCenter.RES.getString("Name"));
        columnName.add(ResCenter.RES.getString("ServerName"));
        columnName.add(ResCenter.RES.getString("ServerPort"));
        columnName.add(ResCenter.RES.getString("servermode"));
        this.model = new SortableTableModel();
        this.model.setDataVector(this.tableDataVct, columnName);
        this.serverTable = new ExtendedTable(this.model);
        this.serverTable.setUneditableForeground(Color.BLACK);
        this.serverTable.setEditableForeground(Color.BLACK);
        this.serverTable.setInvalidedForeground(Color.BLACK);
        this.serverTable.setForeground(Color.BLACK);
        this.serverTable.setSortableClickCount(1);
        TableColumn portColumn = this.serverTable.getColumn((Object)ResCenter.getInstance().getString("ServerPort"));
        portColumn.setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                this.setHorizontalAlignment(4);
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
        });
        for (int i = 0; i < this.serverTable.getColumnCount(); ++i) {
            this.serverTable.setColumnSortable(i, true);
        }
        this.serverTable.setName("SM_ServerInfoDlg_ServerInfoTable");
        this.serverTable.setSelectionMode(0);
        this.serverTable.getTableHeader().setReorderingAllowed(true);
        this.serverTable.getSelectionModel().setSelectionInterval(0, 0);
        this.serverTable.setRowHeight(21);
        return this.serverTable;
    }

    private void okButton_actionPerformed() {
        if (this.hasSelectedServerInfo()) {
            SwitchUserLoginDlg dlg = new SwitchUserLoginDlg(this.getLoginInfo(), this);
            ScreenToolKit.centerLocateToScreen((Component)dlg);
            dlg.setVisible(true);
        }
    }

    public LoginInfo getLoginInfo() {
        int selectionRow = this.serverTable.getSelectedRow();
        int[] indexes = this.model.getIndexes();
        Vector<String> rowData = this.tableDataVct.get(indexes[selectionRow]);
        SessionService sessionService = SessionService.getInstance();
        LoginInfo loginInfo = new LoginInfo();
        loginInfo.userName = sessionService.getCurUserName();
        loginInfo.imtInfo = null;
        loginInfo.customServerName = rowData.get(0);
        loginInfo.serverIP = rowData.get(1);
        loginInfo.port = Integer.parseInt(rowData.get(2));
        loginInfo.securityModel = this.getSecurityModeKey(rowData.get(3));
        return loginInfo;
    }

    private String getSecurityModeKey(String modeName) {
        if (ResCenter.RES.getString("commonservermode").equals(modeName)) {
            return "commonservermode";
        }
        return "sslservermode";
    }

    private boolean hasSelectedServerInfo() {
        int selectionRow = this.serverTable.getSelectedRow();
        if (selectionRow < 0) {
            GuiUtilForBase.showErrorInfo(ResCenter.getInstance().getString("NO_SELECT_SERVER_ITEM"));
            return false;
        }
        return true;
    }
}

