/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base.sessionact;

import com.swimap.iview.framework.outputmanagement.OutputManager;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.sm.client.base.auth.ResCenter;
import com.swimap.sm.client.base.auth.SessionManager;
import com.swimap.sm.client.base.common.GuiUtilForBase;
import com.swimap.sm.client.base.common.RpcInvoker;
import com.swimap.sm.client.base.crypt.RSAEncrypt;
import com.swimap.sm.client.base.sessionact.ActivateSessionHandler;
import com.swimap.sm.client.base.sessionact.ActivateSessionRpc;
import com.swimap.sm.client.loginui.auth.LogoutDlg;
import com.swimap.sm.client.loginui.auth.ServerInfo;
import com.swimap.sm.client.loginui.bglogin.LoginInfo;
import com.swimap.sm.client.loginui.common.GuiUtilForLoginui;
import com.swimap.sm.client.loginui.common.LoginUIConstants;
import com.swimap.sm.client.loginui.config.LoginUIConfig;
import javax.swing.SwingUtilities;

public class DoubleHostSwitchHandler
extends ActivateSessionHandler {
    private static final IviewLogger log = IviewLogger.getLogger(DoubleHostSwitchHandler.class);
    private SessionManager sessionManager;
    private FrameworkCommandProcessor frameworkCommandProcessor = null;
    private OutputManager outputManager = null;
    private RpcInvoker rpcInvoker = null;
    private LoginUIConfig loginUIConfig = null;
    private LoginInfo loginInfo = new LoginInfo();
    private boolean isSwitching = false;
    private String secondIP = null;
    public static DoubleHostSwitchHandler instance = null;

    public DoubleHostSwitchHandler(SessionManager sessionManager, FrameworkCommandProcessor frameworkCommandProcessor, OutputManager outputManager, RpcInvoker rpcInvoker, LoginUIConfig loginUIConfig, ActivateSessionRpc activateSessionRpc) {
        super(activateSessionRpc, null);
        this.sessionManager = sessionManager;
        this.frameworkCommandProcessor = frameworkCommandProcessor;
        this.outputManager = outputManager;
        this.rpcInvoker = rpcInvoker;
        this.loginUIConfig = loginUIConfig;
    }

    private void setLoginParameters(String curUserName, String serverName, String doubleSeverIP, int port, String securityModel, String curConnectServerIP) {
        log.info((Object)("curUserName:" + curUserName + " serverName:" + serverName + " doubleSeverIP:" + doubleSeverIP + " port:" + port + " securityModel:" + securityModel + " curConnectServerIP:" + curConnectServerIP));
        this.loginInfo.userName = curUserName;
        this.loginInfo.customServerName = serverName;
        this.loginInfo.serverIP = doubleSeverIP;
        this.loginInfo.port = port;
        this.loginInfo.securityModel = securityModel;
        if (null == curConnectServerIP) {
            return;
        }
        String[] ipArray = ServerInfo.getIPArray((String)this.loginInfo.serverIP);
        if (ipArray.length == 2) {
            this.secondIP = curConnectServerIP.equals(ipArray[0]) ? ipArray[1] : ipArray[0];
        }
        log.info((Object)("secondIP:" + this.secondIP));
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public boolean connectSecondHostForTimeout() {
        String port = Integer.toString(this.loginInfo.port);
        if (this.frameworkCommandProcessor.isLogin() && this.loginUIConfig.isMSupportSecondaryServer() && this.secondIP != null) {
            int repeat = 3;
            do {
                try {
                    String namingAddress = this.rpcInvoker.initConnectionParam(this.secondIP, port, this.loginInfo.securityModel.equals("sslservermode"));
                    if (namingAddress != null && RSAEncrypt.getInstance().initRSAPublickey()) {
                        this.sessionManager.setServerName(this.loginInfo.customServerName);
                        this.sessionManager.setServerIP(this.secondIP);
                        this.sessionManager.setShowServerIP(this.secondIP);
                        this.sessionManager.setServerPort(port);
                        String succeededMsg = GuiUtilForBase.bundleString(ResCenter.getInstance().getString("Login_Comm_Connect_Succeeded"), this.secondIP);
                        this.addMessage(succeededMsg);
                        return true;
                    }
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException e) {
                        log.error((Object)"", (Throwable)e);
                    }
                }
                catch (Exception e) {
                    log.error((Object)"", (Throwable)e);
                }
            } while (--repeat > 0);
            String failedMsg = GuiUtilForBase.bundleString(ResCenter.getInstance().getString("Login_Comm_Connect_Failed"), this.secondIP);
            this.addMessage(failedMsg);
            LogoutDlg.show((String)"Reach_Reconnect_Wait_Time");
        }
        return false;
    }

    public boolean connectSecondHostForLogin() {
        String port = Integer.toString(this.loginInfo.port);
        if (this.loginUIConfig.isMSupportSecondaryServer() && this.secondIP != null) {
            try {
                String namingAddress = this.rpcInvoker.initConnectionParam(this.secondIP, port, this.loginInfo.securityModel.equals("sslservermode"));
                if (namingAddress != null) {
                    this.sessionManager.setServerName(this.loginInfo.customServerName);
                    this.sessionManager.setServerIP(this.secondIP);
                    this.sessionManager.setShowServerIP(this.secondIP);
                    this.sessionManager.setServerPort(port);
                    String succeededMsg = GuiUtilForBase.bundleString(ResCenter.getInstance().getString("Login_Comm_Connect_Succeeded"), this.secondIP);
                    this.addMessage(succeededMsg);
                    return true;
                }
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
                String failedMsg = GuiUtilForBase.bundleString(ResCenter.getInstance().getString("Login_Comm_Connect_Failed"), this.secondIP);
                this.addMessage(failedMsg);
            }
        }
        return false;
    }

    private void addMessage(final String msg) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    DoubleHostSwitchHandler.this.outputManager.addMessage(msg);
                }
                catch (Exception e) {
                    log.error((Object)"catch exception:", (Throwable)e);
                }
            }
        });
    }

    public boolean startSwitchHost() {
        if (super.activateSession()) {
            this.isSwitching = true;
            this.loginInfo.userName = null;
            this.loginInfo.imtInfo = null;
            this.loginInfo.authMode = this.sessionManager.getLoginAuthMode();
            this.loginInfo.authUserType = null != this.sessionManager.getCurrentSessionByLocal() ? this.sessionManager.getCurrentSessionByLocal().getUserAuthType() : (LoginUIConstants.LoginAuthMode.REMOTE_AUTH.ordinal() == this.loginInfo.authMode || LoginUIConstants.LoginAuthMode.REMOTE_LOCAL.ordinal() == this.loginInfo.authMode || LoginUIConstants.LoginAuthMode.SWITCH_REMOTE_AUTH.ordinal() == this.loginInfo.authMode ? 1 : 0);
            GuiUtilForLoginui.bSwitchLogin = true;
            GuiUtilForLoginui.setLoginInfo((LoginInfo)this.loginInfo);
            String succeededMsg = GuiUtilForBase.bundleString(ResCenter.getInstance().getString("Login_Comm_Connect_Succeeded"), this.secondIP);
            this.addMessage(succeededMsg);
            GuiUtilForBase.setToBeingExit();
            this.frameworkCommandProcessor.logoutDirectly();
            return true;
        }
        return false;
    }

    public boolean isSwitching() {
        return this.isSwitching;
    }

    public void setSwitchFinish() {
        this.isSwitching = false;
    }

    public byte[] getToken() {
        return this.activateSessionRpc.getToken();
    }

    public static DoubleHostSwitchHandler getResumeTimeoutHandler() {
        return instance;
    }

    public static DoubleHostSwitchHandler createDoudleHostSwitchHandler(SessionManager sessionManager, String serverName, String doubleSeverIP, String userName, int port, String securityModel) {
        instance = new DoubleHostSwitchHandler(sessionManager, FrameworkCommandProcessor.getInstance(), FrameworkUtilities.getOutputManager(), RpcInvoker.getInstance(), LoginUIConfig.getInstance(), new ActivateSessionRpc(sessionManager.getSecurityToken()));
        instance.setLoginParameters(userName, serverName, doubleSeverIP, port, securityModel, sessionManager.getServerIP());
        return instance;
    }

    public boolean isSingleHost() {
        return !this.frameworkCommandProcessor.isLogin() || !this.loginUIConfig.isMSupportSecondaryServer() || this.secondIP == null;
    }
}

