/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base.sessionact;

import com.swimap.external.dsf.base.framework.AppError;
import com.swimap.external.dsf.base.rpc.RpcErrorSecurity;
import com.swimap.external.dsf.base.rpc.RpcRequest;
import com.swimap.external.dsf.base.rpc.RpcResponse;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.sm.client.loginui.common.proxy.rpc.RpcNamingProxy;
import com.swimap.sm.client.loginui.common.proxy.rpc.RpcRequestProxy;

public class ActivateSessionRpc {
    private static final IviewLogger log = IviewLogger.getLogger(ActivateSessionRpc.class);
    public byte[] token = null;

    public ActivateSessionRpc(byte[] token) {
        RpcRequest.setCurrentSession((byte[])token);
        this.token = token;
    }

    public boolean invoke() throws Exception {
        try {
            long t = System.currentTimeMillis();
            log.info((Object)"begin");
            RpcRequestProxy req = RpcNamingProxy.getInstance().createRequest("sm.ds.base.sessionmgr.activateSession");
            RpcResponse rsp = req.invoke();
            log.info((Object)("end, cost:" + (System.currentTimeMillis() - t)));
            return rsp.getMessage().getBoolean("bActivate");
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
            if (e instanceof RpcErrorSecurity) {
                String exceptionInfo = e.getMessage();
                log.info((Object)("exception info:" + exceptionInfo));
                if (exceptionInfo.indexOf("9") == 0) {
                    log.info((Object)"invalid token, return false");
                    return false;
                }
            } else if (e instanceof AppError) {
                AppError appError = (AppError)((Object)e);
                String errorCode = appError.getDetail("errorCode");
                String InvalidTokenType2 = appError.getDetail("InvalidTokenType");
                log.info((Object)("errorCode:" + errorCode + " InvalidTokenType:" + InvalidTokenType2));
                if ("9".equals(errorCode)) {
                    log.info((Object)"invalid token, return false");
                    return false;
                }
            }
            throw e;
        }
    }

    public byte[] getToken() {
        return this.token;
    }
}

