/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base.sessionact;

import com.swimap.base.rpc.nio.SocketClient;
import com.swimap.external.dsf.base.rpc.RpcEvent;
import com.swimap.external.dsf.base.rpc.RpcRequest;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.sm.client.base.common.GuiUtilForBase;
import com.swimap.sm.client.base.crypt.RSAEncrypt;
import com.swimap.sm.client.base.event.EventRegisterFactory;
import com.swimap.sm.client.base.event.IEventHandler;
import com.swimap.sm.client.base.sessionact.ActivateSessionRpc;
import com.swimap.sm.client.loginui.auth.LogoutDlg;

public class ActivateSessionHandler
implements SocketClient.IResumeAction,
IEventHandler {
    private static final IviewLogger log = IviewLogger.getLogger(ActivateSessionHandler.class);
    public static final int REPEAT_TIME = 15;
    private static final int WAITSOMETIME = 10000;
    private boolean bStopResume = false;
    protected ActivateSessionRpc activateSessionRpc = null;
    private int waitTime = 10000;
    private RSAEncrypt rsaEncrypt = null;
    private static ActivateSessionHandler instance = null;

    public ActivateSessionHandler(ActivateSessionRpc activateSessionRpc, RSAEncrypt rsaEncrypt) {
        this.activateSessionRpc = activateSessionRpc;
        this.rsaEncrypt = rsaEncrypt;
    }

    public void setStopResume() {
        this.bStopResume = true;
    }

    public boolean activateSession() {
        log.info((Object)"begin");
        long t = System.currentTimeMillis();
        this.bStopResume = false;
        GuiUtilForBase.isbExit();
        boolean bInvoked = false;
        int repeatInvoke = 15;
        while (true) {
            if (this.bStopResume) {
                log.info((Object)("stop resume.cost:" + (System.currentTimeMillis() - t) + " repeatInvoke:" + (15 - repeatInvoke)));
                return false;
            }
            try {
                boolean ret = this.activateSessionRpc.invoke();
                log.info((Object)("result:" + ret + " cost:" + (System.currentTimeMillis() - t) + " repeatInvoke:" + (15 - repeatInvoke)));
                if (!ret) {
                    LogoutDlg.show((String)"Connection_Invalid");
                }
                if (ret && null != this.rsaEncrypt) {
                    this.rsaEncrypt.initRSAPublickey();
                }
                return ret;
            }
            catch (Exception e1) {
                log.error((Object)"", (Throwable)e1);
                if (this.bStopResume) {
                    log.info((Object)("stop resume.cost:" + (System.currentTimeMillis() - t) + " repeatInvoke:" + (15 - repeatInvoke)));
                    return false;
                }
                --repeatInvoke;
                try {
                    Thread.sleep(this.waitTime);
                    continue;
                }
                catch (InterruptedException e) {
                    log.error((Object)"", (Throwable)e);
                }
                if (!bInvoked && repeatInvoke > 0) continue;
                log.info((Object)("end.cost:" + (System.currentTimeMillis() - t) + " repeatInvoke:" + (15 - repeatInvoke)));
                LogoutDlg.show((String)"Connection_Invalid");
                return false;
            }
            break;
        }
    }

    public void setWaitTime(int waitTime) {
        this.waitTime = waitTime;
    }

    public boolean activateSessionOnce() {
        log.info((Object)"handle security restart, and active session begin.");
        boolean isActivate = false;
        try {
            isActivate = this.activateSessionRpc.invoke();
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
        log.info((Object)("handle security restart, and active session end.active " + (isActivate ? "successful" : "failure")));
        return isActivate;
    }

    public static ActivateSessionHandler getActivateSessionHandler() {
        return instance;
    }

    public static ActivateSessionHandler createAndRegisterActivateSessionHandler(byte[] token) {
        instance = new ActivateSessionHandler(new ActivateSessionRpc(token), RSAEncrypt.getInstance());
        RpcRequest.getSocketClient().setResumeAction((SocketClient.IResumeAction)instance);
        EventRegisterFactory.create().register("99:1", instance);
        return instance;
    }

    @Override
    public boolean handle(RpcEvent event) {
        this.setStopResume();
        if (!this.activateSessionOnce()) {
            LogoutDlg.show((String)"Connection_Invalid");
        }
        return false;
    }
}

