/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base.product.factory;

import com.swimap.external.cbb.baseutil.AESCipher;
import com.swimap.external.sm.client.base.product.interfaces.ISetLoginInfo;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.sm.client.loginui.common.SMTraceProxy;
import com.swimap.sm.client.loginui.common.SecurityRedLineUtil;
import java.security.Key;

public class SetLoginInfoToProduct {
    private static final IviewLogger log = SMTraceProxy.getLogger(SetLoginInfoToProduct.class);
    private boolean hasChangedImtInfo = false;
    private ISetLoginInfo info;
    private static SetLoginInfoToProduct instance = new SetLoginInfoToProduct();

    private SetLoginInfoToProduct() {
    }

    public static SetLoginInfoToProduct getInstance() {
        return instance;
    }

    private ISetLoginInfo get() throws Exception {
        if (null == this.info) {
            this.info = (ISetLoginInfo)Class.forName("com.swimap.omc.common.logininfo.SetLoginInfo").newInstance();
        }
        return this.info;
    }

    public void initSetStatus() {
        this.hasChangedImtInfo = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String userName, char[] imtInfo, boolean isChangeImtInfo) {
        if (this.hasChangedImtInfo && !isChangeImtInfo) {
            return;
        }
        this.hasChangedImtInfo = isChangeImtInfo;
        char[] tmp = null;
        try {
            ISetLoginInfo setLoginInfo = this.get();
            long t = System.currentTimeMillis();
            log.info((Object)"setLoginInfo begin:");
            tmp = AESCipher.encrypt((char[])imtInfo, (Key)AESCipher.defaultKey());
            setLoginInfo.setLoginInfo(userName, tmp);
            log.info((Object)("setLoginInfo end, cost:" + (System.currentTimeMillis() - t)));
            SecurityRedLineUtil.clearArray((char[])tmp);
        }
        catch (Exception e) {
            log.error((Object)"failure.");
        }
        finally {
            SecurityRedLineUtil.clearArray(tmp);
        }
    }
}

