/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base.policy.service;

import com.swimap.external.dsf.base.framework.AppError;
import com.swimap.external.sm.client.base.IPolicyService;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.sm.client.base.common.GuiUtilForBase;
import com.swimap.sm.client.base.policy.IPolicy;
import com.swimap.sm.client.base.policy.PolicyFactory;
import com.swimap.sm.client.base.policy.service.PolicyRpc;
import com.swimap.sm.client.loginui.common.SMTraceProxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PolicyService
implements IPolicyService {
    private static IviewLogger log = SMTraceProxy.getLogger(PolicyService.class);
    public static final int POLICY_NAME = 0;
    public static final int POLICY_VALUE = 1;
    private static PolicyService instance = new PolicyService();
    private boolean cacheLock;

    public static PolicyService getInstance() {
        return instance;
    }

    public void lockCache() {
        this.cacheLock = true;
    }

    public void unLockCache() {
        this.cacheLock = false;
    }

    private boolean isCacheLock() {
        return this.cacheLock;
    }

    private void updateAllPolicys() {
        try {
            this.updatePolicy(PolicyRpc.getInstance().getPolicy());
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void updatePolicy(List<Object[]> policys) {
        for (Object[] policy : policys) {
            IPolicy p = PolicyFactory.getInstance().getPolicy(policy[0].toString());
            if (null != p) {
                p.setPolicyValue(Integer.valueOf(policy[1].toString()));
                continue;
            }
            log.error((Object)("No find the policy." + Arrays.toString(policy)));
        }
    }

    public boolean setPolicy(List<Object[]> policys) {
        try {
            PolicyRpc.getInstance().setPolicy(policys);
            return true;
        }
        catch (AppError err) {
            log.error((Object)"", (Throwable)err);
            GuiUtilForBase.dealWithAppError(err);
            return false;
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
            this.handleException(e);
            return false;
        }
    }

    private void handleException(Exception e) {
        if (!GuiUtilForBase.handleException(e)) {
            log.error((Object)"", (Throwable)e);
        }
    }

    @Override
    public int getPolicyValue(String policyName) {
        if (!this.isCacheLock()) {
            this.updateAllPolicys();
        }
        return PolicyFactory.getInstance().getPolicy(policyName).getPolicyValue();
    }

    public Map<String, Integer> getPolicyValues(Set<String> set) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        try {
            List<Object[]> policys = PolicyRpc.getInstance().getPolicy();
            for (Object[] policy : policys) {
                if (!set.contains(policy[0].toString())) continue;
                result.put(policy[0].toString(), Integer.valueOf(policy[1].toString()));
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return result;
    }

    public int getPolicyValueForCompare(String policyName) {
        int value = this.getPolicyValue(policyName);
        return value < 0 ? 0 : value;
    }

    public void setPolicyValue(String policyName, int value) {
        PolicyFactory.getInstance().getPolicy(policyName).setPolicyValue(value);
    }

    public static void saveGlobalAutoLockTimeToLocal(int autoLockMins) {
        if (-1 == autoLockMins) {
            FrameworkUtilities.getTerminalManager().setGlobalAutoLock(0, false);
            log.info((Object)"transfer the lock status to iviewglobalIdleTime=0,globalTimeSettingEnable=false");
        } else {
            FrameworkUtilities.getTerminalManager().setGlobalAutoLock(autoLockMins, true);
            log.info((Object)("transfer the lock status to iviewglobalIdleTime=" + autoLockMins + "," + "globalTimeSettingEnable=" + true));
        }
    }
}

