/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base.policy.service;

import com.swimap.external.dsf.base.framework.AppError;
import com.swimap.external.dsf.base.rpc.DataRecord;
import com.swimap.external.dsf.base.rpc.DataTable;
import com.swimap.external.dsf.base.rpc.RpcError;
import com.swimap.external.dsf.base.rpc.RpcErrorSecurity;
import com.swimap.external.dsf.base.rpc.RpcMessage;
import com.swimap.external.dsf.base.rpc.RpcResponse;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.sm.client.base.common.SmAppError;
import com.swimap.sm.client.base.common.SmRpcError;
import com.swimap.sm.client.loginui.common.SMTraceProxy;
import com.swimap.sm.client.loginui.common.proxy.rpc.RpcNamingProxy;
import com.swimap.sm.client.loginui.common.proxy.rpc.RpcRequestProxy;
import java.util.ArrayList;
import java.util.List;

public class PolicyRpc {
    private static IviewLogger log = SMTraceProxy.getLogger(PolicyRpc.class);
    private static PolicyRpc instance = new PolicyRpc();

    public static PolicyRpc getInstance() {
        return instance;
    }

    public List<Object[]> getPolicy() throws Exception {
        RpcRequestProxy req = RpcNamingProxy.getInstance().createRequest("sm.ds.base.sysparammgr.getPolicy");
        RpcResponse rsp = PolicyRpc.invokeRpcRequest(req);
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        DataTable table = rsp.getMessage().getTable("policytable");
        String policyname = "";
        String policyvalue = "";
        for (DataRecord record : table) {
            policyname = record.get("policyname");
            policyvalue = record.get("policyvalue");
            if (policyname.equals("MaxPwdLength")) {
                if (Integer.parseInt(policyvalue) > 16) {
                    list.add(new String[]{policyname, "16"});
                    continue;
                }
                list.add(new String[]{policyname, policyvalue});
                continue;
            }
            list.add(new String[]{policyname, policyvalue});
        }
        return list;
    }

    public static RpcResponse invokeRpcRequest(RpcRequestProxy req) throws Exception {
        try {
            return req.invoke();
        }
        catch (RpcErrorSecurity res) {
            throw res;
        }
        catch (RpcError e) {
            throw new SmRpcError(e);
        }
        catch (AppError e) {
            String errorCode;
            if (e.is("SM_INVALID_TOKEN")) {
                log.info((Object)("DS return invalid token. errorCode= " + e.getDetail("errorCode") + "  InvalidTokenType = " + e.getDetail("InvalidTokenType")));
                throw new RpcErrorSecurity(e.getDetail("errorCode") + ":" + e.getDetail("InvalidTokenType"));
            }
            int internalError = e.getInternalErrorCode();
            if (internalError == 9999 && (errorCode = e.getDetail("errorCode")) != null && errorCode.matches("^-?[1-9]\\d*$")) {
                e.setInternalErrorCode(201392378 + Integer.valueOf(errorCode));
            }
            String errorName = e.getName();
            String internalDes = e.getInternalErrorDesc();
            if (errorName != null && (internalDes == null || "".equals(internalDes))) {
                e.setInternalErrorDesc(errorName);
            }
            throw new SmAppError(e);
        }
        catch (Exception e) {
            throw e;
        }
    }

    public void setPolicy(List<Object[]> policys) throws Exception {
        RpcRequestProxy req = RpcNamingProxy.getInstance().createRequest("sm.ds.base.sysparammgr.setPolicy");
        DataTable table = new DataTable("policytable");
        table.setColumns(new String[]{"policyname", "policyvalue", "policytype"});
        for (Object[] policy : policys) {
            table.add(policy);
        }
        req.addTable(table);
        PolicyRpc.invokeRpcRequest(req);
    }

    public String getPasswordEncrypAlg() throws Exception {
        log.info((Object)"RpcInvoker | getPasswordEncrypAlg |start");
        RpcRequestProxy req = RpcNamingProxy.getInstance().createRequest("sm.ds.sysparammgr.getPasswordEncrypAlg");
        RpcResponse rsp = PolicyRpc.invokeRpcRequest(req);
        RpcMessage msg = rsp.getMessage();
        String encryAlg = msg.getString("PasswordEncrypAlg");
        log.info((Object)("RpcInvoker | getPasswordEncrypAlg |end. The result is: " + encryAlg));
        return encryAlg;
    }
}

