/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base.policy.member;

import com.swimap.sm.client.base.auth.ResCenter;
import com.swimap.sm.client.base.policy.DefaultPolicy;
import com.swimap.sm.client.base.policy.IPolicyCheck;
import com.swimap.sm.client.base.policy.PolicyException;
import com.swimap.sm.client.base.policy.member.PolicyUtil;

public class PwdMinLowerLetterPolicy
extends DefaultPolicy
implements IPolicyCheck {
    private static final int NEW_PWD = 0;
    private static String LOWERCHARACTER = "abcdefghijklmnopqrstuvwxyz";

    public PwdMinLowerLetterPolicy() {
        this("MinLowercaseNum", 1, 1, "");
    }

    public PwdMinLowerLetterPolicy(String name, int value, int type, String desc) {
        super(name, value, type, desc);
    }

    @Override
    public void check(String[] strings) throws PolicyException {
        if (this.value != 0 && strings != null && strings.length > 0) {
            int v = PolicyUtil.getMatchCharCounter(strings[0], LOWERCHARACTER);
            if (this.value == -1) {
                if (v > 0) {
                    throw new PolicyException(ResCenter.getInstance().getString("pwdcannotcontainlowcharacters"));
                }
            } else if (v < this.value) {
                throw new PolicyException(ResCenter.getInstance().getMergeString("PwdLowerCharsCheck", new String[]{this.value + ""}));
            }
        }
    }
}

