/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base.policy;

import com.swimap.external.dsf.base.framework.AppError;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.sm.client.base.auth.ResCenter;
import com.swimap.sm.client.base.auth.SessionManager;
import com.swimap.sm.client.base.common.GuiUtilForBase;
import com.swimap.sm.client.base.common.OptionPaneProxy4SmBase;
import com.swimap.sm.client.base.policy.IDoSomethingWhenShowPwdPolicyErrorInfo;
import com.swimap.sm.client.base.policy.service.PolicyService;
import com.swimap.sm.client.loginui.common.SMTraceProxy;

public class ShowPwdErrorInfo {
    private static IviewLogger log = SMTraceProxy.getLogger(ShowPwdErrorInfo.class);
    private boolean isAdmin = false;
    ResCenter resCenter = ResCenter.getInstance();
    IDoSomethingWhenShowPwdPolicyErrorInfo doSomethingObj = null;

    public void setIsAdmin(boolean value) {
        this.isAdmin = value;
    }

    public boolean getIsAdmin() {
        return this.isAdmin;
    }

    public ShowPwdErrorInfo(IDoSomethingWhenShowPwdPolicyErrorInfo doSomethingObj) {
        this.doSomethingObj = doSomethingObj;
    }

    public boolean show(AppError appError) {
        String policyName = "";
        if (!appError.is("SM_PWD_POLICY_CHECK_ERR")) {
            return false;
        }
        policyName = appError.getDetail("policyname");
        try {
            if (SessionManager.getInstance().isIPassMode()) {
                OptionPaneProxy4SmBase.showInformationDlg(FrameworkUtilities.getMainFrame(), policyName);
                return true;
            }
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
        if (policyName.equals("UsedPassDict")) {
            this.doSomethingObj.doSomethingBeforeShowInfo(policyName);
            this.showPolicyMessage(policyName, "PwdCanNotInDicDesc", "PwdCanNotInDicDesc");
        } else if (policyName.equals("Complex")) {
            this.doSomethingObj.doSomethingBeforeShowInfo(policyName);
            OptionPaneProxy4SmBase.showInformationDlg(FrameworkUtilities.getMainFrame(), ResCenter.RES.getString("PwdCanNotContainsIncOrDecStrDesc"));
        } else if (policyName.equals("EnPwdRevUName")) {
            OptionPaneProxy4SmBase.showInformationDlg(FrameworkUtilities.getMainFrame(), ResCenter.RES.getString("PwdRevUNameDesc"));
        } else if (policyName.equals("MaxPwdLength")) {
            this.showPolicyMessage(policyName, "PwdMaxLengthCheckDesc", "PwdMaxLengthCheckDesc");
        } else if (policyName.equals("MinPwdLength")) {
            this.showPolicyMessage(policyName, "PwdMinLengthCheckDesc", "PwdMinLengthCheckDesc");
        } else if (policyName.equals("MaxPwdValidDays")) {
            OptionPaneProxy4SmBase.showInformationDlg(FrameworkUtilities.getMainFrame(), ResCenter.RES.getString("TimeIntervalLimit_NoModifyPassword"));
        } else if (policyName.equals("MinPwdValidDays")) {
            OptionPaneProxy4SmBase.showInformationDlg(FrameworkUtilities.getMainFrame(), ResCenter.RES.getString("TimeIntervalLimit_NoModifyPassword"));
        } else if (policyName.equals("SuperUserMinPwdLength")) {
            this.showPolicyMessage(policyName, "PwdMinLengthCheckDesc", "PwdMinLengthCheckDesc");
        } else if (policyName.equals("MinAlphabetNum")) {
            this.showPolicyMessage(policyName, "PwdCharsCheckDesc", "pwdcannotcontaincharacters");
        } else if (policyName.equals("MinLowercaseNum")) {
            this.showPolicyMessage(policyName, "PwdLowerCharsCheckDesc", "pwdcannotcontainlowcharacters");
        } else if (policyName.equals("MinNumberNum")) {
            this.showPolicyMessage(policyName, "PwdMinNumbersCheckDesc", "pwdcannotcontainnumber");
        } else if (policyName.equals("MinSpecCharNum")) {
            this.showPolicyMessage(policyName, "PwdSpacialCharsCheckDesc", "pwdcannotcontainspecial");
        } else if (policyName.equals("MinUppercaseNum")) {
            this.showPolicyMessage(policyName, "PwdUpperCharsCheckDesc", "pwdcannotcontainuppercharacters");
        } else if (policyName.equals("MinNewOldPwdDiffNum")) {
            this.showPolicyMessage(policyName, "PwdMinNewOldPwdDiffNumDesc", "PwdMinNewOldPwdDiffNumDesc");
        } else if (policyName.equals("PwdExpireTipDays")) {
            this.showPolicyMessage(policyName, "PwdMinNewOldPwdDiffNumDesc", "PwdMinNewOldPwdDiffNumDesc");
        } else if (policyName.equals("MaxSameSubstringLenWithName")) {
            this.showPolicyMessage(policyName, "PwdCanNotContainsUserNameDesc", "PwdCanNotContainsUserNameDesc");
        } else if (policyName.equals("PasswordRepeatSeqCount")) {
            this.showPolicyMessage(policyName, "PwdRepeatTimeDesc", "PwdRepeatTimeDesc");
        } else if (policyName.equals("PasswordRepeatSeqCharacterNum")) {
            this.showPolicyMessage(policyName, "PwdRepeatSequenceLenDesc", "PwdRepeatSequenceLenDesc");
        } else if (policyName.equals("MaxHistoryPassCount")) {
            OptionPaneProxy4SmBase.showInformationDlg(FrameworkUtilities.getMainFrame(), ResCenter.RES.getString("PwdNotSimilarityNumberDesc"));
        } else if (policyName.equals("HistoryPassCharacterNum")) {
            OptionPaneProxy4SmBase.showInformationDlg(FrameworkUtilities.getMainFrame(), ResCenter.RES.getString("PwdContainsSimilarityWithSequenceLenDesc"));
        } else if (policyName.equals("HackerPassword")) {
            OptionPaneProxy4SmBase.showInformationDlg(FrameworkUtilities.getMainFrame(), ResCenter.RES.getString("PwdCanNotInHackerDesc"));
        } else if (policyName.equals("PwdHisMonth")) {
            this.showPolicyMessage(policyName, "PwdNotHistoryPasswordRepeatMonthCheckDesc", "PwdNotHistoryPasswordRepeatMonthCheckDesc");
        } else if (policyName.equals("NotAllowRestrictedChar")) {
            OptionPaneProxy4SmBase.showInformationDlg(FrameworkUtilities.getMainFrame(), ResCenter.RES.getString("NOT_ALLOW_RESTRICTED_CHAR"));
        } else {
            return false;
        }
        this.doSomethingObj.doSomethingAfterShowInfo(policyName);
        return true;
    }

    private void showPolicyMessage(String policyName, String policyResName, String defaultResValue) {
        Integer minValue = PolicyService.getInstance().getPolicyValue("MinPwdLength");
        Integer adminMinValue = PolicyService.getInstance().getPolicyValue("SuperUserMinPwdLength");
        Integer maxValue = PolicyService.getInstance().getPolicyValue("MaxPwdLength");
        if ("MinPwdLength".equals(policyName) && minValue.intValue() == maxValue.intValue()) {
            this.showSpecialHandleMessage(maxValue, ResCenter.RES.getString("MinPwdLengthSameWithMaxPwd"));
            return;
        }
        if ("MaxPwdLength".equals(policyName)) {
            if (this.isAdmin) {
                if (adminMinValue.intValue() == maxValue.intValue()) {
                    this.showSpecialHandleMessage(maxValue, ResCenter.RES.getString("MinPwdLengthSameWithMaxPwd"));
                    return;
                }
            } else if (minValue.intValue() == maxValue.intValue()) {
                this.showSpecialHandleMessage(maxValue, ResCenter.RES.getString("MinPwdLengthSameWithMaxPwd"));
                return;
            }
        }
        if ("SuperUserMinPwdLength".equals(policyName) && adminMinValue.intValue() == maxValue.intValue()) {
            this.showSpecialHandleMessage(maxValue, ResCenter.RES.getString("MinPwdLengthSameWithMaxPwd"));
            return;
        }
        Integer value = PolicyService.getInstance().getPolicyValue(policyName);
        if (value > 0) {
            this.showSpecialHandleMessage(value, ResCenter.RES.getString(policyResName));
        } else if (policyName.equals("MaxSameSubstringLenWithName") && value == 0) {
            OptionPaneProxy4SmBase.showInformationDlg(FrameworkUtilities.getMainFrame(), ResCenter.RES.getString("PwdCanNotContainsAllUserNameDesc"));
        } else if (null != defaultResValue) {
            OptionPaneProxy4SmBase.showInformationDlg(FrameworkUtilities.getMainFrame(), this.resCenter.getString(defaultResValue));
        }
    }

    private void showSpecialHandleMessage(Integer value, String message) {
        String bundleString = GuiUtilForBase.bundleString(message, String.valueOf(value));
        OptionPaneProxy4SmBase.showInformationDlg(FrameworkUtilities.getMainFrame(), bundleString);
    }

    private String getPolicyFromattedMessage(String policyName, String policyResName, String defaultResValue) {
        String bundleString = "";
        Integer value = PolicyService.getInstance().getPolicyValue(policyName);
        if (value > 0) {
            bundleString = GuiUtilForBase.bundleString(this.resCenter.getString(policyResName), String.valueOf(value));
        } else if (policyName.equals("MaxSameSubstringLenWithName") && value == 0) {
            bundleString = ResCenter.RES.getString("PwdCanNotContainsAllUserNameDesc");
        } else if (null != defaultResValue) {
            bundleString = this.resCenter.getString(defaultResValue);
        }
        return bundleString;
    }

    public String getPolicyErrorMsg(String policyName) {
        String policyErrorMsg = "";
        if (policyName.equals("Complex")) {
            policyErrorMsg = ResCenter.RES.getString("PwdCanNotContainsIncOrDecStrDesc");
        } else if (policyName.equals("EnPwdRevUName")) {
            policyErrorMsg = ResCenter.RES.getString("PwdRevUNameDesc");
        } else if (policyName.equals("MinNewOldPwdDiffNum")) {
            policyErrorMsg = this.getPolicyFromattedMessage(policyName, "PwdMinNewOldPwdDiffNumDesc", "PwdMinNewOldPwdDiffNumDesc");
        } else if (policyName.equals("MaxSameSubstringLenWithName")) {
            policyErrorMsg = this.getPolicyFromattedMessage(policyName, "PwdCanNotContainsUserNameDesc", "PwdCanNotContainsUserNameDesc");
        } else if (policyName.equals("HistoryPassCharacterNum")) {
            policyErrorMsg = ResCenter.RES.getString("PwdContainsSimilarityWithSequenceLenDesc");
        } else if (policyName.equals("PwdHisMonth")) {
            policyErrorMsg = this.getPolicyFromattedMessage(policyName, "PwdNotHistoryPasswordRepeatMonthCheckDesc", "PwdNotHistoryPasswordRepeatMonthCheckDesc");
        }
        return policyErrorMsg;
    }

    public String getPolicyErrorMsg(int errorCode) {
        String policyName = "";
        if (314 == errorCode) {
            policyName = "MaxSameSubstringLenWithName";
        } else if (315 == errorCode) {
            policyName = "EnPwdRevUName";
        } else if (317 == errorCode) {
            policyName = "Complex";
        } else if (319 == errorCode) {
            policyName = "MinNewOldPwdDiffNum";
        } else if (321 == errorCode) {
            policyName = "PwdHisMonth";
        } else if (322 == errorCode) {
            policyName = "HistoryPassCharacterNum";
        } else if (326 == errorCode) {
            return ResCenter.RES.getString("errdberrtxt0");
        }
        return this.getPolicyErrorMsg(policyName);
    }
}

