/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base.policy;

import com.swimap.sm.client.base.policy.IPolicy;
import com.swimap.sm.client.base.policy.member.PwdDictionaryPolicy;
import com.swimap.sm.client.base.policy.member.PwdHackerPasswordPolicy;
import com.swimap.sm.client.base.policy.member.PwdHistoryMonthPolicy;
import com.swimap.sm.client.base.policy.member.PwdHistoryPolicy;
import com.swimap.sm.client.base.policy.member.PwdIncOrDecSequencePolicy;
import com.swimap.sm.client.base.policy.member.PwdMaxLengthPolicy;
import com.swimap.sm.client.base.policy.member.PwdMaxValidDatePolicy;
import com.swimap.sm.client.base.policy.member.PwdMinLengthPolicy;
import com.swimap.sm.client.base.policy.member.PwdMinLetterPolicy;
import com.swimap.sm.client.base.policy.member.PwdMinLowerLetterPolicy;
import com.swimap.sm.client.base.policy.member.PwdMinNumberPolicy;
import com.swimap.sm.client.base.policy.member.PwdMinSpecialCharPolicy;
import com.swimap.sm.client.base.policy.member.PwdMinUpperLetterPolicy;
import com.swimap.sm.client.base.policy.member.PwdMinValidDatePolicy;
import com.swimap.sm.client.base.policy.member.PwdNewAndOldDiffCharPolicy;
import com.swimap.sm.client.base.policy.member.PwdOverduePromptDatePolicy;
import com.swimap.sm.client.base.policy.member.PwdPasswordRepeatSeqCharacterNumPolicy;
import com.swimap.sm.client.base.policy.member.PwdPasswordRepeatSeqCountPolicy;
import com.swimap.sm.client.base.policy.member.PwdSameSequencePolicy;
import com.swimap.sm.client.base.policy.member.PwdUserNamePolicy;
import com.swimap.sm.client.base.policy.member.PwdUserNameReOrderPolicy;
import com.swimap.sm.client.base.policy.member.UserActiveDatePolicy;
import com.swimap.sm.client.base.policy.member.UserActivePolicy;
import com.swimap.sm.client.base.policy.member.UserAdminLockedPolicy;
import com.swimap.sm.client.base.policy.member.UserAutoReleaseTimePolicy;
import com.swimap.sm.client.base.policy.member.UserGlobalAutoLockPolicy;
import com.swimap.sm.client.base.policy.member.UserLoginAttemptPolicy;
import com.swimap.sm.client.base.policy.member.UserLoginDelayTimePolicy;
import com.swimap.sm.client.base.policy.member.UserNameMinLengthPolicy;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class PolicyFactory {
    private static PolicyFactory instance = new PolicyFactory();
    private static Map<String, IPolicy> policyMap = new HashMap<String, IPolicy>();

    public static PolicyFactory getInstance() {
        return instance;
    }

    public IPolicy getPolicy(String name) {
        return policyMap.get(name);
    }

    public Collection<IPolicy> getPolicys() {
        return policyMap.values();
    }

    static {
        policyMap.put("UsedPassDict", new PwdDictionaryPolicy());
        policyMap.put("", new PwdHistoryPolicy());
        policyMap.put("PwdHisMonth", new PwdHistoryMonthPolicy());
        policyMap.put("Complex", new PwdIncOrDecSequencePolicy());
        policyMap.put("MinLowercaseNum", new PwdMinLowerLetterPolicy());
        policyMap.put("MaxPwdLength", new PwdMaxLengthPolicy());
        policyMap.put("MaxPwdValidDays", new PwdMaxValidDatePolicy());
        policyMap.put("MinPwdLength", new PwdMinLengthPolicy());
        policyMap.put("MinAlphabetNum", new PwdMinLetterPolicy());
        policyMap.put("MinPwdValidDays", new PwdMinValidDatePolicy());
        policyMap.put("MinNewOldPwdDiffNum", new PwdNewAndOldDiffCharPolicy());
        policyMap.put("MinNumberNum", new PwdMinNumberPolicy());
        policyMap.put("PwdExpireTipDays", new PwdOverduePromptDatePolicy());
        policyMap.put("", new PwdSameSequencePolicy());
        policyMap.put("MinSpecCharNum", new PwdMinSpecialCharPolicy());
        policyMap.put("MinUppercaseNum", new PwdMinUpperLetterPolicy());
        policyMap.put("MaxSameSubstringLenWithName", new PwdUserNamePolicy());
        policyMap.put("EnPwdRevUName", new PwdUserNameReOrderPolicy());
        policyMap.put("UserInvalidPolicy", new UserActivePolicy());
        policyMap.put("MaxNoLoginDays", new UserActiveDatePolicy());
        policyMap.put("SuperUserNotAllowLocked", new UserAdminLockedPolicy());
        policyMap.put("AutoUnlockTime", new UserAutoReleaseTimePolicy());
        policyMap.put("MaxLoginRetryNum", new UserLoginAttemptPolicy());
        policyMap.put("MinUserLength", new UserNameMinLengthPolicy());
        policyMap.put("UserInvalidLoginDelayTime", new UserLoginDelayTimePolicy());
        policyMap.put("SuperUserMinPwdLength", new PwdMinLengthPolicy("SuperUserMinPwdLength", 8, 1, ""));
        policyMap.put("PasswordRepeatSeqCount", new PwdPasswordRepeatSeqCountPolicy());
        policyMap.put("PasswordRepeatSeqCharacterNum", new PwdPasswordRepeatSeqCharacterNumPolicy());
        policyMap.put("MaxHistoryPassCount", new PwdPasswordRepeatSeqCountPolicy());
        policyMap.put("HistoryPassCharacterNum", new PwdPasswordRepeatSeqCountPolicy());
        policyMap.put("HackerPassword", new PwdHackerPasswordPolicy());
        policyMap.put("NotAllowRestrictedChar", new PwdHackerPasswordPolicy());
        policyMap.put("AutoLockMins", new UserGlobalAutoLockPolicy());
    }
}

