/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base.event.handle;

import com.swimap.external.dsf.base.rpc.DataRecord;
import com.swimap.external.dsf.base.rpc.RpcEvent;
import com.swimap.external.dsf.base.rpc.RpcMessage;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.sm.client.base.auth.SessionManager;
import com.swimap.sm.client.base.common.GuiUtilForBase;
import com.swimap.sm.client.base.common.OptionPaneProxy4SmBase;
import com.swimap.sm.client.base.common.ResourceProxy4Base;
import com.swimap.sm.client.base.event.IEventHandler;
import com.swimap.sm.client.loginui.common.LogoutProxy;
import com.swimap.sm.client.loginui.common.SMTraceProxy;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.SwingUtilities;

public class UserPwdChangedEventHandler
implements IEventHandler {
    private static final IviewLogger log = SMTraceProxy.getLogger(UserPwdChangedEventHandler.class);
    private static final String RESET_PASSWORD = "reset password";
    private static final String MODIFY_PASSWORD = "modify password";
    private static UserPwdChangedEventHandler instance = new UserPwdChangedEventHandler();
    private boolean hasShowMsgFlag = false;

    private UserPwdChangedEventHandler() {
    }

    public static UserPwdChangedEventHandler getInstance() {
        return instance;
    }

    @Override
    public boolean handle(RpcEvent event) {
        if (this.isResetPassword(event) || this.isModifyPassword(event)) {
            if (this.hasShowMsgFlag) {
                return true;
            }
            int sessionID = event.getMessage().getInt("SessionID");
            if (SessionManager.getInstance().getCurSessionID() == sessionID) {
                return true;
            }
            int userID = 0;
            ArrayList<Integer> userList = new ArrayList<Integer>();
            RpcMessage msg = event.getMessage();
            for (DataRecord record : msg.getTable("User")) {
                userID = record.getInt("userid");
                userList.add(userID);
            }
            if (userID == 0 || null == userList) {
                log.error((Object)"Data is null from DS event of PWD changed.");
                return false;
            }
            int curUserID = SessionManager.getInstance().getCurUser().id;
            boolean isCurUserID = userList.contains(curUserID);
            if (0 == curUserID || !isCurUserID) {
                return true;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (GuiUtilForBase.isbExit()) {
                        return;
                    }
                    UserPwdChangedEventHandler.this.hasShowMsgFlag = true;
                    LogoutProxy.getInstance().preLogout();
                    OptionPaneProxy4SmBase.showInformationDlg(FrameworkUtilities.getMainFrame(), ResourceProxy4Base.getInstance().getResource("sent_pwdChangedToExit"));
                    GuiUtilForBase.setToBeingExit();
                    LogoutProxy.getInstance().logout();
                    UserPwdChangedEventHandler.this.hasShowMsgFlag = false;
                }
            });
        }
        return true;
    }

    private boolean isModifyPassword(RpcEvent event) {
        RpcMessage msg = event.getMessage();
        Iterator i$ = msg.getTable("Param").iterator();
        if (i$.hasNext()) {
            DataRecord record = (DataRecord)i$.next();
            log.info((Object)record.get("paramname"));
            return MODIFY_PASSWORD.equals(record.get("paramname"));
        }
        return false;
    }

    private boolean isResetPassword(RpcEvent event) {
        RpcMessage msg = event.getMessage();
        Iterator i$ = msg.getTable("Param").iterator();
        if (i$.hasNext()) {
            DataRecord record = (DataRecord)i$.next();
            log.info((Object)record.get("paramname"));
            return RESET_PASSWORD.equals(record.get("paramname"));
        }
        return false;
    }
}

