/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base.event.handle;

import com.swimap.external.dsf.base.rpc.DataRecord;
import com.swimap.external.dsf.base.rpc.RpcEvent;
import com.swimap.external.sm.client.base.common.model.UserInfo;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.sm.client.base.autologout.AutoLogoutManager;
import com.swimap.sm.client.base.event.IEventHandler;
import com.swimap.sm.client.loginui.common.SMTraceProxy;
import java.util.Iterator;

public class UserInactivePolicyChangedEventHandler
implements IEventHandler {
    private IviewLogger log = SMTraceProxy.getLogger(UserInactivePolicyChangedEventHandler.class);
    private UserInfo curUser;
    private AutoLogoutManager autoLogoutMgr;

    public UserInactivePolicyChangedEventHandler(AutoLogoutManager autoLogoutMgr, UserInfo curUser) {
        this.autoLogoutMgr = autoLogoutMgr;
        this.curUser = curUser;
    }

    @Override
    public boolean handle(RpcEvent event) {
        try {
            if (this.needHandle(event)) {
                String userName = null;
                int autoLogoutTime = 0;
                for (DataRecord record : event.getMessage().getTable("User")) {
                    userName = record.get("username");
                }
                for (DataRecord record : event.getMessage().getTable("Param")) {
                    autoLogoutTime = record.getInt("paramvalue");
                }
                if (this.curUser.getName().equals(userName)) {
                    this.curUser.inactiveTime = autoLogoutTime;
                    if (autoLogoutTime != 0) {
                        this.curUser.isAutoLogout = true;
                        this.autoLogoutMgr.startTimer();
                    } else {
                        this.curUser.isAutoLogout = false;
                        this.autoLogoutMgr.stopTimer();
                    }
                }
                this.log.info((Object)("SecurityEvent | sessionInfoUserLocked() | Recieve a security Event==>user " + userName + " was logout ..."));
            }
        }
        catch (Exception e) {
            this.log.error((Object)"SecurityEvent | UserInactivePolicyChangedEventHandler with error.", (Throwable)e);
            return false;
        }
        return true;
    }

    private boolean needHandle(RpcEvent event) {
        Iterator i$ = event.getMessage().getTable("Param").iterator();
        if (i$.hasNext()) {
            DataRecord record = (DataRecord)i$.next();
            this.log.info((Object)record.get("paramname"));
            return "set logoutPolicy".equals(record.get("paramname"));
        }
        return false;
    }
}

