/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base.event.handle;

import com.swimap.external.dsf.base.rpc.DataRecord;
import com.swimap.external.dsf.base.rpc.DataTable;
import com.swimap.external.dsf.base.rpc.RpcEvent;
import com.swimap.external.dsf.base.rpc.RpcMessage;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.sm.client.base.adapt.UserChangedListenerHandler;
import com.swimap.sm.client.base.common.RpcInvoker;
import com.swimap.sm.client.base.event.IEventHandler;
import com.swimap.sm.client.loginui.common.SMTraceProxy;
import java.util.ArrayList;
import java.util.Map;

public class UserDeletedNotifyProductEventHandler
implements IEventHandler {
    private IviewLogger log = SMTraceProxy.getLogger(UserDeletedNotifyProductEventHandler.class);

    @Override
    public boolean handle(RpcEvent event) {
        RpcMessage message = event.getMessage();
        try {
            this.log.info((Object)"UserDeletedEventHandler start.");
            if (UserChangedListenerHandler.getInstance().isUserChangedListener()) {
                this.log.info((Object)"UserDeletedEventHandler | isUserChangedListener is Null.");
                return true;
            }
            DataTable table = message.getTable("ADDITIONAL");
            Map<String, Integer> allUsers = RpcInvoker.getInstance().getAllUserNameIDs(false);
            ArrayList<Integer> userIDs = new ArrayList<Integer>();
            for (DataRecord record : table) {
                Integer id = allUsers.get(record.get("user"));
                if (id == null) continue;
                userIDs.add(id);
            }
            UserChangedListenerHandler.getInstance().notifyUserDeleted(userIDs);
        }
        catch (Exception e) {
            this.log.error((Object)"SecurityEvent | smInfoUserDeleted with error.", (Throwable)e);
            return false;
        }
        return true;
    }
}

