/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base.event.handle;

import com.swimap.external.dsf.base.rpc.DataRecord;
import com.swimap.external.dsf.base.rpc.DataTable;
import com.swimap.external.dsf.base.rpc.RpcEvent;
import com.swimap.external.dsf.base.rpc.RpcMessage;
import com.swimap.external.sm.client.base.common.model.UserInfo;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.sm.client.base.event.IEventHandler;
import com.swimap.sm.client.base.event.handle.AccChangeHandler;
import com.swimap.sm.client.loginui.common.SMTraceProxy;

public class UserBelongGroupChangedEventHandler
implements IEventHandler {
    private IviewLogger log = SMTraceProxy.getLogger(UserBelongGroupChangedEventHandler.class);
    private UserInfo curUser;

    public UserBelongGroupChangedEventHandler(UserInfo curUser) {
        this.curUser = curUser;
    }

    @Override
    public boolean handle(RpcEvent event) {
        RpcMessage message = event.getMessage();
        String description = message.getString("Description");
        if (description.equals("user changed")) {
            DataTable userInfoTable = message.getTable("ADDITIONAL");
            for (DataRecord userInfo : userInfoTable) {
                if (userInfo.getInt("userid") != this.curUser.id) continue;
                this.log.info((Object)"SecurityEvent | accInfoGroupChanged() | Recieve a security Event==>the relation between current user and usergroup changed | Need handle this event...");
                AccChangeHandler.getInstance().startAccChangeTimer();
                break;
            }
            this.log.info((Object)"SecurityEvent | accInfoGroupChanged() | Recieve a security Event==>the relation between current user and usergroup changed | Do not handle this event...");
        }
        return true;
    }
}

