/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base.event.handle;

import com.swimap.external.dsf.base.rpc.DataRecord;
import com.swimap.external.dsf.base.rpc.DataTable;
import com.swimap.external.dsf.base.rpc.RpcEvent;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.sm.client.base.event.IEventHandler;
import com.swimap.sm.client.base.policy.service.PolicyService;

public class UserAutoLockEventHandler
implements IEventHandler {
    private IviewLogger log = IviewLogger.getLogger(UserAutoLockEventHandler.class);

    @Override
    public boolean handle(RpcEvent event) {
        DataTable policyTable = event.getMessage().getTable("ADDITIONAL");
        if (null == policyTable) {
            this.log.info((Object)"the policyTable(name=ADDITIONAL) is null,there is no policy in the RpcEvent");
            return false;
        }
        int autoLockMins = -10000;
        for (DataRecord policy : policyTable) {
            if (!"ACCOUNT_POLICY".equals(policy.get("type")) || !"AutoLockMins".equals(policy.get("policyName"))) continue;
            autoLockMins = policy.getInt("Value");
            if (autoLockMins >= -1 || autoLockMins <= -10000) break;
            autoLockMins = Math.abs(autoLockMins) + 30000;
            break;
        }
        if (-10000 == autoLockMins) {
            return false;
        }
        PolicyService.saveGlobalAutoLockTimeToLocal(autoLockMins);
        this.log.info((Object)(" in RpcEvent,globalAutoLockMins = " + autoLockMins));
        return true;
    }
}

