/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base.event.handle;

import com.swimap.external.dsf.base.rpc.RpcEvent;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.lm.client.UpdateLicenseManager;
import com.swimap.sm.client.base.StatusBarSettingProxy;
import com.swimap.sm.client.base.auth.ResCenter;
import com.swimap.sm.client.base.common.GuiUtilForBase;
import com.swimap.sm.client.base.common.OptionPaneProxy4SmBase;
import com.swimap.sm.client.base.common.RpcInvoker;
import com.swimap.sm.client.base.event.IEventHandler;
import com.swimap.sm.client.loginui.common.LogoutProxy;
import javax.swing.SwingUtilities;

public class RestrictedModeChangedEventHandler
implements IEventHandler {
    private RpcInvoker rpcInvoker;
    private ResCenter resCenter;
    private StatusBarSettingProxy statusBarSettingProxy;
    private GuiUtilForBase guiUtil;

    public RestrictedModeChangedEventHandler(StatusBarSettingProxy statusBarSettingProxy, ResCenter resCenter, GuiUtilForBase guiUtil, RpcInvoker rpcInvoker) {
        this.statusBarSettingProxy = statusBarSettingProxy;
        this.resCenter = resCenter;
        this.guiUtil = guiUtil;
        this.rpcInvoker = rpcInvoker;
    }

    @Override
    public boolean handle(RpcEvent event) {
        try {
            if (FrameworkCommandProcessor.getInstance().isLogin()) {
                boolean _isRestrictedMode = this.rpcInvoker.isSystemRestricted();
                UpdateLicenseManager.getInstance().setSystemRestrictMode(_isRestrictedMode);
                if (_isRestrictedMode && !this.statusBarSettingProxy.isRestrictedMode()) {
                    this.statusBarSettingProxy.setRestrictedMode(_isRestrictedMode);
                    this.statusBarSettingProxy.setSystemModeStatus();
                    this.guiUtil.setBlockEvent(true);
                    GuiUtilForBase.getInstance();
                    GuiUtilForBase.showHintMessageWithInvokeLater(this.resCenter.getString("RESTRICTED_MODE_CHANGED_HINT"));
                    this.guiUtil.setBlockEvent(false);
                } else if (!_isRestrictedMode && this.statusBarSettingProxy.isRestrictedMode()) {
                    this.statusBarSettingProxy.setRestrictedMode(_isRestrictedMode);
                    this.statusBarSettingProxy.setSystemModeStatus();
                    if (RpcInvoker.getInstance().getSystemMode() == 0) {
                        this.restrictedModeChangedHandle(this.resCenter.getString("UNRESTRICTED_MODE_CHANGED_HINT1"));
                    } else {
                        this.restrictedModeChangedHandle(this.resCenter.getString("UNRESTRICTED_MODE_CHANGED_HINT"));
                    }
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private void restrictedModeChangedHandle(final String _message) {
        this.guiUtil.setBlockEvent(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (0 == OptionPaneProxy4SmBase.showConfirmDlgFocOnNo(FrameworkUtilities.getMainFrame(), _message)) {
                    LogoutProxy.getInstance().logoutImmediately();
                } else {
                    RestrictedModeChangedEventHandler.this.guiUtil.setBlockEvent(false);
                }
            }
        });
    }
}

