/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base.event.handle;

import com.swimap.external.dsf.base.rpc.DataTable;
import com.swimap.external.dsf.base.rpc.RpcEvent;
import com.swimap.external.dsf.base.rpc.RpcMessage;
import com.swimap.external.sm.client.base.common.model.UserInfo;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.sm.client.base.auth.ResCenter;
import com.swimap.sm.client.base.common.GuiUtilForBase;
import com.swimap.sm.client.base.common.RpcInvoker;
import com.swimap.sm.client.base.event.IEventHandler;
import com.swimap.sm.client.base.event.handle.AccChangeHandler;
import com.swimap.sm.client.loginui.common.SMTraceProxy;
import java.util.Arrays;

public class GroupDevAccChangedEventHandler
implements IEventHandler {
    private IviewLogger log = SMTraceProxy.getLogger(GroupDevAccChangedEventHandler.class);
    private UserInfo curUser;
    private RpcInvoker rpcInvoker;

    public GroupDevAccChangedEventHandler(UserInfo curUser, RpcInvoker rpcInvoker) {
        this.curUser = curUser;
        this.rpcInvoker = rpcInvoker;
    }

    @Override
    public boolean handle(RpcEvent event) {
        RpcMessage message = event.getMessage();
        try {
            String oprType = message.getString("Domain");
            if (this.isGrantDeviceType(oprType)) {
                return true;
            }
            boolean isMatch = false;
            int[] groups = this.rpcInvoker.getGroupsByUser(this.curUser.id);
            this.log.info((Object)("users group:" + Arrays.toString(groups)));
            if (this.isAccessUpdate(event)) {
                String group = message.getString("Role");
                this.log.info((Object)("event:" + group));
                String[] items = group.split(",");
                Arrays.sort(groups);
                for (int i = 0; i < items.length; ++i) {
                    if (items[i].trim().isEmpty() || Arrays.binarySearch(groups, Integer.valueOf(items[i].trim())) < 0) continue;
                    isMatch = true;
                    break;
                }
            } else {
                DataTable userGroupTable = message.getTable("ADDITIONAL");
                for (int i = 0; i < groups.length; ++i) {
                    for (int j = 0; j < userGroupTable.size(); ++j) {
                        int userOwedGroupID = groups[i];
                        int accChgedGroupID = userGroupTable.get(j).getInt("groupid");
                        if (userOwedGroupID != accChgedGroupID) continue;
                        isMatch = true;
                        break;
                    }
                    if (!isMatch) {
                        continue;
                    }
                    break;
                }
            }
            if (isMatch) {
                if (this.isTopoOperation(oprType)) {
                    if (FrameworkCommandProcessor.getInstance().isLogin()) {
                        GuiUtilForBase.showRightChangeBubble(ResCenter.RES.getString("Binding_Relation_Changed_Bubble"));
                        this.log.info((Object)"just show bubble! ");
                    }
                } else {
                    this.log.info((Object)"SecurityEvent | accInfoDevAccChanged() | Recieve a security Event==>the relation between current user and usergroup changed | Need handle this event...");
                    AccChangeHandler.getInstance().startAccChangeTimer();
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)"SecurityEvent | accInfoDevAccChanged with error.", (Throwable)e);
            return false;
        }
        return true;
    }

    private boolean isAccessUpdate(RpcEvent event) {
        int mainType = event.getMessage().getInt("MainType");
        int subType = event.getMessage().getInt("SubType");
        StringBuilder sb = new StringBuilder();
        sb.append(mainType);
        sb.append(":");
        sb.append(subType);
        return "3:2".equals(sb.toString());
    }

    private boolean isTopoOperation(String oprType) {
        return "updateNEAccess".equals(oprType) || "deleteSN".equals(oprType) || "moveNE".equals(oprType) || "moveSubnet".equals(oprType);
    }

    private boolean isGrantDeviceType(String oprType) {
        return "registerPolicy".equals(oprType) || "deregisterPolicy".equals(oprType);
    }
}

