/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base.event.handle;

import com.swimap.external.dsf.base.rpc.RpcEvent;
import com.swimap.external.dsf.base.rpc.RpcMessage;
import com.swimap.external.sm.client.base.common.model.UserInfo;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.sm.client.base.auth.ResCenter;
import com.swimap.sm.client.base.common.GuiUtilForBase;
import com.swimap.sm.client.base.event.IEventHandler;
import com.swimap.sm.client.loginui.common.SMTraceProxy;

public class CurrentUserAccoutValidityChangedEventHandler
implements IEventHandler {
    private IviewLogger log = SMTraceProxy.getLogger(CurrentUserAccoutValidityChangedEventHandler.class);
    private ResCenter resCenter;
    private GuiUtilForBase guiUtilBase;
    private UserInfo curUser;

    public CurrentUserAccoutValidityChangedEventHandler(UserInfo curUser, ResCenter resCenter, GuiUtilForBase guiUtilBase) {
        this.curUser = curUser;
        this.resCenter = resCenter;
        this.guiUtilBase = guiUtilBase;
    }

    @Override
    public boolean handle(RpcEvent event) {
        int userID;
        this.log.info((Object)("an user's account valid changed. " + event.getMessage().getString("Description")));
        RpcMessage message = event.getMessage();
        if (this.needHandle(message) && (userID = message.getInt("logoutUserID")) == this.curUser.id) {
            String userName = this.curUser.getUserName();
            this.log.info((Object)("log out current user for account invalid===" + userName));
            this.guiUtilBase.handleExitActionEx(this.resCenter.getString("account_invalid_exit"));
            return true;
        }
        return true;
    }

    private boolean needHandle(RpcMessage message) {
        return "SM_LOGOUT_USER_BE_DISABLED".equals(message.getString("Description"));
    }
}

