/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base.event.handle;

import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.sm.client.base.auth.ResCenter;
import com.swimap.sm.client.base.common.OptionPaneProxy4SmBase;
import com.swimap.sm.client.base.config.SecurityConfig;
import com.swimap.sm.client.loginui.common.LogoutProxy;
import com.swimap.sm.client.loginui.common.SMTraceProxy;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;

public class AccChangeHandler {
    private IviewLogger log = SMTraceProxy.getLogger(AccChangeHandler.class);
    private static AccChangeHandler instance;
    private Timer accChangeTimer;
    private AccChangeTimerTask accChangeTimerTask;
    private boolean accChangePopActive = true;

    public static synchronized AccChangeHandler getInstance() {
        if (null == instance) {
            instance = new AccChangeHandler();
        }
        return instance;
    }

    public static synchronized void clearInstance() {
        instance = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAccChangePrompt() {
        this.setAccChangePopActive(false);
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                if (FrameworkCommandProcessor.getInstance().isLogin()) {
                    if (0 == OptionPaneProxy4SmBase.showConfirmDlgFocOnNo(FrameworkUtilities.getMainFrame(), ResCenter.RES.getString("Binding_Relation_Changed"))) {
                        this.log.info((Object)"user click yes!");
                        LogoutProxy.getInstance().logoutImmediately();
                    } else {
                        this.log.info((Object)"user click no! ");
                    }
                }
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        if (FrameworkCommandProcessor.getInstance().isLogin()) {
                            if (0 == OptionPaneProxy4SmBase.showConfirmDlgFocOnNo(FrameworkUtilities.getMainFrame(), ResCenter.RES.getString("Binding_Relation_Changed"))) {
                                AccChangeHandler.this.log.info((Object)"user click yes!");
                                LogoutProxy.getInstance().logoutImmediately();
                            } else {
                                AccChangeHandler.this.log.info((Object)"user click no! ");
                            }
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            this.log.error((Object)"AccChangeHandler Exception! ", (Throwable)e);
        }
        finally {
            this.setAccChangePopActive(true);
        }
    }

    public synchronized void startAccChangeTimer() {
        if (this.isAccChangePopActive()) {
            this.DelAccChangeTimer();
            this.createAccChangeTimer();
        } else {
            this.log.info((Object)"no need to create access change timer! ");
        }
    }

    public void DelAccChangeTimer() {
        if (null != this.accChangeTimer) {
            this.accChangeTimer.cancel();
            this.accChangeTimer = null;
        } else {
            this.log.info((Object)"the accchangetimer is null");
        }
    }

    private void createAccChangeTimer() {
        this.accChangeTimer = new Timer();
        this.accChangeTimerTask = new AccChangeTimerTask();
        this.accChangeTimer.schedule((TimerTask)this.accChangeTimerTask, SecurityConfig.getInstance().getAccChangePromptDelaySetting());
    }

    private boolean isAccChangePopActive() {
        return this.accChangePopActive;
    }

    private synchronized void setAccChangePopActive(boolean accChangePopActive) {
        this.log.info((Object)("old accChangePopActive: " + this.accChangePopActive));
        this.accChangePopActive = accChangePopActive;
        this.log.info((Object)("new accChangePopActive: " + this.accChangePopActive));
    }

    private class AccChangeTimerTask
    extends TimerTask {
        private AccChangeTimerTask() {
        }

        @Override
        public void run() {
            AccChangeHandler.this.handleAccChangePrompt();
        }
    }
}

