/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base.event.handle;

import com.swimap.external.dsf.base.rpc.RpcEvent;
import com.swimap.external.dsf.base.rpc.RpcMessage;
import com.swimap.external.sm.client.base.common.TraceProxy;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.sm.client.base.SessionService;
import com.swimap.sm.client.base.common.GuiUtilForBase;
import com.swimap.sm.client.base.common.ResourceProxy4Base;
import com.swimap.sm.client.base.event.IEventHandler;

public class ACLChangedEventHandler
implements IEventHandler {
    private static final IviewLogger log = TraceProxy.getLogger(ACLChangedEventHandler.class);
    private static ACLChangedEventHandler instance = new ACLChangedEventHandler();
    private static final String SM_LOGOUT_NOT_IN_ACL = "SM_LOGOUT_NOT_IN_ACL";

    public static ACLChangedEventHandler getInstance() {
        return instance;
    }

    @Override
    public boolean handle(RpcEvent event) {
        RpcMessage msg = event.getMessage();
        if (this.isACLChangedEvent(event)) {
            try {
                log.info((Object)"start");
                int sessionID = msg.getInt("logoutSessionID");
                if (sessionID == SessionService.getInstance().getCurSessionID()) {
                    log.info((Object)"user IP is set invalid.");
                    GuiUtilForBase.handleExitAction(ResourceProxy4Base.getInstance().getResource("ACL_Changed_Exit_Hint"));
                }
            }
            catch (Exception e) {
                log.error((Object)"sessionOut with error.", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    private boolean isACLChangedEvent(RpcEvent event) {
        String description = event.getMessage().getString("Description");
        log.info((Object)("messageDescription: " + description));
        return SM_LOGOUT_NOT_IN_ACL.equals(description);
    }
}

