/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base.event;

import com.swimap.external.dsf.base.rpc.RpcEvent;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.sm.client.base.event.EventRegisterFactory;
import com.swimap.sm.client.base.event.IEventHandler;
import com.swimap.sm.client.loginui.common.SMTraceProxy;
import java.util.Vector;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

class SMEventExecutor {
    private static final IviewLogger log = SMTraceProxy.getLogger(SMEventExecutor.class);
    private static final int SIZE_EVENT_QUEUE = 100;
    private static final SMEventExecutor instance = new SMEventExecutor();
    private ThreadPoolExecutor eventExecutor;
    private LinkedBlockingQueue<Runnable> eventQueue = new LinkedBlockingQueue();

    private SMEventExecutor() {
        this.eventExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, this.eventQueue);
    }

    static SMEventExecutor getInstance() {
        return instance;
    }

    void execute(String key, RpcEvent event) {
        Vector<IEventHandler> handlerList = EventRegisterFactory.create().getHandlers().get(key);
        if (null != handlerList) {
            if (this.eventQueue.size() > 100) {
                log.warn((Object)("EventQueue: " + this.eventQueue.size()));
            }
            this.eventExecutor.execute(new EventRunnable(event, handlerList));
        }
    }

    private class EventRunnable
    implements Runnable {
        Vector<IEventHandler> handlers;
        RpcEvent event;

        EventRunnable(RpcEvent event, Vector<IEventHandler> handlers) {
            this.event = event;
            this.handlers = handlers;
        }

        @Override
        public void run() {
            for (IEventHandler handler : this.handlers) {
                handler.handle(this.event);
            }
        }
    }
}

