/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base.event;

import com.swimap.external.dsf.base.rpc.RpcEvent;
import com.swimap.external.dsf.base.rpc.RpcServerPush;
import com.swimap.external.dsf.base.rpc.RpcServerPushHandler;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.sm.client.base.common.GuiUtilForBase;
import com.swimap.sm.client.base.event.SMEventExecutor;
import com.swimap.sm.client.loginui.common.SMTraceProxy;
import java.util.HashSet;
import java.util.Set;

public class SMEventDispatch
implements RpcServerPushHandler {
    private IviewLogger log = SMTraceProxy.getLogger(SMEventDispatch.class);
    private int curSessionId;
    private Set<String> mustProcessCache = new HashSet<String>();
    private static SMEventDispatch instance = null;

    public static SMEventDispatch getInstance() {
        if (instance == null) {
            instance = new SMEventDispatch();
        }
        return instance;
    }

    private SMEventDispatch() {
        this.mustProcessCache.add("3:6");
        this.mustProcessCache.add("3:2");
        this.mustProcessCache.add("2:25");
        this.mustProcessCache.add("3:8");
        this.mustProcessCache.add("2:7");
        this.mustProcessCache.add("2:22");
        this.mustProcessCache.add("1:6");
    }

    public void setCurSessionId(int curSessionId) {
        this.curSessionId = curSessionId;
    }

    public void handleServerPush(RpcEvent event) {
        if (this.isSMEvent(event) && this.isCanProcessEvent()) {
            int mainType = event.getMessage().getInt("MainType");
            int subType = event.getMessage().getInt("SubType");
            this.log.info((Object)("SecurityEventProcessor | processEvent | get security event, maintype is:<" + mainType + '>' + " sub type is:<" + subType + '>'));
            if (this.isMustProcess(this.getEventKey(mainType, subType)) || !this.isCurrentSession(event)) {
                SMEventExecutor.getInstance().execute(this.getEventKey(mainType, subType), event);
            } else {
                this.log.info((Object)"SMEventDispatch | handleServerPush | Triggered by myself. no need to handle...");
            }
        }
    }

    private boolean isMustProcess(String key) {
        return this.mustProcessCache.contains(key);
    }

    public void start() {
        RpcServerPush.addHandler((String)"SMEventManager.SecurityManagerEvent", (RpcServerPushHandler)this);
        RpcServerPush.addHandler((String)"SMEventManager.SecurityManagerEventInternal", (RpcServerPushHandler)this);
    }

    public void stop() {
        RpcServerPush.removeHandler((RpcServerPushHandler)this);
    }

    public String getEventKey(int mainType, int subType) {
        StringBuilder builder = new StringBuilder();
        builder.append(mainType);
        builder.append(':');
        builder.append(subType);
        return builder.toString();
    }

    private boolean isSMEvent(RpcEvent event) {
        return event.getType().equals("SMEventManager.SecurityManagerEvent") || event.getType().equals("SMEventManager.SecurityManagerEventInternal");
    }

    private boolean isCurrentSession(RpcEvent event) {
        return event.getMessage().getInt("SessionID") == this.curSessionId;
    }

    private boolean isCanProcessEvent() {
        if (GuiUtilForBase.isbExit()) {
            this.log.info((Object)("GuiUtilForBase.bExit is " + GuiUtilForBase.isbExit()));
            return false;
        }
        while (!GuiUtilForBase.isLoginFinished) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                this.log.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return true;
    }
}

