/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base.event;

import com.swimap.external.dsf.base.rpc.RpcEvent;
import com.swimap.external.dsf.base.rpc.RpcServerPush;
import com.swimap.external.dsf.base.rpc.RpcServerPushHandler;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.sm.client.base.event.EventRegisterFactory;
import com.swimap.sm.client.base.event.IEventHandler;
import com.swimap.sm.client.base.event.IEventRegister;
import com.swimap.sm.client.loginui.common.SMTraceProxy;
import java.util.Vector;

public class LogEventDispatch
implements RpcServerPushHandler {
    private IviewLogger log = SMTraceProxy.getLogger(LogEventDispatch.class);
    private IEventRegister register = EventRegisterFactory.create();
    private static LogEventDispatch instance = null;

    public static LogEventDispatch getInstance() {
        if (instance == null) {
            instance = new LogEventDispatch();
        }
        return instance;
    }

    public void handleServerPush(RpcEvent event) {
        if (this.isLogEvent(event)) {
            this.dispatch(event);
        }
    }

    private void dispatch(RpcEvent event) {
        Vector<IEventHandler> handlerList = this.register.getHandlers().get("AuditEvent.AuditEvent");
        if (handlerList == null || handlerList.isEmpty()) {
            this.log.info((Object)("get log event, handlerList is:" + handlerList));
        } else {
            for (IEventHandler handler : handlerList) {
                handler.handle(event);
            }
        }
    }

    public void start() {
        RpcServerPush.addHandler((String)"AuditEvent.AuditEvent", (RpcServerPushHandler)this);
    }

    public void stop() {
        RpcServerPush.removeHandler((RpcServerPushHandler)this);
    }

    private boolean isLogEvent(RpcEvent event) {
        return event.getType().equals("AuditEvent.AuditEvent");
    }
}

