/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base.event;

import com.swimap.sm.client.base.event.IEventHandler;
import com.swimap.sm.client.base.event.IEventRegister;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

public class EventRegister
implements IEventRegister {
    private Map<String, Vector<IEventHandler>> handlers = new ConcurrentHashMap<String, Vector<IEventHandler>>();

    @Override
    public Map<String, Vector<IEventHandler>> getHandlers() {
        return this.handlers;
    }

    @Override
    public void register(String key, IEventHandler handler) {
        Vector<IEventHandler> handlerList = this.handlers.get(key);
        if (handlerList == null) {
            handlerList = new Vector(2);
        }
        handlerList.add(handler);
        this.handlers.put(key, handlerList);
    }

    @Override
    public void unRegister(String key) {
        this.handlers.remove(key);
    }

    @Override
    public void unRegisterHandler(String key, IEventHandler handle) {
        Vector<IEventHandler> handlerList = this.handlers.get(key);
        if (handlerList == null || handlerList.size() == 0) {
            return;
        }
        for (IEventHandler h : handlerList) {
            if (!h.equals(handle)) continue;
            handlerList.remove(h);
            return;
        }
    }

    @Override
    public void unRegisterAll() {
        this.handlers.clear();
    }
}

